/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.SSAMessage;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNChangeSource;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SSN
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 4376951375392165841L;
    private Relation relation = null;
    private String ssnText = null;
    private SSNType type = null;
    private PseudoSSNReason pseudoSSNReason;
    private SSAMessage ssaMessage = null;
    private Date ssaSentDate = null;
    private Date ssaReceivedDate = null;
    private Date ssaVerificationDate = null;
    private SSAVerificationStatus ssaVerificationStatus = null;
    private SSNChangeSource sourceOfChange = null;

    protected void buildToString(ToStringBuilder builder) {
        builder.append("ssnText", (Object)this.ssnText);
        builder.append("ssaVerificationStatus", (Object)this.ssaVerificationStatus);
        builder.append("sourceOfChange", (Object)this.sourceOfChange);
        builder.append("ssaSentDate", (Object)this.ssaSentDate);
        builder.append("ssaReceivedDate", (Object)this.ssaReceivedDate);
        builder.append("ssaVerificationDate", (Object)this.ssaVerificationDate);
        super.buildToString(builder);
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Relation relation) {
        this.validateOwner(this.relation, relation);
        this.relation = relation;
    }

    public String getSsnText() {
        return this.ssnText;
    }

    public void setSsnText(String ssnText) {
        this.ssnText = ssnText;
    }

    public String getFormattedSsnText() {
        return SSN.formatSSN(this.ssnText);
    }

    public static String formatSSN(String unformattedSSN) {
        String temp = unformattedSSN != null ? StringUtils.remove((String)unformattedSSN, (char)'-') : null;
        temp = temp != null ? StringUtils.remove((String)temp, (char)' ') : null;
        return temp;
    }

    public SSNType getType() {
        return this.type;
    }

    public void setType(SSNType type) {
        this.type = type;
    }

    public SSAMessage getSsaMessage() {
        return this.ssaMessage;
    }

    public void setSsaMessage(SSAMessage message) {
        this.ssaMessage = message;
    }

    public PseudoSSNReason getPseudoSSNReason() {
        return this.pseudoSSNReason;
    }

    public void setPseudoSSNReason(PseudoSSNReason pseudoSSNReason) {
        this.pseudoSSNReason = pseudoSSNReason;
    }

    public Date getSsaVerificationDate() {
        return this.ssaVerificationDate;
    }

    public void setSsaVerificationDate(Date ssaSentDate) {
        this.ssaVerificationDate = ssaSentDate;
    }

    public Date getSsaReceivedDate() {
        return this.ssaReceivedDate;
    }

    public void setSsaReceivedDate(Date ssaReceivedDate) {
        this.ssaReceivedDate = ssaReceivedDate;
    }

    public Date getSsaSentDate() {
        return this.ssaSentDate;
    }

    public void setSsaSentDate(Date ssaSentDate) {
        this.ssaSentDate = ssaSentDate;
    }

    public SSAVerificationStatus getSsaVerificationStatus() {
        return this.ssaVerificationStatus;
    }

    public void setSsaVerificationStatus(SSAVerificationStatus ssaVerificationStatus) {
        this.ssaVerificationStatus = ssaVerificationStatus;
    }

    public SSNChangeSource getSourceOfChange() {
        return this.sourceOfChange;
    }

    public void setSourceOfChange(SSNChangeSource sourceOfChange) {
        this.sourceOfChange = sourceOfChange;
    }

    public boolean isSsaVerificationStatusVerified() {
        return this.ssaVerificationStatus != null && SSAVerificationStatus.VERIFIED.getCode().equals(this.ssaVerificationStatus.getCode());
    }

    public static SSN getSSNOfType(Set ssns, String typeCode) {
        Validate.notNull((Object)typeCode, (String)"Ssn type code can not be null.");
        for (SSN ssn : ssns) {
            if (!SSN.isTypeEqual(ssn, typeCode)) continue;
            return ssn;
        }
        return null;
    }

    public static Set getSSNsOfType(Set ssns, String typeCode) {
        Validate.notNull((Object)typeCode, (String)"Ssn type code can not be null.");
        HashSet<SSN> typeSsns = new HashSet<SSN>();
        for (SSN ssn : ssns) {
            if (!SSN.isTypeEqual(ssn, typeCode)) continue;
            typeSsns.add(ssn);
        }
        return typeSsns;
    }

    private static boolean isTypeEqual(SSN ssn, String typeCode) {
        return ssn != null && ssn.getType() != null && typeCode.equals(ssn.getType().getCode());
    }

    public static boolean isValidSSN(String ssnStr) {
        if (ssnStr == null) {
            return false;
        }
        ssnStr = ssnStr.replaceAll("-", "");
        String[] startWiths = new String[]{"000", "00000"};
        return ssnStr.length() == 9 && StringUtils.isNumeric((String)ssnStr) && !StringUtils.isSameCharString((String)ssnStr) && !StringUtils.startsWith((String)ssnStr, (String[])startWiths) && !ssnStr.startsWith("00", 3) && !ssnStr.endsWith("0000") && !"123456789".equals(ssnStr);
    }
}

