/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EnrollmentApplication
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -1438723888583757286L;
    private ApplicationMethod applicationMethod;
    private ApplicationStatus applicationStatus;
    private BigDecimal personId;
    private Date applicationDate;
    private Date signatureDate;
    private String lastName;
    private String firstName;
    private String middleName;
    private Date dateOfBirth;
    private String ssn;
    private Gender gender = null;
    private String icn;
    private Set internalApplicationInProcesses = null;
    private int hashValue = 0;

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public ApplicationMethod getApplicationMethod() {
        return this.applicationMethod;
    }

    public void setApplicationMethod(ApplicationMethod applicationMethod) {
        this.applicationMethod = applicationMethod;
    }

    public ApplicationStatus getApplicationStatus() {
        return this.applicationStatus;
    }

    public void setApplicationStatus(ApplicationStatus applicationStatus) {
        this.applicationStatus = applicationStatus;
    }

    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public BigDecimal getPersonId() {
        return this.personId;
    }

    public void setPersonId(BigDecimal personId) {
        this.personId = personId;
    }

    public Date getSignatureDate() {
        return this.signatureDate;
    }

    public void setSignatureDate(Date signatureDate) {
        this.signatureDate = signatureDate;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    private Set getInternalApplicationInProcesses() {
        if (this.internalApplicationInProcesses == null) {
            this.internalApplicationInProcesses = new HashSet();
        }
        return this.internalApplicationInProcesses;
    }

    private void setInternalApplicationInProcesses(Set internalApplicationInProcesses) {
        this.internalApplicationInProcesses = internalApplicationInProcesses;
    }

    public ApplicationInProcess getApplicationInProcess() {
        Set aips = this.getInternalApplicationInProcesses();
        if (aips.size() > 0) {
            return (ApplicationInProcess)((Object)aips.iterator().next());
        }
        return null;
    }

    public void setApplicationInProcess(ApplicationInProcess applicationInProcess) {
        Set aips = this.getInternalApplicationInProcesses();
        aips.clear();
        if (applicationInProcess != null) {
            aips.add(applicationInProcess);
            applicationInProcess.setEnrollmentApplication(this);
        }
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        if (rhs.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EnrollmentApplication that = (EnrollmentApplication)((Object)rhs);
        return this.isEqual(this.getIdentifier(), that.getIdentifier()) && this.isEqual(this.icn, that.icn) && this.isEqual(this.ssn, that.ssn) && this.isEqual(this.personId, that.personId) && this.isEqual((Object)this.applicationStatus, (Object)that.applicationStatus) && this.isEqual(this.internalApplicationInProcesses, that.internalApplicationInProcesses);
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : a.equals(b);
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            int result = 17;
            int idValue = this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode();
            result = result * 37 + idValue;
            result = result * 37 + this.icn.hashCode();
            result = result * 37 + this.ssn.hashCode();
            if (this.personId != null) {
                result = result * 37 + this.personId.hashCode();
            }
            result = result * 37 + this.applicationStatus.hashCode();
            if (this.internalApplicationInProcesses != null) {
                result = result * 37 + ((Object)this.internalApplicationInProcesses).hashCode();
            }
            this.hashValue = result;
        }
        return this.hashValue;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("applicationMethod", (Object)this.applicationMethod);
        builder.append("applicationStatus", (Object)this.applicationStatus);
        builder.append("personId", (Object)this.personId);
        builder.append("applicationDate", (Object)this.applicationDate);
        builder.append("signatureDate", (Object)this.signatureDate);
        builder.append("lastName", (Object)this.lastName);
        builder.append("firstName", (Object)this.firstName);
        builder.append("middleName", (Object)this.middleName);
        builder.append("dateOfBirth", (Object)this.dateOfBirth);
        builder.append("ssn", (Object)this.ssn);
        builder.append("gender", (Object)this.gender);
    }
}

