/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.party;

import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SimpleAddress
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = -657131108996597435L;
    private AddressType type;
    private String internalLine1;
    private String internalLine2;
    private String internalLine3;
    private String internalCity;
    private String internalCounty;
    private String internalState;
    private String internalProvince;
    private String internalZipCode;
    private String internalZipPlus4;
    private String internalPostalCode;
    private String internalCountry;
    private Country countryObject;
    private static ArrayList COMPARE_LIST = new ArrayList();

    public boolean isUSAddress() {
        return Country.isUSAddress(this.internalCountry);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.getLine1()) && StringUtils.isBlank((String)this.getLine2()) && StringUtils.isBlank((String)this.getLine3()) && StringUtils.isBlank((String)this.getCity()) && StringUtils.isBlank((String)this.getCounty()) && StringUtils.isBlank((String)this.getState()) && StringUtils.isBlank((String)this.getProvince()) && StringUtils.isBlank((String)this.getZipCode()) && StringUtils.isBlank((String)this.getZipPlus4()) && StringUtils.isBlank((String)this.getPostalCode()) && StringUtils.isBlank((String)this.getCountry());
    }

    public boolean isPermanent() {
        return this.type != null && AddressType.CODE_PERMANENT_ADDRESS.getCode().equals(this.type.getCode());
    }

    public boolean isTemporary() {
        return this.type != null && AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getCode().equals(this.type.getCode());
    }

    public boolean isConfidential() {
        return this.type != null && AddressType.CODE_CONFIDENTIAL_ADDRESS.getCode().equals(this.type.getCode());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        SimpleAddress otherAddress = (SimpleAddress)object;
        try {
            for (int i = 0; i < COMPARE_LIST.size(); ++i) {
                String property = (String)COMPARE_LIST.get(i);
                String thisValue = (String)PropertyUtils.getProperty((Object)this, (String)property);
                String otherValue = (String)PropertyUtils.getProperty((Object)otherAddress, (String)property);
                if (!StringUtils.isEmpty((String)thisValue)) {
                    if (!StringUtils.isEmpty((String)otherValue)) {
                        int comparisonValue = thisValue.compareTo(otherValue);
                        if (comparisonValue == 0) continue;
                        return comparisonValue;
                    }
                    return 1;
                }
                if (StringUtils.isEmpty((String)otherValue)) continue;
                return -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    public AddressType getType() {
        return this.type;
    }

    public void setType(AddressType addressType) {
        this.type = addressType;
    }

    public String getLine1() {
        return this.internalLine1 != null ? StringEscapeUtils.escapeXml((String)this.internalLine1.toUpperCase()) : null;
    }

    public void setLine1(String line1) {
        if (line1 != null) {
            line1 = line1.toUpperCase();
        }
        this.internalLine1 = line1;
    }

    public String getLine2() {
        return this.internalLine2 != null ? StringEscapeUtils.escapeXml((String)this.internalLine2.toUpperCase()) : null;
    }

    public void setLine2(String line2) {
        if (line2 != null) {
            line2 = line2.toUpperCase();
        }
        this.internalLine2 = line2;
    }

    public String getLine3() {
        return this.internalLine3 != null ? StringEscapeUtils.escapeXml((String)this.internalLine3.toUpperCase()) : null;
    }

    public void setLine3(String line3) {
        if (line3 != null) {
            line3 = line3.toUpperCase();
        }
        this.internalLine3 = line3;
    }

    public String getCity() {
        return this.internalCity != null ? StringEscapeUtils.escapeXml((String)this.internalCity.toUpperCase()) : null;
    }

    public void setCity(String city) {
        if (city != null) {
            city = city.toUpperCase();
        }
        this.internalCity = city;
    }

    public String getCountry() {
        return this.internalCountry != null ? StringEscapeUtils.escapeXml((String)this.internalCountry.toUpperCase()) : null;
    }

    public void setCountry(String country) {
        this.internalCountry = country;
    }

    public Country getCountryObject() {
        return this.countryObject;
    }

    public void setCountryObject(Country countryObject) {
        this.countryObject = countryObject;
    }

    public String getCounty() {
        return this.internalCounty != null ? StringEscapeUtils.escapeXml((String)this.internalCounty.toUpperCase()) : null;
    }

    public void setCounty(String county) {
        if (county != null) {
            county = county.toUpperCase();
        }
        this.internalCounty = county;
    }

    public String getPostalCode() {
        return this.internalPostalCode != null ? StringEscapeUtils.escapeXml((String)this.internalPostalCode.toUpperCase()) : null;
    }

    public void setPostalCode(String postalCode) {
        if (postalCode != null) {
            postalCode = postalCode.toUpperCase();
        }
        this.internalPostalCode = postalCode;
    }

    public String getProvince() {
        return this.internalProvince != null ? this.internalProvince.toUpperCase() : null;
    }

    public void setProvince(String province) {
        if (province != null) {
            province = province.toUpperCase();
        }
        this.internalProvince = province;
    }

    public String getState() {
        return this.internalState != null ? StringEscapeUtils.escapeXml((String)this.internalState.toUpperCase()) : null;
    }

    public void setState(String state) {
        if (state != null) {
            state = state.toUpperCase();
        }
        this.internalState = state;
    }

    public String getZipCode() {
        return this.internalZipCode != null ? StringEscapeUtils.escapeXml((String)this.internalZipCode.toUpperCase()) : null;
    }

    public void setZipCode(String zipCode) {
        if (zipCode != null) {
            zipCode = zipCode.toUpperCase();
        }
        this.internalZipCode = zipCode;
    }

    public String getZipPlus4() {
        return this.internalZipPlus4 != null ? StringEscapeUtils.escapeXml((String)this.internalZipPlus4.toUpperCase()) : null;
    }

    public void setZipPlus4(String zipPlus4) {
        if (zipPlus4 != null) {
            zipPlus4 = zipPlus4.toUpperCase();
        }
        this.internalZipPlus4 = zipPlus4;
    }

    public String getFormattedAddress() {
        StringBuffer resultBuffer = new StringBuffer();
        this.appendAddressPieceOnNewLine(resultBuffer, this.getLine1());
        this.appendAddressPieceOnNewLine(resultBuffer, this.getLine2());
        this.appendAddressPieceOnNewLine(resultBuffer, this.getLine3());
        String stateProvince = null;
        String zipPostalCode = null;
        if (Country.isUSAddress(this.getCountry())) {
            stateProvince = this.getState();
            zipPostalCode = this.getZipCode();
            if (StringUtils.isNotEmpty((String)zipPostalCode) && StringUtils.isNotEmpty((String)this.getZipPlus4())) {
                zipPostalCode = zipPostalCode + "-" + this.getZipPlus4();
            }
        } else {
            stateProvince = this.getProvince();
            zipPostalCode = this.getPostalCode();
        }
        StringBuffer citySegmentBuffer = new StringBuffer();
        this.appendAddressPieceOnNewLine(citySegmentBuffer, this.getCity());
        if (citySegmentBuffer.length() > 0 && (StringUtils.isNotEmpty((String)stateProvince) || StringUtils.isNotEmpty((String)zipPostalCode))) {
            citySegmentBuffer.append(", ");
        }
        if (StringUtils.isNotEmpty((String)stateProvince)) {
            citySegmentBuffer.append(stateProvince);
            if (StringUtils.isNotEmpty((String)zipPostalCode)) {
                citySegmentBuffer.append(" ");
            }
        }
        if (StringUtils.isNotEmpty((String)zipPostalCode)) {
            citySegmentBuffer.append(zipPostalCode);
        }
        this.appendAddressPieceOnNewLine(resultBuffer, citySegmentBuffer.toString());
        if (this.getCountryObject() != null) {
            this.appendAddressPieceOnNewLine(resultBuffer, this.getCountryObject().getShortName());
        }
        return resultBuffer.toString();
    }

    public void appendAddressPieceOnNewLine(StringBuffer buffer, String piece) {
        if (StringUtils.isEmpty((String)piece)) {
            return;
        }
        if (buffer != null && buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append(piece);
    }

    public String getInternalLine1() {
        return this.internalLine1;
    }

    private void setInternalLine1(String internalLine1) {
        this.internalLine1 = internalLine1;
    }

    public String getInternalLine2() {
        return this.internalLine2;
    }

    private void setInternalLine2(String internalLine2) {
        this.internalLine2 = internalLine2;
    }

    public String getInternalLine3() {
        return this.internalLine3;
    }

    private void setInternalLine3(String internalLine3) {
        this.internalLine3 = internalLine3;
    }

    public String getInternalCity() {
        return this.internalCity;
    }

    private void setInternalCity(String internalCity) {
        this.internalCity = internalCity;
    }

    public String getInternalCounty() {
        return this.internalCounty;
    }

    private void setInternalCounty(String internalCounty) {
        this.internalCounty = internalCounty;
    }

    public String getInternalState() {
        return this.internalState;
    }

    private void setInternalState(String internalState) {
        this.internalState = internalState;
    }

    public String getInternalZipCode() {
        return this.internalZipCode;
    }

    private void setInternalZipCode(String internalZipCode) {
        this.internalZipCode = internalZipCode;
    }

    public String getInternalZipPlus4() {
        return this.internalZipPlus4;
    }

    private void setInternalZipPlus4(String internalZipPlus4) {
        this.internalZipPlus4 = internalZipPlus4;
    }

    public String getInternalProvince() {
        return this.internalProvince;
    }

    private void setInternalProvince(String internalProvince) {
        this.internalProvince = internalProvince;
    }

    public String getInternalCountry() {
        return this.internalCountry;
    }

    private void setInternalCountry(String internalCountry) {
        this.internalCountry = internalCountry;
    }

    public String getInternalPostalCode() {
        return this.internalPostalCode;
    }

    private void setInternalPostalCode(String internalPostalCode) {
        this.internalPostalCode = internalPostalCode;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("addressType", (Object)this.type);
        builder.append("line1", (Object)this.internalLine1);
        builder.append("line2", (Object)this.internalLine2);
        builder.append("line3", (Object)this.internalLine3);
        builder.append("city", (Object)this.internalCity);
        builder.append("state", (Object)this.internalState);
        builder.append("province", (Object)this.internalProvince);
        builder.append("postalCode", (Object)this.internalPostalCode);
        builder.append("zipCode", (Object)this.internalZipCode);
        builder.append("zipPlus4", (Object)this.internalZipPlus4);
        builder.append("county", (Object)this.internalCounty);
        builder.append("country", (Object)this.internalCountry);
    }

    static {
        COMPARE_LIST.add("internalCountry");
        COMPARE_LIST.add("internalState");
        COMPARE_LIST.add("internalCity");
        COMPARE_LIST.add("internalProvince");
        COMPARE_LIST.add("internalLine1");
        COMPARE_LIST.add("internalLine2");
        COMPARE_LIST.add("internalLine3");
        COMPARE_LIST.add("internalCounty");
        COMPARE_LIST.add("internalZipCode");
        COMPARE_LIST.add("internalZipPlus4");
        COMPARE_LIST.add("internalPostalCode");
    }
}

