/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.messaging;

import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.fw.model.AbstractEntity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SiteIdentityGroup
extends AbstractEntity {
    private static final long serialVersionUID = 8859472104239250472L;
    private PersonEntityKey personKey;
    private Set internalSiteIdentities;
    private boolean consistencyCheckCaseCreated;

    protected void buildToString(ToStringBuilder builder) {
        Integer size = this.internalSiteIdentities != null ? new Integer(this.internalSiteIdentities.size()) : new Integer(0);
        builder.append("personKey", (Object)this.personKey);
        builder.append("numSites", (Object)size);
        builder.append("consistencyCheckCaseCreated", this.consistencyCheckCaseCreated);
    }

    public void addSiteIdentity(SiteIdentity site) {
        Validate.notNull((Object)((Object)site), (String)"Null site specified.");
        this.getInternalSiteIdentities().add(site);
        site.setGroup(this);
    }

    private Set getInternalSiteIdentities() {
        if (this.internalSiteIdentities == null) {
            this.internalSiteIdentities = new HashSet();
        }
        return this.internalSiteIdentities;
    }

    public Set getSiteIdentities() {
        return Collections.unmodifiableSet(this.getInternalSiteIdentities());
    }

    public boolean isConsistencyCheckCaseCreated() {
        return this.consistencyCheckCaseCreated;
    }

    public void setConsistencyCheckCaseCreated(boolean consistencyCheckCaseCreated) {
        this.consistencyCheckCaseCreated = consistencyCheckCaseCreated;
    }

    public PersonEntityKey getPersonKey() {
        return this.personKey;
    }

    public void setPersonKey(PersonEntityKey personKey) {
        this.personKey = personKey;
    }
}

