/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ServicePeriod
extends AbstractNamedActiveLookup {
    private static final long serialVersionUID = -330943289461503827L;
    public static final Code CODE_KOREAN = new Code("0");
    public static final Code CODE_WORLD_WAR_I = new Code("1");
    public static final Code CODE_WORLD_WAR_II = new Code("2");
    public static final Code CODE_SPANISH_AMERICAN = new Code("3");
    public static final Code CODE_PRE_KOREAN = new Code("4");
    public static final Code CODE_POST_KOREAN = new Code("5");
    public static final Code CODE_VIETNAM_ERA = new Code("7");
    public static final Code CODE_POST_VIETNAM = new Code("8");
    public static final Code CODE_OTHER_OR_NONE = new Code("9");
    public static final Code CODE_ARMY = new Code("A");
    public static final Code CODE_NAVY = new Code("B");
    public static final Code CODE_AIR_FORCE = new Code("C");
    public static final Code CODE_COAST_GUARD = new Code("D");
    public static final Code CODE_OTHER_USPHS_BENEFICIARIES = new Code("H");
    public static final Code CODE_OFFICE_OF_WORKERS_COMP = new Code("J");
    public static final Code CODE_OTHER_REIMBURS_NON_VET = new Code("P");
    public static final Code CODE_RETIRED_UNIFORMED_FORCES_CODE = new Code("E");
    public static final Code CODE_MEDICAL_REMEDIAL_ENLIST = new Code("F");
    public static final Code CODE_MERCHANT_SEAMEN_USPHS = new Code("G");
    public static final Code CODE_BENEFICIARIES_FOREIGN_GOV = new Code("M");
    public static final Code CODE_HUMANITARIAN_NON_VET = new Code("N");
    public static final Code CODE_DONORS_NON_VET = new Code("R");
    public static final Code CODE_OTHER_NON_VET = new Code("T");
    public static final Code CODE_CZECHOSLOVAKIA_POLAND_SVC = new Code("W");
    public static final Code CODE_CAV_NPS = new Code("Y");
    public static final Code CODE_CHAMPVA_SPOUSE_CHILD = new Code("U");
    public static final Code CODE_SPECIAL_STUDIES_NON_VET = new Code("S");
    public static final Code CODE_JOB_CORPS_PEACE_CORPS = new Code("K");
    public static final Code CODE_MERCHANT_MARINE = new Code("Z");
    public static final Code CODE_OBSERVATION_EXAMINATION = new Code("I");
    public static final Code CODE_RAILROAD_RETIREMENT = new Code("L");
    public static final Code CODE_CHAMPUS_RESTORE = new Code("O");
    public static final Code CODE_TRICARE_CHAMPUS = new Code("V");
    public static final Code CODE_OTHER_FEDERAL_DEPENDENT = new Code("Q");
    public static final Code CODE_OPERATION_DESERT_SHIELD = new Code("6");
    public static final Code CODE_PERSIAN_GULF_WAR = new Code("X");
    private static String[] alliedVeteranCodes = new String[]{CODE_CAV_NPS.getCode(), CODE_CZECHOSLOVAKIA_POLAND_SVC.getCode(), CODE_OTHER_NON_VET.getCode(), CODE_OTHER_OR_NONE.getCode(), CODE_RAILROAD_RETIREMENT.getCode()};
    private static String[] otherFederalAgencyCodes = new String[]{CODE_AIR_FORCE.getCode(), CODE_ARMY.getCode(), CODE_BENEFICIARIES_FOREIGN_GOV.getCode(), CODE_COAST_GUARD.getCode(), CODE_DONORS_NON_VET.getCode(), CODE_HUMANITARIAN_NON_VET.getCode(), CODE_JOB_CORPS_PEACE_CORPS.getCode(), CODE_MEDICAL_REMEDIAL_ENLIST.getCode(), CODE_MERCHANT_SEAMEN_USPHS.getCode(), CODE_NAVY.getCode(), CODE_OPERATION_DESERT_SHIELD.getCode(), CODE_OTHER_FEDERAL_DEPENDENT.getCode(), CODE_OTHER_NON_VET.getCode(), CODE_OTHER_OR_NONE.getCode(), CODE_OTHER_USPHS_BENEFICIARIES.getCode(), CODE_RAILROAD_RETIREMENT.getCode(), CODE_RETIRED_UNIFORMED_FORCES_CODE.getCode(), CODE_WORLD_WAR_II.getCode()};
    private static String[] collateralOfVetCodes = new String[]{CODE_CHAMPVA_SPOUSE_CHILD.getCode(), CODE_OTHER_NON_VET.getCode(), CODE_OTHER_OR_NONE.getCode()};
    private static String[] champvaCodes = new String[]{CODE_CHAMPVA_SPOUSE_CHILD.getCode(), CODE_KOREAN.getCode(), CODE_MERCHANT_MARINE.getCode(), CODE_OTHER_OR_NONE.getCode(), CODE_PERSIAN_GULF_WAR.getCode(), CODE_POST_KOREAN.getCode(), CODE_POST_VIETNAM.getCode(), CODE_PRE_KOREAN.getCode(), CODE_SPANISH_AMERICAN.getCode(), CODE_VIETNAM_ERA.getCode(), CODE_WORLD_WAR_I.getCode(), CODE_WORLD_WAR_II.getCode()};
    private static String[] employeeCodes = new String[]{CODE_OFFICE_OF_WORKERS_COMP.getCode(), CODE_OTHER_NON_VET.getCode(), CODE_OTHER_OR_NONE.getCode()};
    private static String[] sharingAgreementCodes = new String[]{CODE_AIR_FORCE.getCode(), CODE_ARMY.getCode(), CODE_BENEFICIARIES_FOREIGN_GOV.getCode(), CODE_CAV_NPS.getCode(), CODE_COAST_GUARD.getCode(), CODE_CZECHOSLOVAKIA_POLAND_SVC.getCode(), CODE_JOB_CORPS_PEACE_CORPS.getCode(), CODE_NAVY.getCode(), CODE_OFFICE_OF_WORKERS_COMP.getCode(), CODE_OTHER_NON_VET.getCode(), CODE_OTHER_OR_NONE.getCode(), CODE_OTHER_REIMBURS_NON_VET.getCode(), CODE_OTHER_USPHS_BENEFICIARIES.getCode(), CODE_SPECIAL_STUDIES_NON_VET.getCode(), CODE_WORLD_WAR_II.getCode()};
    private static String[] tricareCodes = new String[]{CODE_AIR_FORCE.getCode(), CODE_ARMY.getCode(), CODE_BENEFICIARIES_FOREIGN_GOV.getCode(), CODE_CAV_NPS.getCode(), CODE_TRICARE_CHAMPUS.getCode(), CODE_COAST_GUARD.getCode(), CODE_NAVY.getCode(), CODE_OTHER_NON_VET.getCode(), CODE_WORLD_WAR_II.getCode()};

    public boolean isSubSetForNonVeteranCode(String code) {
        if (code == null) {
            return false;
        }
        if (code.equals(EligibilityType.ALLIED_VETERAN.getCode())) {
            List<String> list = Arrays.asList(alliedVeteranCodes);
            return list.contains(this.getCode());
        }
        if (code.equals(EligibilityType.OTHER_FEDERAL_AGENCY.getCode())) {
            List<String> list = Arrays.asList(otherFederalAgencyCodes);
            return list.contains(this.getCode());
        }
        if (code.equals(EligibilityType.COLLATERAL_OF_VETERAN.getCode())) {
            List<String> list = Arrays.asList(collateralOfVetCodes);
            return list.contains(this.getCode());
        }
        if (code.equals(EligibilityType.CHAMPVA.getCode())) {
            List<String> list = Arrays.asList(champvaCodes);
            return list.contains(this.getCode());
        }
        if (code.equals(EligibilityType.EMPLOYEE.getCode())) {
            List<String> list = Arrays.asList(employeeCodes);
            return list.contains(this.getCode());
        }
        if (code.equals(EligibilityType.SHARING_AGREEMENT.getCode())) {
            List<String> list = Arrays.asList(sharingAgreementCodes);
            return list.contains(this.getCode());
        }
        if (code.equals(EligibilityType.TRICARE_CHAMPUS.getCode())) {
            List<String> list = Arrays.asList(tricareCodes);
            return list.contains(this.getCode());
        }
        return false;
    }

    public String getNameAndDateRange() {
        String end;
        StringBuffer nameDate = new StringBuffer(this.getName());
        String start = this.getStartDate() != null ? DateUtils.format((Date)this.getStartDate(), (String)"MM/dd/yyyy") : null;
        String string = end = this.getStartDate() != null ? DateUtils.format((Date)this.getEndDate(), (String)"MM/dd/yyyy") : null;
        if (start != null) {
            if (end == null) {
                end = "...";
            }
            nameDate.append(" - (" + start + " to " + end + ")");
        }
        return nameDate.toString();
    }

    public static class Code
    extends AbstractCode {
        private static final long serialVersionUID = 2616656799203290724L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code)Code.getCode(Code.class, (String)code);
        }
    }
}

