/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Country
extends AbstractLookup {
    private static final long serialVersionUID = 7639817666922345899L;
    public static final Code CODE_USA = new Code("USA");
    public static final Code CODE_CAN = new Code("CAN");
    public static final Code CODE_MEX = new Code("MEX");
    public static final Code CODE_PHILIPPINES = new Code("PHL");
    private String shortName;
    private String numericCode;
    private String alpha3Code;
    private String fipsCode;
    private String postalName;

    public static boolean isUSAddress(String countryCode) {
        return StringUtils.isBlank((String)countryCode) || CODE_USA.getName().equals(countryCode);
    }

    public boolean isUSAddress() {
        return Country.isUSAddress(this.getAlpha3Code());
    }

    public String getAlpha3Code() {
        return this.alpha3Code;
    }

    private void setAlpha3Code(String alpha3Code) {
        this.alpha3Code = alpha3Code;
    }

    public String getFipsCode() {
        return this.fipsCode;
    }

    private void setFipsCode(String fipsCode) {
        this.fipsCode = fipsCode;
    }

    public String getNumericCode() {
        return this.numericCode;
    }

    private void setNumericCode(String numericCode) {
        this.numericCode = numericCode;
    }

    public String getPostalName() {
        return this.postalName;
    }

    public void setPostalName(String postalName) {
        this.postalName = postalName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        if (shortName != null) {
            shortName = shortName.toUpperCase();
        }
        this.shortName = shortName;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder.append("alpha3Code", (Object)this.alpha3Code).append("fipsCode", (Object)this.fipsCode).append("numericCode", (Object)this.numericCode).append("postalName", (Object)this.postalName).append("shortName", (Object)this.shortName));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha3Code = null;
        this.fipsCode = null;
        this.numericCode = null;
        this.postalName = null;
        this.shortName = null;
    }

    public String getDescription() {
        return this.getShortName();
    }

    public static class Code
    extends AbstractCode {
        private static final long serialVersionUID = -3147087186714279051L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code)Code.getCode(Code.class, (String)code);
        }
    }
}

