/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MonetaryBenefitAward
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 5924196356299399292L;
    private Person person;
    private BigDecimal checkAmount = null;
    private Set internalMonetaryBenefits = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public BigDecimal getCheckAmount() {
        return this.checkAmount;
    }

    public void setCheckAmount(BigDecimal checkAmount) {
        this.checkAmount = checkAmount;
    }

    public Set getMonetaryBenefits() {
        return Collections.unmodifiableSet(this.getInternalMonetaryBenefits());
    }

    public boolean containsMonetaryBenefits() {
        Set mbs = this.getInternalMonetaryBenefits();
        return mbs != null && mbs.size() > 0;
    }

    private Set getInternalMonetaryBenefits() {
        if (this.internalMonetaryBenefits == null) {
            this.internalMonetaryBenefits = new HashSet();
        }
        return this.internalMonetaryBenefits;
    }

    private void setInternalMonetaryBenefits(Set internalMonetaryBenefits) {
        this.internalMonetaryBenefits = internalMonetaryBenefits;
    }

    public void addMonetaryBenefit(MonetaryBenefit monetaryBenefit) {
        Validate.notNull((Object)((Object)monetaryBenefit), (String)"Monetary Benefit cannot be null");
        if (this.getMonetaryBenefitByType(monetaryBenefit.getType()) == null) {
            monetaryBenefit.setMonetaryBenefitAward(this);
            this.getInternalMonetaryBenefits().add(monetaryBenefit);
        }
    }

    public void removeAllMonetaryBenefits() {
        this.getInternalMonetaryBenefits().clear();
    }

    public void removeMonetaryBenefit(MonetaryBenefit monetaryBenefit) {
        Validate.notNull((Object)((Object)monetaryBenefit), (String)"Monetary Benefit cannot be null");
        this.getInternalMonetaryBenefits().remove((Object)monetaryBenefit);
    }

    public MonetaryBenefit getMonetaryBenefitByType(MonetaryBenefitType type) {
        Validate.notNull((Object)((Object)type), (String)"MonetaryBenefitType connot be null");
        return this.getMonetaryBenefitByType(type.getCode());
    }

    public MonetaryBenefit getMonetaryBenefitByType(MonetaryBenefitType.Code type) {
        Validate.notNull((Object)((Object)type), (String)"MonetaryBenefitType connot be null");
        return this.getMonetaryBenefitByType(type.getCode());
    }

    public void removeMonetaryBenefitByType(MonetaryBenefitType type) {
        Validate.notNull((Object)((Object)type), (String)"MonetaryBenefitType connot be null");
        MonetaryBenefit monetaryBenefit = this.getMonetaryBenefitByType(type);
        if (monetaryBenefit != null) {
            this.removeMonetaryBenefit(monetaryBenefit);
        }
    }

    public void removeMonetaryBenefitByType(MonetaryBenefitType.Code type) {
        Validate.notNull((Object)((Object)type), (String)"MonetaryBenefitType connot be null");
        MonetaryBenefit monetaryBenefit = this.getMonetaryBenefitByType(type.getCode());
        if (monetaryBenefit != null) {
            this.removeMonetaryBenefit(monetaryBenefit);
        }
    }

    public MonetaryBenefit getAidAndAttendance() {
        return this.getMonetaryBenefitByType(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE);
    }

    public MonetaryBenefit getHouseBound() {
        return this.getMonetaryBenefitByType(MonetaryBenefitType.CODE_HOUSEBOUND);
    }

    public MonetaryBenefit getVAPension() {
        return this.getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION);
    }

    public MonetaryBenefit getDisabilityCompensation() {
        return this.getMonetaryBenefitByType(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION);
    }

    public void setAidAndAttendance(MonetaryBenefit monetaryBenefit) {
        if (monetaryBenefit == null) {
            this.removeMonetaryBenefitByType(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE);
        } else {
            this.addMonetaryBenefit(monetaryBenefit);
        }
    }

    public void setHouseBound(MonetaryBenefit monetaryBenefit) {
        if (monetaryBenefit == null) {
            this.removeMonetaryBenefitByType(MonetaryBenefitType.CODE_HOUSEBOUND);
        } else {
            this.addMonetaryBenefit(monetaryBenefit);
        }
    }

    public void setVAPension(MonetaryBenefit monetaryBenefit) {
        if (monetaryBenefit == null) {
            this.removeMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION);
        } else {
            this.addMonetaryBenefit(monetaryBenefit);
        }
    }

    public void setDisabilityCompensation(MonetaryBenefit monetaryBenefit) {
        if (monetaryBenefit == null) {
            this.removeMonetaryBenefitByType(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION);
        } else {
            this.addMonetaryBenefit(monetaryBenefit);
        }
    }

    private MonetaryBenefit getMonetaryBenefitByType(String typeCode) {
        if (StringUtils.isNotEmpty((String)typeCode)) {
            for (MonetaryBenefit mBenefit : this.getInternalMonetaryBenefits()) {
                String type = mBenefit != null && mBenefit.getType() != null ? mBenefit.getType().getCode() : null;
                if (!StringUtils.equals(type, (String)typeCode)) continue;
                return mBenefit;
            }
        }
        return null;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder.append("checkAmount", (Object)this.checkAmount));
    }
}

