/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EligibilityVerification
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 2815027233801965458L;
    private Person person = null;
    private String verificationMethod = null;
    private EligibilityVerificationSource verificationSource = null;
    private VAFacility verificationFacility = null;
    private ImpreciseDate eligibilityStatusDate = null;
    private EligibilityStatus eligibilityStatus = null;
    private AACIndicator aacIndicator = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getVerificationMethod() {
        return this.verificationMethod;
    }

    public void setVerificationMethod(String verificationMethod) {
        this.verificationMethod = verificationMethod;
    }

    public EligibilityVerificationSource getVerificationSource() {
        return this.verificationSource;
    }

    public void setVerificationSource(EligibilityVerificationSource verificationSource) {
        this.verificationSource = verificationSource;
    }

    public VAFacility getVerificationFacility() {
        return this.verificationFacility;
    }

    public void setVerificationFacility(VAFacility verificationFacility) {
        this.verificationFacility = verificationFacility;
    }

    public String getVerificationSourceFacility() {
        String evsCode;
        String name = null;
        EligibilityVerificationSource evs = this.getVerificationSource();
        String string = evsCode = evs != null ? evs.getCode() : null;
        if (evsCode != null) {
            String string2 = name = EligibilityVerificationSource.CODE_VAMC.getName().equals(evsCode) ? "VAMC" : evs.getDescription();
            if ("VAMC".equals(name) && this.getVerificationFacility() != null && StringUtils.isNotEmpty((String)this.getVerificationFacility().getStationNumber())) {
                name = name + " - " + this.getVerificationFacility().getStationNumber();
            }
        }
        return name;
    }

    public ImpreciseDate getEligibilityStatusDate() {
        return this.eligibilityStatusDate;
    }

    public void setEligibilityStatusDate(ImpreciseDate eligibilityStatusDate) {
        this.eligibilityStatusDate = eligibilityStatusDate;
    }

    public EligibilityStatus getEligibilityStatus() {
        return this.eligibilityStatus;
    }

    public void setEligibilityStatus(EligibilityStatus eligibilityStatus) {
        this.eligibilityStatus = eligibilityStatus;
    }

    public AACIndicator getAacIndicator() {
        return this.aacIndicator;
    }

    public void setAacIndicator(AACIndicator aacIndicator) {
        this.aacIndicator = aacIndicator;
    }

    public void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("verificationMethod", (Object)this.verificationMethod);
        builder.append("verificationSource", (Object)this.verificationSource);
        builder.append("verificationFacility", (Object)this.verificationFacility);
        builder.append("eligibilityStatus", (Object)this.eligibilityStatus);
        builder.append("aacIndicator", (Object)this.aacIndicator);
        builder.append("eligibilityStatusDate", (Object)this.eligibilityStatusDate);
    }
}

