/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EligibilityFactor;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Arrays;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Eligibility
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = -753278036054366763L;
    private static final String PRIMARY_IND = "P";
    private static final String SECONDARY_IND = "S";
    private static final String OTHER_IND = "O";
    private EnrollmentDetermination enrollmentDetermination = null;
    private EligibilityType type = null;
    private EligibilityFactor factor = null;
    private String indicator = null;

    public EnrollmentDetermination getEnrollmentDetermination() {
        return this.enrollmentDetermination;
    }

    public void setEnrollmentDetermination(EnrollmentDetermination enrollmentDetermination) {
        this.validateOwner(this.enrollmentDetermination, enrollmentDetermination);
        this.enrollmentDetermination = enrollmentDetermination;
    }

    public EligibilityType getType() {
        return this.type;
    }

    public void setType(EligibilityType type) {
        this.type = type;
    }

    public EligibilityFactor getFactor() {
        return this.factor;
    }

    public void setFactor(EligibilityFactor factor) {
        this.factor = factor;
    }

    private void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public String getIndicator() {
        return this.indicator;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.getType());
        builder.append("factor", (Object)this.getFactor());
        builder.append("indicator", (Object)this.getIndicator());
    }

    public void setPrimary() {
        this.setIndicator(PRIMARY_IND);
    }

    public void setSecondary() {
        this.setIndicator(SECONDARY_IND);
    }

    public void setOther() {
        this.setIndicator(OTHER_IND);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Eligibility)) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (!this.getIndicator().equals(SECONDARY_IND) || !((Eligibility)o).getIndicator().equals(SECONDARY_IND)) {
            return 0;
        }
        EligibilityType thisType = this.getType();
        EligibilityType oType = ((Eligibility)o).getType();
        return this.getOrder(thisType) - this.getOrder(oType);
    }

    private int getOrder(EligibilityType type) {
        Object[] objs = new Object[]{EligibilityType.PRISONER_OF_WAR.getName(), EligibilityType.PURPLE_HEART_RECIPIENT.getName(), EligibilityType.AID_AND_ATTENDANCE.getName(), EligibilityType.HOUSEBOUND.getName(), EligibilityType.NSC_VA_PENSION.getName(), EligibilityType.WORLD_WAR_I.getName(), EligibilityType.HUMANTARIAN_EMERGENCY.getName(), EligibilityType.TRICARE_CHAMPUS.getName(), EligibilityType.SHARING_AGREEMENT.getName(), EligibilityType.ALLIED_VETERAN.getName(), EligibilityType.CHAMPVA.getName(), EligibilityType.EMPLOYEE.getName(), EligibilityType.COLLATERAL_OF_VETERAN.getName(), EligibilityType.OTHER_FEDERAL_AGENCY.getName()};
        int order = Arrays.asList(objs).indexOf(type.getCode());
        return order;
    }
}

