/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.lookup.CDDeterminationMethod;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CatastrophicDisability
extends ClinicalDetermination {
    private static final long serialVersionUID = -1123826294937114608L;
    private Date reviewDate = null;
    private Date decisionDate = null;
    private Date veteranRequestedCDReviewDate = null;
    private Date facilityInitiatedCDReviewDate = null;
    private Date veteranWasNotifiedCDDate = null;
    private String determinedBy = null;
    private CDDeterminationMethod determinationMethod = null;
    private Boolean catastrophicallyDisabled = null;
    private Set internalDiagnoses = null;
    private Set internalProcedures = null;
    private Set internalConditions = null;
    private Set<CDDescriptor> internalCDDescriptors = null;

    public Date getReviewDate() {
        return this.reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }

    public Date getDecisionDate() {
        return this.decisionDate;
    }

    public void setDecisionDate(Date decisionDate) {
        this.decisionDate = decisionDate;
    }

    public Date getVeteranRequestedCDReviewDate() {
        return this.veteranRequestedCDReviewDate;
    }

    public void setVeteranRequestedCDReviewDate(Date veteranRequestedCDReviewDate) {
        this.veteranRequestedCDReviewDate = veteranRequestedCDReviewDate;
    }

    public Date getFacilityInitiatedCDReviewDate() {
        return this.facilityInitiatedCDReviewDate;
    }

    public void setFacilityInitiatedCDReviewDate(Date facilityInitiatedCDReviewDate) {
        this.facilityInitiatedCDReviewDate = facilityInitiatedCDReviewDate;
    }

    public Date getVeteranWasNotifiedCDDate() {
        return this.veteranWasNotifiedCDDate;
    }

    public void setVeteranWasNotifiedCDDate(Date veteranWasNotifiedCDDate) {
        this.veteranWasNotifiedCDDate = veteranWasNotifiedCDDate;
    }

    public String getDeterminedBy() {
        return this.determinedBy;
    }

    public void setDeterminedBy(String determinedBy) {
        this.determinedBy = determinedBy;
    }

    public CDDeterminationMethod getDeterminationMethod() {
        return this.determinationMethod;
    }

    public void setDeterminationMethod(CDDeterminationMethod determinationMethod) {
        this.determinationMethod = determinationMethod;
    }

    public Boolean isCatastrophicallyDisabled() {
        return this.catastrophicallyDisabled;
    }

    public Boolean getCatastrophicallyDisabled() {
        return this.catastrophicallyDisabled;
    }

    public void setCatastrophicallyDisabled(Boolean catastrophicallyDisabled) {
        this.catastrophicallyDisabled = catastrophicallyDisabled;
    }

    public Set getConditions() {
        return Collections.unmodifiableSet(this.getInternalConditions());
    }

    public CDCondition getConditionByEntityKey(EntityKey identifier) {
        return (CDCondition)CatastrophicDisability.getEntityByEntityKey((Collection)this.getConditions(), (EntityKey)identifier);
    }

    public CDCondition removeConditionByEntityKey(EntityKey identifier) {
        return (CDCondition)CatastrophicDisability.removeEntityByEntityKey((Collection)this.getInternalConditions(), (EntityKey)identifier);
    }

    private Set getInternalConditions() {
        if (this.internalConditions == null) {
            this.internalConditions = new HashSet();
        }
        return this.internalConditions;
    }

    private void setInternalConditions(Set conditions) {
        this.internalConditions = conditions;
    }

    public void addCondition(CDCondition condition) {
        Validate.notNull((Object)((Object)condition), (String)"Null condition specified.");
        condition.setCatastrophicDisability(this);
        this.getInternalConditions().add(condition);
    }

    public void removeCondition(CDCondition condition) {
        Validate.notNull((Object)((Object)condition), (String)"Null condition specified.");
        this.getInternalConditions().remove((Object)condition);
        condition.setCatastrophicDisability(null);
    }

    public void removeAllConditions() {
        this.getInternalConditions().clear();
    }

    public Set getProcedures() {
        return Collections.unmodifiableSet(this.getInternalProcedures());
    }

    public CDProcedure getProcedureByEntityKey(EntityKey identifier) {
        return (CDProcedure)CatastrophicDisability.getEntityByEntityKey((Collection)this.getProcedures(), (EntityKey)identifier);
    }

    public CDProcedure removeProcedureByEntityKey(EntityKey identifier) {
        return (CDProcedure)CatastrophicDisability.removeEntityByEntityKey((Collection)this.getInternalProcedures(), (EntityKey)identifier);
    }

    private Set getInternalProcedures() {
        if (this.internalProcedures == null) {
            this.internalProcedures = new HashSet();
        }
        return this.internalProcedures;
    }

    private void setInternalProcedures(Set procedures) {
        this.internalProcedures = procedures;
    }

    public void addProcedure(CDProcedure procedure) {
        Validate.notNull((Object)((Object)procedure), (String)"Null procedure specified.");
        procedure.setCatastrophicDisability(this);
        this.getInternalProcedures().add(procedure);
    }

    public void removeProcedure(CDProcedure procedure) {
        Validate.notNull((Object)((Object)procedure), (String)"Null procedure specified.");
        this.getInternalProcedures().remove((Object)procedure);
        procedure.setCatastrophicDisability(null);
    }

    public void removeAllProcedures() {
        this.getInternalProcedures().clear();
    }

    public Set getDiagnoses() {
        return Collections.unmodifiableSet(this.getInternalDiagnoses());
    }

    public CDDiagnosis getDiagnosisByEntityKey(EntityKey identifier) {
        return (CDDiagnosis)CatastrophicDisability.getEntityByEntityKey((Collection)this.getDiagnoses(), (EntityKey)identifier);
    }

    public CDDiagnosis removeDiagnosisByEntityKey(EntityKey identifier) {
        return (CDDiagnosis)CatastrophicDisability.removeEntityByEntityKey((Collection)this.getInternalDiagnoses(), (EntityKey)identifier);
    }

    private Set getInternalDiagnoses() {
        if (this.internalDiagnoses == null) {
            this.internalDiagnoses = new HashSet();
        }
        return this.internalDiagnoses;
    }

    private void setInternalDiagnoses(Set diagnoses) {
        this.internalDiagnoses = diagnoses;
    }

    public void addDiagnosis(CDDiagnosis diagnosis) {
        Validate.notNull((Object)((Object)diagnosis), (String)"Null diagnosis specified.");
        diagnosis.setCatastrophicDisability(this);
        this.getInternalDiagnoses().add(diagnosis);
    }

    public void removeDiagnosis(CDDiagnosis diagnosis) {
        Validate.notNull((Object)((Object)diagnosis), (String)"Null diagnosis specified.");
        this.getInternalDiagnoses().remove((Object)diagnosis);
        diagnosis.setCatastrophicDisability(null);
    }

    public void removeAllDiagnoses() {
        this.getInternalDiagnoses().clear();
    }

    public Set<CDDescriptor> getCDDescriptors() {
        return Collections.unmodifiableSet(this.getInternalCDDescriptors());
    }

    public CDDescriptor getCDDescriptorByEntityKey(EntityKey identifier) {
        return (CDDescriptor)CatastrophicDisability.getEntityByEntityKey(this.getCDDescriptors(), (EntityKey)identifier);
    }

    public CDDescriptor removeCDDescriptorByEntityKey(EntityKey identifier) {
        return (CDDescriptor)CatastrophicDisability.removeEntityByEntityKey(this.getInternalCDDescriptors(), (EntityKey)identifier);
    }

    private Set<CDDescriptor> getInternalCDDescriptors() {
        if (this.internalCDDescriptors == null) {
            this.internalCDDescriptors = new HashSet<CDDescriptor>();
        }
        return this.internalCDDescriptors;
    }

    private void setInternalCDDescriptors(Set<CDDescriptor> descriptors) {
        this.internalCDDescriptors = descriptors;
    }

    public void addCDDescriptor(CDDescriptor descriptor) {
        Validate.notNull((Object)((Object)descriptor), (String)"Null descriptor specified.");
        descriptor.setCatastrophicDisability(this);
        this.getInternalCDDescriptors().add(descriptor);
    }

    public void removeCDDescriptor(CDDescriptor descriptor) {
        Validate.notNull((Object)((Object)descriptor), (String)"Null descriptor specified.");
        this.getInternalCDDescriptors().remove((Object)descriptor);
        descriptor.setCatastrophicDisability(null);
    }

    public void removeAllCDDescriptors() {
        this.getInternalCDDescriptors().clear();
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("reviewDate", (Object)this.reviewDate);
        builder.append("decisionDate", (Object)this.decisionDate);
        builder.append("veteranRequestedCDReviewDate", (Object)this.veteranRequestedCDReviewDate);
        builder.append("facilityInitiatedCDReviewDate", (Object)this.facilityInitiatedCDReviewDate);
        builder.append("veteranWasNotifiedCDDate", (Object)this.veteranWasNotifiedCDDate);
        builder.append("determinedBy", (Object)this.determinedBy);
        builder.append("determinationMethod", (Object)this.determinationMethod);
        builder.append("catastrophicallyDisabled", (Object)this.catastrophicallyDisabled);
    }
}

