/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.comms.CmsErrorFileEntry;
import gov.va.med.esr.common.model.comms.CmsMailedFileEntry;
import gov.va.med.esr.common.model.comms.CmsRejectFileEntry;
import gov.va.med.esr.common.model.comms.ErrorFileEntry;
import gov.va.med.esr.common.model.comms.MailedFileEntry;
import gov.va.med.esr.common.model.comms.RejectFileEntry;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class CommsImportStatistics {
    private String errorFileName;
    private Date errorFileReceivedDate;
    private int errorFileRecordCount = 0;
    private Hashtable errorPerTypeNumberTable = new Hashtable();
    private Hashtable errorReasonPerLetterTypeTable = new Hashtable();
    private Date errorFileProcessStartTime = null;
    private Date errorFileProcessEndTime = null;
    private int errorFileProcessedCount;
    private int errorFileFailedCount;
    private String rejectFileName;
    private Date rejectFileReceivedDate;
    private int rejectFileRecordCount = 0;
    private Hashtable rejectPerTypeNumberTable = new Hashtable();
    private Hashtable rejectReasonPerLetterTypeTable = new Hashtable();
    private Date rejectFileProcessStartTime = null;
    private Date rejectFileProcessEndTime = null;
    private int rejectFileProcessedCount;
    private int rejectFileFailedCount;
    private String mailedFileName;
    private Date mailedFileReceivedDate;
    private int mailedFileRecordCount = 0;
    private Hashtable mailedPerTypeNumberTable = new Hashtable();
    private Date mailedFileProcessStartTime = null;
    private Date mailedFileProcessEndTime = null;
    private int mailedFileProcessedCount;
    private int mailedFileFailedCount;
    private int returnedMailFileProcessedCount = 0;
    private Date processStartTime = null;
    private Date processEndTime = null;

    public void updateErrorStatistics(ErrorFileEntry entry, boolean isNewLogEntry) {
        ++this.errorFileRecordCount;
        String formNumber = entry.getFormNumber();
        if (formNumber != null) {
            Integer cnt = (Integer)this.errorPerTypeNumberTable.get(formNumber);
            if (cnt == null) {
                this.errorPerTypeNumberTable.put(formNumber, new Integer(1));
            } else if (isNewLogEntry) {
                this.errorPerTypeNumberTable.put(formNumber, new Integer(cnt + 1));
            }
            String errorCode = entry.getErrorCode();
            if (errorCode != null) {
                Set errorReasons = (Set)this.errorReasonPerLetterTypeTable.get(formNumber);
                if (errorReasons == null) {
                    HashSet<String> newCode = new HashSet<String>();
                    newCode.add(errorCode);
                    this.errorReasonPerLetterTypeTable.put(formNumber, newCode);
                } else {
                    errorReasons.add(entry.getErrorCode());
                }
            }
        }
    }

    public void updateCmsErrorStatistics(CmsErrorFileEntry entry, boolean isNewLogEntry) {
        ++this.errorFileRecordCount;
        String formNumber = entry.getFormNumber();
        if (formNumber != null) {
            Integer cnt = (Integer)this.errorPerTypeNumberTable.get(formNumber);
            if (cnt == null) {
                this.errorPerTypeNumberTable.put(formNumber, new Integer(1));
            } else if (isNewLogEntry) {
                this.errorPerTypeNumberTable.put(formNumber, new Integer(cnt + 1));
            }
            String errorCode = entry.getErrorCode();
            if (errorCode != null) {
                Set errorReasons = (Set)this.errorReasonPerLetterTypeTable.get(formNumber);
                if (errorReasons == null) {
                    HashSet<String> newCode = new HashSet<String>();
                    newCode.add(errorCode);
                    this.errorReasonPerLetterTypeTable.put(formNumber, newCode);
                } else {
                    errorReasons.add(entry.getErrorCode());
                }
            }
        }
    }

    public void updateRejectStatistics(RejectFileEntry entry) {
        ++this.rejectFileRecordCount;
        String formNumber = entry.getFormNumber();
        if (formNumber != null) {
            Integer cnt = (Integer)this.rejectPerTypeNumberTable.get(formNumber);
            if (cnt == null) {
                this.rejectPerTypeNumberTable.put(formNumber, new Integer(1));
            } else {
                this.rejectPerTypeNumberTable.put(formNumber, new Integer(cnt + 1));
            }
            String rejectCode = entry.getCode1Reject();
            if (rejectCode != null) {
                Set rejectReasons = (Set)this.rejectReasonPerLetterTypeTable.get(formNumber);
                if (rejectReasons == null) {
                    HashSet<String> newCode = new HashSet<String>();
                    newCode.add(rejectCode);
                    this.rejectReasonPerLetterTypeTable.put(formNumber, newCode);
                } else {
                    rejectReasons.add(entry.getCode1Reject());
                }
            }
        }
    }

    public void updateCmsRejectStatistics(CmsRejectFileEntry entry) {
        ++this.rejectFileRecordCount;
        String formNumber = entry.getFormNumber();
        if (formNumber != null) {
            Integer cnt = (Integer)this.rejectPerTypeNumberTable.get(formNumber);
            if (cnt == null) {
                this.rejectPerTypeNumberTable.put(formNumber, new Integer(1));
            } else {
                this.rejectPerTypeNumberTable.put(formNumber, new Integer(cnt + 1));
            }
            String rejectCode = entry.getCode1Reject();
            if (rejectCode != null) {
                Set rejectReasons = (Set)this.rejectReasonPerLetterTypeTable.get(formNumber);
                if (rejectReasons == null) {
                    HashSet<String> newCode = new HashSet<String>();
                    newCode.add(rejectCode);
                    this.rejectReasonPerLetterTypeTable.put(formNumber, newCode);
                } else {
                    rejectReasons.add(entry.getCode1Reject());
                }
            }
        }
    }

    public void updateMailedStatistics(MailedFileEntry entry) {
        ++this.mailedFileRecordCount;
        String formNumber = entry.getFormNumber();
        if (formNumber != null) {
            Integer cnt = (Integer)this.mailedPerTypeNumberTable.get(formNumber);
            if (cnt == null) {
                this.mailedPerTypeNumberTable.put(formNumber, new Integer(1));
            } else {
                this.mailedPerTypeNumberTable.put(formNumber, new Integer(cnt + 1));
            }
        }
    }

    public void updateCmsMailedStatistics(CmsMailedFileEntry entry) {
        ++this.mailedFileRecordCount;
        String formNumber = entry.getFormNumber();
        if (formNumber != null) {
            Integer cnt = (Integer)this.mailedPerTypeNumberTable.get(formNumber);
            if (cnt == null) {
                this.mailedPerTypeNumberTable.put(formNumber, new Integer(1));
            } else {
                this.mailedPerTypeNumberTable.put(formNumber, new Integer(cnt + 1));
            }
        }
    }

    public Date getErrorFileReceivedDate() {
        return this.errorFileReceivedDate;
    }

    public void setErrorFileReceivedDate(Date errorFileReceivedDate) {
        this.errorFileReceivedDate = errorFileReceivedDate;
    }

    public String getErrorFileName() {
        return this.errorFileName;
    }

    public void setErrorFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }

    public Date getMailedFileReceivedDate() {
        return this.mailedFileReceivedDate;
    }

    public void setMailedFileReceivedDate(Date mailedFileReceivedDate) {
        this.mailedFileReceivedDate = mailedFileReceivedDate;
    }

    public String getMailedFileName() {
        return this.mailedFileName;
    }

    public void setMailedFileName(String mailedFileName) {
        this.mailedFileName = mailedFileName;
    }

    public Date getRejectFileReceivedDate() {
        return this.rejectFileReceivedDate;
    }

    public void setRejectFileReceivedDate(Date rejectFileReceivedDate) {
        this.rejectFileReceivedDate = rejectFileReceivedDate;
    }

    public String getRejectFileName() {
        return this.rejectFileName;
    }

    public void setRejectFileName(String rejectFileName) {
        this.rejectFileName = rejectFileName;
    }

    public int getErrorFileRecordCount() {
        return this.errorFileRecordCount;
    }

    public Hashtable getErrorPerTypeNumberTable() {
        return this.errorPerTypeNumberTable;
    }

    public Hashtable getErrorReasonPerLetterTypeTable() {
        return this.errorReasonPerLetterTypeTable;
    }

    public int getMailedFileRecordCount() {
        return this.mailedFileRecordCount;
    }

    public Hashtable getMailedPerTypeNumberTable() {
        return this.mailedPerTypeNumberTable;
    }

    public int getRejectFileRecordCount() {
        return this.rejectFileRecordCount;
    }

    public Hashtable getRejectPerTypeNumberTable() {
        return this.rejectPerTypeNumberTable;
    }

    public Hashtable getRejectReasonPerLetterTypeTable() {
        return this.rejectReasonPerLetterTypeTable;
    }

    public Date getProcessEndTime() {
        return this.processEndTime;
    }

    public void setProcessEndTime(Date processEndTime) {
        this.processEndTime = processEndTime;
    }

    public Date getProcessStartTime() {
        return this.processStartTime;
    }

    public void setProcessStartTime(Date processStartTime) {
        this.processStartTime = processStartTime;
    }

    public Date getErrorFileProcessEndTime() {
        return this.errorFileProcessEndTime;
    }

    public void setErrorFileProcessEndTime(Date errorFileProcessEndTime) {
        this.errorFileProcessEndTime = errorFileProcessEndTime;
    }

    public Date getErrorFileProcessStartTime() {
        return this.errorFileProcessStartTime;
    }

    public void setErrorFileProcessStartTime(Date errorFileProcessStartTime) {
        this.errorFileProcessStartTime = errorFileProcessStartTime;
    }

    public Date getMailedFileProcessEndTime() {
        return this.mailedFileProcessEndTime;
    }

    public void setMailedFileProcessEndTime(Date mailedFileProcessEndTime) {
        this.mailedFileProcessEndTime = mailedFileProcessEndTime;
    }

    public Date getMailedFileProcessStartTime() {
        return this.mailedFileProcessStartTime;
    }

    public void setMailedFileProcessStartTime(Date mailedFileProcessStartTime) {
        this.mailedFileProcessStartTime = mailedFileProcessStartTime;
    }

    public Date getRejectFileProcessEndTime() {
        return this.rejectFileProcessEndTime;
    }

    public void setRejectFileProcessEndTime(Date rejectFileProcessEndTime) {
        this.rejectFileProcessEndTime = rejectFileProcessEndTime;
    }

    public Date getRejectFileProcessStartTime() {
        return this.rejectFileProcessStartTime;
    }

    public void setRejectFileProcessStartTime(Date rejectFileProcessStartTime) {
        this.rejectFileProcessStartTime = rejectFileProcessStartTime;
    }

    public int getErrorFileFailedCount() {
        return this.errorFileFailedCount;
    }

    public void incrementErrorFileFailedCount() {
        ++this.errorFileFailedCount;
    }

    public int getErrorFileProcessedCount() {
        return this.errorFileProcessedCount;
    }

    public void incrementErrorFileProcessedCount() {
        ++this.errorFileProcessedCount;
    }

    public int getRejectFileFailedCount() {
        return this.rejectFileFailedCount;
    }

    public void incrementRejectFileFailedCount() {
        ++this.rejectFileFailedCount;
    }

    public int getRejectFileProcessedCount() {
        return this.rejectFileProcessedCount;
    }

    public void incrementRejectFileProcessedCount() {
        ++this.rejectFileProcessedCount;
    }

    public int getMailedFileFailedCount() {
        return this.mailedFileFailedCount;
    }

    public void incrementMailedFileFailedCount() {
        ++this.mailedFileFailedCount;
    }

    public int getMailedFileProcessedCount() {
        return this.mailedFileProcessedCount;
    }

    public void incrementMailedFileProcessedCount() {
        ++this.mailedFileProcessedCount;
    }

    public int getReturnedMailFileProcessedCount() {
        return this.returnedMailFileProcessedCount;
    }

    public void incrementReturnedMailFileProcessedCount() {
        ++this.returnedMailFileProcessedCount;
    }
}

