/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.infra;

import gov.va.med.esr.common.infra.ImpreciseDateStringFormat;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.date.ImpreciseDateSupport;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class ImpreciseDate
implements Cloneable,
Serializable,
Comparable,
ImpreciseDateSupport {
    private static final long serialVersionUID = 7298656148593521292L;
    private Date date;
    private String string;
    private Calendar calendar;
    private boolean dayPrecise;
    private boolean monthPrecise;
    private boolean timePresent;
    private boolean secPresent;
    public static final String STANDARD_IMPRECISE_DATE_FORMAT_WITH_ALL_COMPONENTS = "yyyyMMdd";
    public static final String STANDARD_IMPRECISE_DATE_HHMM_TS_FORMAT_WITH_ALL_COMPONENTS = "yyyyMMddHHmm";
    public static final String STANDARD_IMPRECISE_DATE_TS_FORMAT_WITH_ALL_COMPONENTS = "yyyyMMddHHmmss";
    public static final String CONVENIENCE_PRECISE_DATE_PATTERN = "MM/dd/yyyy";
    public static final String CONVENIENCE_PRECISE_DATE_HHMM_TIMESTAMP_PATTERN = "MM/dd/yyyy HH:mm";
    public static final String CONVENIENCE_PRECISE_DATE_TIMESTAMP_PATTERN = "MM/dd/yyyy HH:mm:ss";

    private ImpreciseDate() {
    }

    public ImpreciseDate(String date) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)date)) {
            throw new IllegalArgumentException("Can not create ImpreciseDate from a null or empty string.");
        }
        try {
            this.initialize(new ImpreciseDateStringFormat(date).getCalendar());
        }
        catch (Exception e) {
            try {
                this.initialize(new SimpleDateFormat(STANDARD_IMPRECISE_DATE_TS_FORMAT_WITH_ALL_COMPONENTS).parse(date));
                this.timePresent = true;
                this.secPresent = true;
            }
            catch (ParseException e1) {
                try {
                    this.initialize(new SimpleDateFormat(STANDARD_IMPRECISE_DATE_HHMM_TS_FORMAT_WITH_ALL_COMPONENTS).parse(date));
                    this.timePresent = true;
                    this.secPresent = false;
                }
                catch (ParseException tsE1) {
                    try {
                        this.initialize(new SimpleDateFormat(STANDARD_IMPRECISE_DATE_FORMAT_WITH_ALL_COMPONENTS).parse(date));
                        this.timePresent = false;
                    }
                    catch (ParseException e2) {
                        try {
                            this.initialize(new SimpleDateFormat(CONVENIENCE_PRECISE_DATE_TIMESTAMP_PATTERN).parse(date));
                            this.timePresent = true;
                            this.secPresent = true;
                        }
                        catch (ParseException e3) {
                            try {
                                this.initialize(new SimpleDateFormat(CONVENIENCE_PRECISE_DATE_HHMM_TIMESTAMP_PATTERN).parse(date));
                                this.timePresent = true;
                                this.secPresent = false;
                            }
                            catch (ParseException tsE3) {
                                try {
                                    this.initialize(new SimpleDateFormat(CONVENIENCE_PRECISE_DATE_PATTERN).parse(date));
                                    this.timePresent = false;
                                }
                                catch (ParseException e4) {
                                    throw new IllegalArgumentException("The passed in date '" + date + "' has an invalid format.  Supported formats are '" + STANDARD_IMPRECISE_DATE_TS_FORMAT_WITH_ALL_COMPONENTS + "' and '" + CONVENIENCE_PRECISE_DATE_TIMESTAMP_PATTERN + "'.");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public ImpreciseDate(Date date) {
        this.initialize(date);
    }

    public ImpreciseDate(Calendar calendar) {
        this.initialize(calendar);
    }

    public ImpreciseDate(ImpreciseDate impreciseDate) {
        Validate.notNull((Object)impreciseDate, (String)"The passed in impreciseDate cannot be null.");
        this.date = impreciseDate.date;
        this.calendar = impreciseDate.calendar;
        this.string = impreciseDate.string;
        this.dayPrecise = impreciseDate.dayPrecise;
        this.monthPrecise = impreciseDate.monthPrecise;
        this.timePresent = impreciseDate.timePresent;
        this.secPresent = impreciseDate.secPresent;
    }

    private void initialize(Date date) {
        Validate.notNull((Object)date, (String)"The passed in date cannot be null.");
        this.date = (Date)date.clone();
        this.calendar = Calendar.getInstance();
        this.calendar.setLenient(false);
        this.calendar.setTime(this.date);
        this.string = null;
        this.dayPrecise = true;
        this.monthPrecise = true;
        this.timePresent = true;
        this.secPresent = true;
    }

    private void initialize(Calendar calendar) {
        Validate.notNull((Object)calendar, (String)"The passed in calendar cannot be null.");
        if (!calendar.isSet(1)) {
            throw new IllegalArgumentException("The passed in calendar must contain a year.");
        }
        if (!calendar.isSet(2)) {
            this.string = new ImpreciseDateStringFormat((Calendar)calendar.clone()).getString();
            this.date = null;
            this.monthPrecise = false;
            this.dayPrecise = false;
            this.timePresent = false;
            this.calendar = (Calendar)calendar.clone();
            this.calendar.clear();
            this.calendar.setLenient(false);
            this.calendar.set(1, calendar.get(1));
        } else if (!calendar.isSet(5)) {
            Calendar testCalendar = (Calendar)calendar.clone();
            testCalendar.setLenient(false);
            testCalendar.set(2, 0);
            testCalendar.set(5, 1);
            this.getDateFromCalendar(testCalendar);
            this.date = null;
            this.string = new ImpreciseDateStringFormat((Calendar)calendar.clone()).getString();
            this.monthPrecise = true;
            this.dayPrecise = false;
            this.timePresent = false;
            this.calendar = (Calendar)calendar.clone();
            this.calendar.clear();
            this.calendar.setLenient(false);
            this.calendar.set(1, calendar.get(1));
            this.calendar.set(2, calendar.get(2));
        } else {
            this.calendar = (Calendar)calendar.clone();
            this.calendar.setLenient(false);
            if (this.calendar.isSet(11) && this.calendar.isSet(12)) {
                this.timePresent = true;
                this.secPresent = this.calendar.isSet(13);
            } else {
                this.timePresent = false;
            }
            if (!this.calendar.isSet(11)) {
                this.calendar.set(11, 0);
            }
            if (!this.calendar.isSet(12)) {
                this.calendar.set(12, 0);
            }
            if (!this.calendar.isSet(13)) {
                this.calendar.set(13, 0);
            }
            if (!this.calendar.isSet(14)) {
                this.calendar.set(14, 0);
            }
            this.date = this.getDateFromCalendar(this.calendar);
            this.string = null;
            this.dayPrecise = true;
            this.monthPrecise = true;
        }
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.clone();
    }

    public boolean isImprecise() {
        return this.date == null;
    }

    public boolean isPrecise() {
        return !this.isImprecise();
    }

    public boolean isDayPrecise() {
        return this.dayPrecise;
    }

    public boolean isMonthPrecise() {
        return this.monthPrecise;
    }

    public boolean isTimePresent() {
        return this.timePresent;
    }

    public boolean isSecPresent() {
        return this.secPresent;
    }

    public String getString() {
        return this.string;
    }

    private Date getDateFromCalendar(Calendar calendar) {
        try {
            return calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The passed in calendar represents an invalid date.");
        }
    }

    public String toString() {
        return this.date == null ? this.string : this.date.toString();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ImpreciseDate && this.equals((ImpreciseDate)o);
    }

    private boolean equals(ImpreciseDate o) {
        return this.date == null ? this.string.equals(o.string) : this.date.equals(o.date);
    }

    public int hashCode() {
        return this.date == null ? this.string.hashCode() : this.date.hashCode();
    }

    public Object clone() {
        return new ImpreciseDate(this);
    }

    public int compareTo(Object o) {
        return this.compareTo((ImpreciseDate)o);
    }

    public int compareTo(ImpreciseDate o) {
        int val = 0;
        if (o == null) {
            val = -1;
        } else if (!this.equals(o)) {
            Date oDate;
            Date thisDate = ImpreciseDateUtils.getDateWithDefault(this);
            val = thisDate.after(oDate = ImpreciseDateUtils.getDateWithDefault(o)) ? 1 : -1;
        }
        return val;
    }

    public String toStandardFormat() {
        String val = null;
        val = this.isImprecise() ? this.getString() : (this.isTimePresent() ? (this.isSecPresent() ? new SimpleDateFormat(STANDARD_IMPRECISE_DATE_TS_FORMAT_WITH_ALL_COMPONENTS).format(this.getDate()) : new SimpleDateFormat(STANDARD_IMPRECISE_DATE_HHMM_TS_FORMAT_WITH_ALL_COMPONENTS).format(this.getDate())) : new SimpleDateFormat(STANDARD_IMPRECISE_DATE_FORMAT_WITH_ALL_COMPONENTS).format(this.getDate()));
        return val;
    }

    public String getyyyyMMddFormat() {
        Calendar cal;
        Date dt = this.getDate();
        if (dt == null && (cal = this.getCalendar()) != null) {
            dt = cal.getTime();
        }
        if (dt != null) {
            return new SimpleDateFormat(STANDARD_IMPRECISE_DATE_FORMAT_WITH_ALL_COMPONENTS).format(dt);
        }
        return "";
    }

    public String getStandardFormat() {
        return this.toStandardFormat();
    }

    public String getYear() {
        return this.toStandardFormat().substring(0, 4);
    }

    public String getMonth() {
        return this.toStandardFormat().substring(4, 6);
    }

    public String getDay() {
        return this.toStandardFormat().substring(6, 8);
    }

    public String getImpreciseDate() {
        return this.getString();
    }
}

