/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.msds.CombatEpisodeBuilderStrategy;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Deployment;
import gov.va.med.fw.rule.SimpleRuleMethod;
import gov.va.med.fw.util.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VadirCombatEpisodeBuilderStrategy
implements CombatEpisodeBuilderStrategy {
    private List deployments = new ArrayList();
    private Date combatPayStart = null;
    private Date combatPayEnd = null;

    @Override
    public String determineConflictLocationCode() {
        List filteredList = this.filterIncomingDeployments(this.getCombatPayStart(), this.getCombatPayEnd(), this.getDeployments());
        if (filteredList == null || filteredList.isEmpty()) {
            return ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode();
        }
        ArrayList<String> specialOpCodes = new ArrayList<String>();
        for (Deployment deployment : filteredList) {
            if (deployment.getSpecialOperation() == null) continue;
            specialOpCodes.add(deployment.getSpecialOperation());
        }
        String NOBLE_EAGLE = SpecialOperation.OPERATION_NOBLE_EAGLE.getCode();
        String IRAQI_FREEDOM = SpecialOperation.OPERATION_IRAQI_FREEDOM.getCode();
        String ENDURING_FREEDOM = SpecialOperation.OPERATION_ENDURING_FREEDOM.getCode();
        if (specialOpCodes.contains(ENDURING_FREEDOM) && !specialOpCodes.contains(NOBLE_EAGLE) && !specialOpCodes.contains(IRAQI_FREEDOM)) {
            return ConflictLocation.CODE_OEF.getCode();
        }
        if (specialOpCodes.contains(IRAQI_FREEDOM) && !specialOpCodes.contains(NOBLE_EAGLE) && !specialOpCodes.contains(ENDURING_FREEDOM)) {
            return ConflictLocation.CODE_OIF.getCode();
        }
        if (specialOpCodes.contains(NOBLE_EAGLE) && !specialOpCodes.contains(IRAQI_FREEDOM) && !specialOpCodes.contains(ENDURING_FREEDOM)) {
            return ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode();
        }
        if (specialOpCodes.size() > 1) {
            boolean case3;
            boolean case1 = specialOpCodes.contains(NOBLE_EAGLE) && specialOpCodes.contains(IRAQI_FREEDOM);
            boolean case2 = specialOpCodes.contains(NOBLE_EAGLE) && specialOpCodes.contains(ENDURING_FREEDOM);
            boolean bl = case3 = specialOpCodes.contains(IRAQI_FREEDOM) && specialOpCodes.contains(ENDURING_FREEDOM);
            if (case1 || case2 || case3) {
                return ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode();
            }
        }
        return ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode();
    }

    @Override
    public ImpreciseDate determineEndDate() {
        return this.determineEndOrStartDate(this.getDeployments(), this.getCombatPayStart(), this.getCombatPayEnd(), false);
    }

    @Override
    public ImpreciseDate determineStartDate() {
        return this.determineEndOrStartDate(this.getDeployments(), this.getCombatPayStart(), this.getCombatPayEnd(), true);
    }

    private ImpreciseDate determineEndOrStartDate(List deployments, Date payStartDt, Date payEndDt, boolean isStart) {
        Date result = null;
        ImpreciseDate defaultDate = isStart ? ImpreciseDateUtils.createImpreciseDateWithoutTime(payStartDt) : ImpreciseDateUtils.createImpreciseDateWithoutTime(payEndDt);
        List workingList = this.filterIncomingDeployments(payStartDt, payEndDt, deployments);
        for (Deployment deployment : workingList) {
            Date startDate = deployment.getStartDate();
            Date endDate = deployment.getEndDate();
            if (startDate == null || endDate == null) continue;
            if (isStart) {
                if (result == null) {
                    result = startDate;
                }
                if (!DateUtils.isBeforeIgnoreTime((Date)startDate, (Date)result)) continue;
                result = startDate;
                continue;
            }
            if (result == null) {
                result = endDate;
            }
            if (!DateUtils.isAfterIgnoreTime((Date)endDate, (Date)result)) continue;
            result = endDate;
        }
        return result != null ? ImpreciseDateUtils.createImpreciseDateWithoutTime(result) : defaultDate;
    }

    private List filterIncomingDeployments(Date payStartDt, Date payEndDt, List incomingDeployments) {
        SimpleRuleMethod util = new SimpleRuleMethod();
        try {
            if (incomingDeployments == null || payStartDt == null || payEndDt == null || DateUtils.isEqualOrBeforeIgnoreTime((Date)payStartDt, (Date)util.toDate("11/11/1998"))) {
                return new ArrayList();
            }
        }
        catch (ParseException e) {
            return new ArrayList();
        }
        ArrayList<Deployment> filteredDeployments = new ArrayList<Deployment>();
        for (Deployment deployment : incomingDeployments) {
            Date startDate = deployment.getStartDate();
            Date endDate = deployment.getEndDate();
            if (startDate == null || endDate == null || !this.isInRange(startDate, endDate, payStartDt, payEndDt)) continue;
            filteredDeployments.add(deployment);
        }
        return filteredDeployments;
    }

    private boolean isInRange(Date startDate, Date endDate, Date lower_range, Date upper_range) {
        return startDate != null && endDate != null && lower_range != null && upper_range != null && DateUtils.isEqualOrBeforeIgnoreTime((Date)startDate, (Date)endDate) && DateUtils.isEqualOrBeforeIgnoreTime((Date)lower_range, (Date)upper_range) && DateUtils.isEqualOrAfterIgnoreTime((Date)startDate, (Date)lower_range) && DateUtils.isEqualOrBeforeIgnoreTime((Date)startDate, (Date)upper_range) && DateUtils.isEqualOrAfterIgnoreTime((Date)endDate, (Date)lower_range) && DateUtils.isEqualOrBeforeIgnoreTime((Date)endDate, (Date)upper_range);
    }

    @Override
    public void setCombatPayEnd(Date combatPayEnd) {
        this.combatPayEnd = combatPayEnd;
    }

    @Override
    public void setCombatPayStart(Date combatPayStart) {
        this.combatPayStart = combatPayStart;
    }

    @Override
    public void setDeployments(List deployments) {
        this.deployments = deployments;
    }

    private Date getCombatPayEnd() {
        return this.combatPayEnd;
    }

    private Date getCombatPayStart() {
        return this.combatPayStart;
    }

    private List getDeployments() {
        return this.deployments;
    }
}

