/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.CombatServiceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.msds.ActivationMetaDataFromMSDS;
import gov.va.med.esr.common.builder.msds.CombatEpisodeMetaDataFromVADIR;
import gov.va.med.esr.common.builder.msds.CombatServiceMetaDataFromMSDS;
import gov.va.med.esr.common.builder.msds.MilitaryServiceEpisodeMetaDataFromVADIR;
import gov.va.med.esr.common.builder.msds.MilitaryServiceMetaDataMSDS;
import gov.va.med.esr.common.builder.msds.MilitaryServiceSiteRecordMetaDataFromMSDS;
import gov.va.med.esr.common.builder.msds.VadirCombatEpisodeBuilderStrategy;
import gov.va.med.esr.common.builder.msds.VadirCombatServiceBuilderStrategy;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Activation;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.VADIR;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MilitaryServiceMetaDataFromVADIR
extends AbstractMetaData
implements MilitaryServiceMetaDataMSDS {
    private MilitaryService militaryService = null;
    private MilitaryServiceSiteRecordMetaData militaryServiceSiteRecordMetaData = null;
    private ActivationMetaData[] activations = null;
    private CombatServiceMetaData[] combatServices = null;
    private CombatEpisodeMetaData[] combatEpisodes = null;
    private VADIR vadir = null;
    private String metaDataError = null;
    private final String[] invalidComponent = new String[]{"Y", "D", "E", "W", "U", "T", "F", "L", "H", "K", "I", "O", "M", "B", "R"};
    private final String[] invalidTerminationReason = new String[]{"F", "W"};
    private final String[] invalidCombatPayType = new String[]{"03"};

    public MilitaryServiceMetaDataFromVADIR(VadirServiceResponseWrapper wrapper) {
        this.processWrapper(wrapper);
    }

    @Override
    public String getCombatVeteranEligibilityEndDate() {
        return null;
    }

    @Override
    public String getDisabilityRetirementStatus() {
        return this.vadir != null ? this.vadir.getRetirementStatusIndicator() : null;
    }

    @Override
    public String getDischargeDueToDisability() {
        return null;
    }

    @Override
    public MilitaryService getEntity() {
        return this.militaryService;
    }

    @Override
    public MilitaryServiceSiteRecordMetaData getMilitaryServiceSiteRecord() {
        return this.militaryServiceSiteRecordMetaData;
    }

    @Override
    public void setEntity(MilitaryService entity) {
        this.militaryService = entity;
    }

    @Override
    public ActivationMetaData[] getActivations() {
        return this.activations;
    }

    @Override
    public CombatServiceMetaData[] getCombatServices() {
        return this.combatServices;
    }

    @Override
    public CombatEpisodeMetaData[] getCombatEpisodes() {
        return this.combatEpisodes;
    }

    @Override
    public String getMetaDataError() {
        return this.metaDataError;
    }

    public void setMetaDataError(String metaDataError) {
        this.metaDataError = metaDataError;
    }

    private void processWrapper(VadirServiceResponseWrapper wrapper) {
        MilitaryHistory history;
        ArrayList<CombatServiceMetaDataFromMSDS> militaryPays = new ArrayList<CombatServiceMetaDataFromMSDS>();
        ArrayList combatEpisodesList = new ArrayList();
        ArrayList<ActivationMetaDataFromMSDS> activations = new ArrayList<ActivationMetaDataFromMSDS>();
        ArrayList<MilitaryServiceEpisodeMetaDataFromVADIR> servicePeriodsHEC = new ArrayList<MilitaryServiceEpisodeMetaDataFromVADIR>();
        MilitaryHistory militaryHistory = history = wrapper != null ? (MilitaryHistory)wrapper.getResult() : null;
        if (history != null) {
            List servicePeriods;
            this.vadir = history.getVadir();
            List list = servicePeriods = this.vadir != null ? this.vadir.getServicePeriods() : new ArrayList();
            if (servicePeriods != null) {
                for (ServicePeriod period : servicePeriods) {
                    List periodActs;
                    List acts;
                    if (StringUtils.contains((String[])this.invalidComponent, (String)period.getPersonnelCategory())) continue;
                    if ((period.getCharacterOfService() == null || StringUtils.isBlank((String)period.getCharacterOfService()) || "UNK".equals(period.getCharacterOfService()) || "Z".equals(period.getCharacterOfService())) && !"N".equals(period.getPersonnelCategory()) && !"V".equals(period.getPersonnelCategory()) && !"Q".equals(period.getPersonnelCategory())) {
                        this.setMetaDataError("05");
                    }
                    if ((acts = period.getActivations()) != null) {
                        for (Activation activation : acts) {
                            if (StringUtils.contains((String[])this.invalidTerminationReason, (String)activation.getTerminationRsn())) continue;
                            ActivationMetaDataFromMSDS data = new ActivationMetaDataFromMSDS(period, activation);
                            activations.add(data);
                        }
                    }
                    List combatPays = period.getMilitaryPayments();
                    ArrayList<MilitaryPay> paysForConversion = new ArrayList<MilitaryPay>();
                    if (combatPays != null) {
                        for (MilitaryPay pay : combatPays) {
                            if (StringUtils.contains((String[])this.invalidCombatPayType, (String)pay.getPayType())) continue;
                            CombatServiceMetaDataFromMSDS data = new CombatServiceMetaDataFromMSDS(period, pay);
                            militaryPays.add(data);
                            paysForConversion.add(pay);
                        }
                        this.processCombatEpisodes(combatEpisodesList, paysForConversion, period.getDeployments());
                    }
                    if (!("N".equals(period.getPersonnelCategory()) || "V".equals(period.getPersonnelCategory()) || "Q".equals(period.getPersonnelCategory()))) {
                        MilitaryServiceEpisodeMetaDataFromVADIR periodMeta = new MilitaryServiceEpisodeMetaDataFromVADIR(period);
                        servicePeriodsHEC.add(periodMeta);
                    }
                    if (!"N".equals(period.getPersonnelCategory()) && !"V".equals(period.getPersonnelCategory()) && !"Q".equals(period.getPersonnelCategory()) || (periodActs = period.getActivations()) == null) continue;
                    for (Activation activation : periodActs) {
                        ServicePeriod actServicePeriod;
                        if (StringUtils.contains((String[])this.invalidTerminationReason, (String)activation.getTerminationRsn()) || (actServicePeriod = this.createServicePeriod(period, activation)) == null) continue;
                        MilitaryServiceEpisodeMetaDataFromVADIR actperiodMeta = new MilitaryServiceEpisodeMetaDataFromVADIR(actServicePeriod);
                        servicePeriodsHEC.add(actperiodMeta);
                    }
                }
            }
        }
        this.combatServices = militaryPays.toArray(new CombatServiceMetaData[0]);
        this.combatEpisodes = combatEpisodesList.toArray(new CombatEpisodeMetaDataFromVADIR[0]);
        this.militaryServiceSiteRecordMetaData = new MilitaryServiceSiteRecordMetaDataFromMSDS(servicePeriodsHEC.toArray(new MilitaryServiceEpisodeMetaData[0]));
        this.activations = activations.toArray(new ActivationMetaData[0]);
    }

    private void processCombatEpisodes(List combatEpisodesMetaData, List pays, List deployments) {
        VadirCombatServiceBuilderStrategy militaryPayStrategy = new VadirCombatServiceBuilderStrategy();
        List paysForConversion = militaryPayStrategy.determineMilitaryPayToKeep(pays);
        for (MilitaryPay pay : paysForConversion) {
            VadirCombatEpisodeBuilderStrategy strategy = new VadirCombatEpisodeBuilderStrategy();
            strategy.setCombatPayStart(pay.getStartDate());
            strategy.setCombatPayEnd(pay.getEndDate());
            strategy.setDeployments(deployments);
            String location = strategy.determineConflictLocationCode();
            ImpreciseDate calculatedStartDt = strategy.determineStartDate();
            ImpreciseDate calculatedEndDt = strategy.determineEndDate();
            CombatEpisodeMetaDataFromVADIR metadata = new CombatEpisodeMetaDataFromVADIR(pay, location, calculatedStartDt, calculatedEndDt);
            combatEpisodesMetaData.add(metadata);
        }
    }

    private ServicePeriod createServicePeriod(ServicePeriod incomingServicePeriod, Activation incomingActivation) {
        ServicePeriod createdServicePeriod = null;
        if (incomingActivation != null) {
            createdServicePeriod = new ServicePeriod();
            createdServicePeriod.setPersonnelCategory(incomingServicePeriod.getPersonnelCategory());
            createdServicePeriod.setBranchOfService(incomingServicePeriod.getBranchOfService());
            createdServicePeriod.setCharacterOfService(incomingActivation.getCharacterOfService());
            createdServicePeriod.setStartDate(incomingActivation.getStartDate());
            createdServicePeriod.setEndDate(incomingActivation.getEndDate());
        }
        return createdServicePeriod;
    }
}

