/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.VAPensionMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.fw.hl7.segment.OBX;
import java.util.List;

public class VAPensionMetaDataFromOBX
extends AbstractMetaData
implements VAPensionMetaData {
    private static final String AAC = "AAC";
    private static final String PENSION = "Pension";
    private MonetaryBenefitAward entity;
    private List obxs;
    private String effectiveDate = null;
    private String terminationDate = null;
    private String awardReasonCode = null;
    private String[] terminationReasonCodes = new String[4];

    public VAPensionMetaDataFromOBX(List obxs) {
        this.obxs = obxs;
        if (obxs != null && obxs.size() > 0) {
            this.parseObxs();
        }
    }

    private void parseObxs() {
        OBX pensionObx = null;
        for (int index = 0; index < (this.obxs == null ? 0 : this.obxs.size()); ++index) {
            OBX current = (OBX)this.obxs.get(index);
            CE id = CE.create(current.getObservationID(), current.getComponentDelimiter());
            if (id == null || !AAC.equals(super.getValue(id.getID())) || !PENSION.equals(super.getValue(id.getText()))) continue;
            pensionObx = current;
        }
        if (pensionObx != null) {
            if (pensionObx.getObservationValue() != null) {
                String[] values = pensionObx.getObservationValue().split("\\|");
                for (int i = 0; i < values.length && i <= 3; ++i) {
                    this.terminationReasonCodes[i] = values[i].split("\\~")[0];
                }
            }
            this.effectiveDate = pensionObx.getLastObservationNormalValueDate();
            this.terminationDate = pensionObx.getObservationDate();
            this.awardReasonCode = pensionObx.getProducerID();
        }
    }

    @Override
    public MonetaryBenefitAward getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(MonetaryBenefitAward entity) {
        this.entity = entity;
    }

    @Override
    public String getAwardReasonCode() {
        return this.awardReasonCode;
    }

    @Override
    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public String getTerminationDate() {
        return this.terminationDate;
    }

    @Override
    public String[] getTerminationReasonCodes() {
        return this.terminationReasonCodes;
    }
}

