/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData;
import gov.va.med.esr.common.builder.entity.ServiceConnectionAwardMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.RatedDisabilityMetaDataFromZRD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.fw.hl7.segment.ZRD;
import gov.va.med.fw.hl7.segment.ZSP;
import java.util.List;

public class ServiceConnectionAwardMetaDataFromZSP
extends AbstractMetaData
implements ServiceConnectionAwardMetaData {
    private ServiceConnectionAward entity;
    private ZSP zsp;
    private RatedDisabilityMetaData[] ratedDisabilities;

    public ServiceConnectionAwardMetaDataFromZSP(ZSP zsp, List zrds) {
        this.zsp = zsp;
        this.ratedDisabilities = this.buildRatedDisabilities(zrds);
    }

    private RatedDisabilityMetaData[] buildRatedDisabilities(List zrds) {
        int size = zrds == null ? 0 : zrds.size();
        RatedDisabilityMetaData[] results = new RatedDisabilityMetaData[size];
        for (int index = 0; index < size; ++index) {
            results[index] = new RatedDisabilityMetaDataFromZRD((ZRD)zrds.get(index));
        }
        return results;
    }

    @Override
    public ServiceConnectionAward getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(ServiceConnectionAward entity) {
        this.entity = entity;
    }

    @Override
    public String getAwardDate() {
        return this.zsp == null ? null : this.zsp.getServiceConnectedAwardDate();
    }

    @Override
    public String getPermanentAndTotal() {
        return this.zsp == null ? null : this.zsp.getPermanentAndTotal();
    }

    @Override
    public String getPermanentAndTotalEffectiveDate() {
        return this.zsp == null ? null : this.zsp.getPermanentAndTotalEffectiveDate();
    }

    @Override
    public RatedDisabilityMetaData[] getRatedDisabilities() {
        return this.ratedDisabilities;
    }

    @Override
    public String getServiceConnected() {
        return this.zsp == null ? null : this.zsp.getServiceConnected();
    }

    @Override
    public String getServiceConnectedPercentage() {
        return this.zsp == null ? null : this.zsp.getServiceConnectedPercentage();
    }

    @Override
    public String getCombinedSCPercentEffectiveDate() {
        return this.zsp == null ? null : this.zsp.getCombinedSCPercentEffectiveDate();
    }

    @Override
    public String getUnemployable() {
        return this.zsp == null ? null : this.zsp.getUnemployable();
    }
}

