/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.ST;
import gov.va.med.esr.common.builder.datatype.metadata.XPN;
import gov.va.med.esr.common.builder.entity.BirthRecordMetaData;
import gov.va.med.esr.common.builder.entity.DeathRecordMetaData;
import gov.va.med.esr.common.builder.entity.EthnicityMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.builder.entity.RaceMetaData;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.BirthRecordMetaDataFromPID;
import gov.va.med.esr.common.builder.entity.metaData.DeathRecordMetaDataFromZPD;
import gov.va.med.esr.common.builder.entity.metaData.EthnicityMetaDataFromCE;
import gov.va.med.esr.common.builder.entity.metaData.NameMetaDataFromST;
import gov.va.med.esr.common.builder.entity.metaData.NameMetaDataFromXPN;
import gov.va.med.esr.common.builder.entity.metaData.RaceMetaDataFromCE;
import gov.va.med.esr.common.builder.entity.metaData.SSNMetaDataFromPID;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZEM;
import gov.va.med.fw.hl7.segment.ZEN;
import gov.va.med.fw.hl7.segment.ZIO;
import gov.va.med.fw.hl7.segment.ZMH;
import gov.va.med.fw.hl7.segment.ZPD;
import java.util.List;

public class PersonMetaDataFromPID
extends AbstractMetaData
implements PersonMetaData {
    private Person entity;
    private PID pid;
    private ZPD zpd;
    private ZEM zem;
    private ZEN zen;
    private ZEL zel;
    private ZIO zio;
    private BirthRecordMetaData birthRecord;
    private DeathRecordMetaData deathRecord;
    private NameMetaData[] names;
    private CE wasPrisonerOfWarIndicator;
    private SSNMetaData[] ssns;
    private NameMetaData motherName;
    private NameMetaData fatherName;
    private RaceMetaData[] races;
    private EthnicityMetaData ethnicity;
    private static final int REL_MOTHER = 1;
    private static final int REL_FATHER = 2;

    public PersonMetaDataFromPID(PID pid, ZPD zpd, ZEM zem, ZEN zen, ZEL zel, MSH msh, List zmhs, ZIO zio) {
        this.pid = pid;
        this.zpd = zpd;
        this.zem = zem;
        this.zen = zen;
        this.zel = zel;
        this.zio = zio;
        this.birthRecord = pid == null ? null : new BirthRecordMetaDataFromPID(pid);
        this.deathRecord = zpd == null ? null : new DeathRecordMetaDataFromZPD(zpd, msh, false);
        this.names = pid == null ? null : this.buildNames(pid);
        this.ssns = pid == null ? null : this.buildSsns();
        this.processZMHsForPOWIndicator(zmhs);
        this.motherName = pid == null ? null : this.buildRelationName(zpd, 1);
        this.fatherName = pid == null ? null : this.buildRelationName(zpd, 2);
        this.races = pid == null ? null : this.buildRaces();
        this.ethnicity = pid == null ? null : new EthnicityMetaDataFromCE(CE.create(pid.getEthnicity(), pid.getComponentDelimiter()));
    }

    private SSNMetaData[] buildSsns() {
        SSNMetaData[] ssns = new SSNMetaData[1];
        SSNMetaDataFromPID ssnMetaData = new SSNMetaDataFromPID(this.pid, this.zpd);
        ssns[0] = ssnMetaData;
        return ssns;
    }

    private NameMetaData[] buildNames(PID pid) {
        return this.buildNames(this.getLegalName(pid), this.getOtherNames(pid));
    }

    private NameMetaData[] buildNames(XPN legalName, XPN[] otherNames) {
        int size = otherNames == null ? 0 : otherNames.length;
        int sizeWithLegalName = size + (legalName == null ? 0 : 1);
        NameMetaData[] results = new NameMetaData[sizeWithLegalName];
        for (int index = 0; index < size; ++index) {
            results[index] = new NameMetaDataFromXPN(otherNames[index]);
        }
        if (legalName != null) {
            results[size] = new NameMetaDataFromXPN(legalName);
        }
        return results;
    }

    private XPN getLegalName(PID pid) {
        XPN[] data = XPN.create(pid.getPatientName(), pid.getRepeatDelimiter(), pid.getComponentDelimiter());
        if (data != null && data.length > 0) {
            XPN legalXPN = data[0];
            if (legalXPN != null) {
                legalXPN.setTypeCode(ID.create(NameType.LEGAL_NAME.getName()));
            }
            return legalXPN;
        }
        return null;
    }

    private XPN[] getOtherNames(PID pid) {
        return XPN.create(pid.getPatientAlias(), pid.getRepeatDelimiter(), pid.getComponentDelimiter());
    }

    private NameMetaData buildRelationName(ZPD zpd, int relType) {
        NameMetaDataFromST metaData = null;
        String dataString = null;
        switch (relType) {
            case 1: {
                dataString = zpd.getMotherName();
                break;
            }
            case 2: {
                dataString = zpd.getFatherName();
            }
        }
        if (dataString != null) {
            ST data = ST.createForParent(dataString);
            metaData = new NameMetaDataFromST(data);
        }
        return metaData;
    }

    private RaceMetaData[] buildRaces() {
        RaceMetaData[] results = null;
        CE[] data = CE.create(this.pid.getRace(), this.pid.getRepeatDelimiter(), this.pid.getComponentDelimiter());
        if (data != null && data.length > 0) {
            int size = data.length;
            results = new RaceMetaData[size];
            for (int index = 0; index < size; ++index) {
                results[index] = new RaceMetaDataFromCE(data[index]);
            }
        }
        return results;
    }

    @Override
    public Person getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Person entity) {
        this.entity = entity;
    }

    @Override
    public BirthRecordMetaData getBirthRecord() {
        return this.birthRecord;
    }

    @Override
    public DeathRecordMetaData getDeathRecord() {
        return this.deathRecord;
    }

    @Override
    public String getGender() {
        return this.pid == null ? null : this.pid.getSex();
    }

    @Override
    public String getMaritalStatus() {
        return this.pid == null ? null : this.pid.getMaritalStatus();
    }

    @Override
    public NameMetaData[] getNames() {
        return this.names;
    }

    @Override
    public String getNationalICN() {
        return this.pid == null ? null : this.pid.getPrimaryID();
    }

    @Override
    public String getPreferredFacility() {
        return this.zen == null ? null : this.zen.getPreferredFacility();
    }

    @Override
    public String getRace() {
        return this.zpd == null ? null : this.zpd.getRace();
    }

    @Override
    public SSNMetaData[] getSsns() {
        return this.ssns;
    }

    @Override
    public String getVeteran() {
        return this.zel == null ? null : this.zel.getVeteran();
    }

    @Override
    public String getWasPrisonerOfWar() {
        return this.wasPrisonerOfWarIndicator == null ? null : super.getValue(this.wasPrisonerOfWarIndicator.getID());
    }

    private boolean isPOW(String type) {
        return "POW".equals(type);
    }

    @Override
    public String getAppointmentRequestOn1010EZ() {
        return this.zio == null ? null : this.zio.getAppointmentRequestOn1010EZ();
    }

    @Override
    public String getAppointmentRequestDate() {
        return this.zio == null ? null : this.zio.getAppointmentRequestDate();
    }

    @Override
    public String getEmergencyResponseType() {
        return this.zpd == null ? null : this.zpd.getEmergencyResponseType();
    }

    @Override
    public NameMetaData getMotherName() {
        return this.motherName;
    }

    @Override
    public NameMetaData getFatherName() {
        return this.fatherName;
    }

    @Override
    public EthnicityMetaData getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(EthnicityMetaData ethnicity) {
        this.ethnicity = ethnicity;
    }

    @Override
    public RaceMetaData[] getRaces() {
        return this.races;
    }

    public void setRaces(RaceMetaData[] races) {
        this.races = races;
    }

    private void processZMHsForPOWIndicator(List zmhs) {
        for (int index = 0; index < (zmhs == null ? 0 : zmhs.size()); ++index) {
            ZMH zmh = (ZMH)zmhs.get(index);
            String type = zmh.getMilitaryHistoryType();
            if (!this.isPOW(type)) continue;
            this.wasPrisonerOfWarIndicator = CE.create(zmh.getServiceIndicator(), zmh.getComponentDelimiter());
        }
    }

    @Override
    public String getReligion() {
        return this.pid == null ? null : this.pid.getReligion();
    }

    @Override
    public String getMothersMaidenName() {
        return this.pid == null ? null : this.pid.getMotherMaidenName();
    }
}

