/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.service.external.person.IncomeTestStatusInfo;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IncomeTestStatusMetaDataFromIVM
extends AbstractMetaData
implements IncomeTestStatusMetaData {
    private IncomeTestStatus entity;
    private IncomeTestStatusInfo status;
    private String impreciseDateFormat = "yyyyMMdd";

    public IncomeTestStatusMetaDataFromIVM(IncomeTestStatusInfo status) {
        this.status = status;
    }

    @Override
    public IncomeTestStatus getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(IncomeTestStatus entity) {
        this.entity = entity;
    }

    @Override
    public String getCompletedDate() {
        return this.status == null ? null : this.toImpreciseDateFormat(this.status.getCompletedDate());
    }

    @Override
    public String getDeterminedStatus() {
        return this.status == null ? null : this.processIncomingCode(this.status.getDeterminedStatus());
    }

    @Override
    public String getLastEditedDate() {
        return this.status == null ? null : this.toImpreciseDateFormat(this.status.getLastEditedDate());
    }

    @Override
    public String getStatus() {
        return this.status == null ? null : this.processIncomingCode(this.status.getStatus());
    }

    @Override
    public String getType() {
        return this.status == null ? null : this.processIncomingCode(this.status.getIncomeTestType());
    }

    private String toImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.impreciseDateFormat);
            return format.format(date);
        }
        return "";
    }

    private String processIncomingCode(String incomingCode) {
        if (incomingCode != null) {
            int separatorLoc = incomingCode.indexOf("^");
            if (separatorLoc < 0) {
                return incomingCode.startsWith("0") ? incomingCode.substring(1) : incomingCode;
            }
            return incomingCode.startsWith("0") ? incomingCode.substring(1, separatorLoc) : incomingCode.substring(0, separatorLoc);
        }
        return incomingCode;
    }
}

