/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.FinancialStatementMetaData;
import gov.va.med.esr.common.builder.entity.metaData.DependentFinancialsMetaDataFromIVM;
import gov.va.med.esr.common.builder.entity.metaData.FinancialInformationMetaDataFromIVM;
import gov.va.med.esr.common.builder.entity.metaData.SpouseFinancialsMetaDataFromIVM;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.service.external.person.DependentFinancialsInfo;
import gov.va.med.esr.service.external.person.FinancialStatementInfo;
import gov.va.med.esr.service.external.person.RelationFinancialsInfo;
import gov.va.med.esr.service.external.person.SpouseFinancialsInfo;
import gov.va.med.esr.service.external.person.collections.DependentFinancialsCollection;
import gov.va.med.esr.service.external.person.collections.SpouseFinancialsCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FinancialStatementMetaDataFromIVM
extends FinancialInformationMetaDataFromIVM
implements FinancialStatementMetaData {
    private FinancialStatement entity;
    private FinancialStatementInfo financialStatementInfo;
    private FinancialInformationMetaData[] supportingInformation;

    public FinancialStatementMetaDataFromIVM(FinancialStatementInfo financialStatementInfo, String incomeYear) {
        super(financialStatementInfo, incomeYear);
        this.financialStatementInfo = financialStatementInfo;
        this.processSegments(financialStatementInfo.getSpouseFinancialsList(), financialStatementInfo.getDependentFinancialsList(), incomeYear);
    }

    private void processSegments(SpouseFinancialsCollection spouseFinancialsList, DependentFinancialsCollection dependentFinancialsList, String incomeYear) {
        List<SpouseFinancialsInfo> spouseSegments = Arrays.asList(spouseFinancialsList.getSpouseFinancials());
        List<DependentFinancialsInfo> dependentSegments = Arrays.asList(dependentFinancialsList.getDependentFinancials());
        this.supportingInformation = new FinancialInformationMetaData[spouseSegments.size() + dependentSegments.size()];
        int index = 0;
        Iterator<RelationFinancialsInfo> i = spouseSegments.iterator();
        while (i.hasNext()) {
            this.supportingInformation[index] = new SpouseFinancialsMetaDataFromIVM(i.next(), incomeYear);
            ++index;
        }
        index = this.supportingInformation.length - 0;
        i = dependentSegments.iterator();
        while (i.hasNext()) {
            this.supportingInformation[index] = new DependentFinancialsMetaDataFromIVM((DependentFinancialsInfo)i.next(), incomeYear);
            ++index;
        }
    }

    @Override
    public FinancialStatement getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(FinancialStatement entity) {
        this.entity = entity;
    }

    @Override
    public String getContributionToSpouse() {
        return null;
    }

    @Override
    public String getMarriedLastCalendarYear() {
        return null;
    }

    @Override
    public String getNumberOfDependentChildren() {
        return null;
    }

    @Override
    public String getMeansTestVersion() {
        return null;
    }

    @Override
    public FinancialInformationMetaData[] getSupportingInformation() {
        return this.supportingInformation;
    }

    @Override
    public String getContributedToSpouseInd() {
        return null;
    }
}

