/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.XON;
import gov.va.med.esr.common.builder.entity.BeneficiaryMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.segment.OBX;
import gov.va.med.fw.hl7.segment.PD1;
import gov.va.med.fw.hl7.segment.ZEL;

public class BeneficiaryMetaDataFromZEL
extends AbstractMetaData
implements BeneficiaryMetaData {
    private Person entity;
    private OBX obx;
    private ZEL zel;
    private CE sensitiveRecord;
    private XON cmor;
    private String claimFolderLocation;
    private String sendingFacility;

    public BeneficiaryMetaDataFromZEL(ZEL zel, PD1 pd1, OBX obx, String sendingFacility) {
        this.zel = zel;
        this.obx = obx;
        this.cmor = pd1 == null ? null : XON.create(pd1.getCIRN(), pd1.getComponentDelimiter(), pd1.getSubComponentDelimiter());
        this.sensitiveRecord = obx == null ? null : CE.create(obx.getObservationValue(), obx.getComponentDelimiter());
        String unprocessedLocation = this.zel == null ? null : this.zel.getClaimFolderLocation();
        this.claimFolderLocation = unprocessedLocation == null || unprocessedLocation.length() < 3 ? unprocessedLocation : unprocessedLocation.substring(0, 3);
        this.sendingFacility = sendingFacility;
    }

    @Override
    public Person getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Person entity) {
        this.entity = entity;
    }

    @Override
    public String getClaimFolderLocation() {
        return this.claimFolderLocation;
    }

    @Override
    public String getClaimFolderNumber() {
        return this.zel == null ? null : this.zel.getClaimFolderNumber();
    }

    @Override
    public String getCMOR() {
        return this.cmor == null ? null : super.getValue(this.cmor.getOrganizationName());
    }

    @Override
    public String getSensitiveRecord() {
        return this.sensitiveRecord == null ? null : super.getValue(this.sensitiveRecord.getID());
    }

    @Override
    public String getSensitivityChangeDate() {
        return this.obx == null ? null : this.obx.getObservationDate();
    }

    @Override
    public String getUserEnrolleeSite() {
        return this.zel == null ? null : this.zel.getUserEnrolleeSite();
    }

    @Override
    public String getUserEnrolleeValidThrough() {
        return this.zel == null ? null : this.zel.getUserEnrolleeValidThrough();
    }

    @Override
    public String getSensitivityChangeSite() {
        return this.sendingFacility;
    }
}

