/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.datatype.metadata.TN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.AssociationMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AddressMetaDataFromAD;
import gov.va.med.esr.common.builder.entity.metaData.PhoneMetaDataFromTN;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.fw.hl7.segment.ZGD;

public class AssociationMetaDataFromZGD
extends AbstractMetaData
implements AssociationMetaData {
    private Association entity;
    private ZGD zgd;
    private AddressMetaData address;
    private PhoneMetaData homePhone;

    public AssociationMetaDataFromZGD(ZGD zgd) {
        this.zgd = zgd;
        this.address = zgd == null ? null : new AddressMetaDataFromAD(AD.create(zgd.getGuardianAddress(), zgd.getComponentDelimiter()));
        this.homePhone = zgd == null ? null : new PhoneMetaDataFromTN(TN.create(zgd.getGuardianPhoneNumber()));
    }

    @Override
    public Association getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Association entity) {
        this.entity = entity;
    }

    @Override
    public AddressMetaData getAddress() {
        return this.address;
    }

    @Override
    public PhoneMetaData getPrimaryPhone() {
        return this.homePhone;
    }

    @Override
    public String getOrganizationName() {
        return this.zgd == null ? null : this.zgd.getGuardianInstitution();
    }

    @Override
    public String getRelationship() {
        return this.zgd == null ? null : this.zgd.getGuardianRelationship();
    }

    @Override
    public NameMetaData getContactName() {
        return null;
    }

    @Override
    public String getGuardianName() {
        return this.zgd == null ? null : this.zgd.getGuardianName();
    }

    @Override
    public String getType() {
        return this.zgd == null ? null : this.zgd.getGuardianType();
    }

    @Override
    public PhoneMetaData getAlternatePhone() {
        return null;
    }

    @Override
    public String getLastUpdateDate() {
        return null;
    }
}

