/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.datatype.metadata.TN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.AssociationMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AddressMetaDataFromAD;
import gov.va.med.esr.common.builder.entity.metaData.PhoneMetaDataFromTN;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.fw.hl7.segment.ZCT;

public class AssociationMetaDataFromZCT
extends AbstractMetaData
implements AssociationMetaData {
    private Association entity;
    private ZCT zct;
    private AddressMetaData address;
    private PhoneMetaData homePhone;
    private NameMetaData contactName;
    private PhoneMetaData workPhone;

    public AssociationMetaDataFromZCT(ZCT zct) {
        this.zct = zct;
        this.address = zct == null ? null : new AddressMetaDataFromAD(AD.create(zct.getContactAddress(), zct.getComponentDelimiter()));
        this.homePhone = zct == null ? null : new PhoneMetaDataFromTN(TN.create(zct.getContactPhoneNumber()));
        this.contactName = zct == null ? null : this.getNameMetaData(zct.getContactName(), zct.getRepeatDelimiter(), zct.getComponentDelimiter());
        this.workPhone = zct == null ? null : new PhoneMetaDataFromTN(TN.create(zct.getContactWorkPhoneNumber()));
    }

    @Override
    public Association getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Association entity) {
        this.entity = entity;
    }

    @Override
    public AddressMetaData getAddress() {
        return this.address;
    }

    @Override
    public PhoneMetaData getPrimaryPhone() {
        return this.homePhone;
    }

    @Override
    public String getOrganizationName() {
        return null;
    }

    @Override
    public String getRelationship() {
        return this.zct == null ? null : this.zct.getContactRelationship();
    }

    @Override
    public NameMetaData getContactName() {
        return this.contactName;
    }

    @Override
    public String getGuardianName() {
        return null;
    }

    @Override
    public String getType() {
        return this.zct == null ? null : this.zct.getContactType();
    }

    @Override
    public PhoneMetaData getAlternatePhone() {
        return this.workPhone;
    }

    @Override
    public String getLastUpdateDate() {
        return this.zct == null ? null : this.zct.getLastUpdateDate();
    }
}

