/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class SSNBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 7880899279739846819L;
    private static final String PSEUDO_SSN_SUFFIX = "P";
    private Builder ssnTypeBuilder;
    private Builder psuedoSSNReasonBuilder;

    public Builder getSSNTypeBuilder() {
        return this.ssnTypeBuilder;
    }

    public void setSSNTypeBuilder(Builder typeBuilder) {
        this.ssnTypeBuilder = typeBuilder;
    }

    public SSN build(SSNMetaData metaData) throws BuilderException {
        SSN input = metaData.getEntity();
        SSN output = input == null ? new SSN() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private SSNType buildType(SSNType input, String code) throws BuilderException {
        return (SSNType)super.build(this.ssnTypeBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(SSN obj) {
        return obj.getSsnText() != null;
    }

    private void transfer(SSN input, SSNMetaData metaData) throws BuilderException {
        String ssnText = metaData.getSSNText();
        if (ssnText != null && ssnText.endsWith(PSEUDO_SSN_SUFFIX)) {
            ssnText = ssnText.substring(0, ssnText.indexOf(PSEUDO_SSN_SUFFIX));
        }
        input.setSsnText(super.build(input.getSsnText(), ssnText));
        input.setType(this.buildType(input.getType(), metaData.getSSNType()));
        input.setPseudoSSNReason((PseudoSSNReason)super.build(this.psuedoSSNReasonBuilder, (AbstractLookup)input.getPseudoSSNReason(), metaData.getPseudoSSNReason()));
    }

    public Builder getPsuedoSSNReasonBuilder() {
        return this.psuedoSSNReasonBuilder;
    }

    public void setPsuedoSSNReasonBuilder(Builder psuedoSSNReasonBuilder) {
        this.psuedoSSNReasonBuilder = psuedoSSNReasonBuilder;
    }

    public Builder getSsnTypeBuilder() {
        return this.ssnTypeBuilder;
    }

    public void setSsnTypeBuilder(Builder ssnTypeBuilder) {
        this.ssnTypeBuilder = ssnTypeBuilder;
    }
}

