/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class PhoneBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 7733570818624765558L;
    private Builder changeSourceBuilder;
    private Builder phoneTypeBuilder;
    private Builder phoneTypeFromTelecomCodeBuilder;

    public Builder getChangeSourceBuilder() {
        return this.changeSourceBuilder;
    }

    public void setChangeSourceBuilder(Builder changeSourceBuilder) {
        this.changeSourceBuilder = changeSourceBuilder;
    }

    public Builder getPhoneTypeBuilder() {
        return this.phoneTypeBuilder;
    }

    public void setPhoneTypeBuilder(Builder typeBuilder) {
        this.phoneTypeBuilder = typeBuilder;
    }

    public Builder getPhoneTypeFromTelecomCodeBuilder() {
        return this.phoneTypeFromTelecomCodeBuilder;
    }

    public void setPhoneTypeFromTelecomCodeBuilder(Builder phoneTypeFromTelecomCodeBuilder) {
        this.phoneTypeFromTelecomCodeBuilder = phoneTypeFromTelecomCodeBuilder;
    }

    public Phone build(PhoneMetaData metaData) throws BuilderException {
        Phone input = metaData.getEntity();
        Phone output = input == null ? new Phone() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private PhoneType buildType(PhoneType input, String code) throws BuilderException {
        return (PhoneType)super.build(this.phoneTypeBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(Phone obj) {
        if (obj.getPhoneNumber() == null && obj.getType() != null && obj.getChangeDate() != null) {
            obj.setPhoneNumber("");
        }
        return obj.getPhoneNumber() != null;
    }

    private void transfer(Phone input, PhoneMetaData metaData) throws BuilderException {
        input.setChangeDate(super.build(input.getChangeDate(), metaData.getChangeDate()));
        input.setSiteOfChange(super.build(input.getSiteOfChange(), metaData.getChangeSite()));
        input.setSourceOfChange((PhoneSourceOfChange)super.build(this.changeSourceBuilder, (AbstractLookup)input.getSourceOfChange(), metaData.getChangeSource()));
        input.setPhoneNumber(super.build(input.getPhoneNumber(), metaData.getPhoneNumber()));
        if (metaData.getType() != null) {
            input.setType(this.buildType(input.getType(), metaData.getType()));
        } else {
            input.setType((PhoneType)super.build(this.phoneTypeFromTelecomCodeBuilder, (AbstractLookup)input.getType(), metaData.getTelecomUseCode()));
        }
    }
}

