/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.InsurancePlanMetaData;
import gov.va.med.esr.common.builder.entity.InsurancePolicyMetaData;
import gov.va.med.esr.common.builder.entity.InsuranceSubscriberMetaData;
import gov.va.med.esr.common.builder.entity.MedicareMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.PrivateInsuranceMetaData;
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public abstract class InsurancePolicyBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -1370346746640850300L;
    private Builder addressBuilder;
    private Builder phoneBuilder;
    private Builder planBuilder;
    private Builder subscriberBuilder;
    private Builder insuranceReportSourceBuilder;

    public Builder getAddressBuilder() {
        return this.addressBuilder;
    }

    public void setAddressBuilder(Builder addressBuilder) {
        this.addressBuilder = addressBuilder;
    }

    public Builder getPhoneBuilder() {
        return this.phoneBuilder;
    }

    public void setPhoneBuilder(Builder phoneBuilder) {
        this.phoneBuilder = phoneBuilder;
    }

    public Builder getPlanBuilder() {
        return this.planBuilder;
    }

    public void setPlanBuilder(Builder planBuilder) {
        this.planBuilder = planBuilder;
    }

    public Builder getSubscriberBuilder() {
        return this.subscriberBuilder;
    }

    public void setSubscriberBuilder(Builder subscriberBuilder) {
        this.subscriberBuilder = subscriberBuilder;
    }

    public Builder getInsuranceReportSourceBuilder() {
        return this.insuranceReportSourceBuilder;
    }

    public void setInsuranceReportSourceBuilder(Builder insuranceReportSourceBuilder) {
        this.insuranceReportSourceBuilder = insuranceReportSourceBuilder;
    }

    private Address buildAddress(Address input, AddressMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Address)this.addressBuilder.build((Object)metaData);
    }

    private Phone buildPhone(Phone input, PhoneMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Phone)((Object)this.phoneBuilder.build((Object)metaData));
    }

    private InsurancePlan buildInsurancePlan(InsurancePlan input, InsurancePlanMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (InsurancePlan)((Object)this.planBuilder.build((Object)metaData));
    }

    private InsuranceSubscriber buildSubsciber(InsuranceSubscriber input, InsuranceSubscriberMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (InsuranceSubscriber)((Object)this.subscriberBuilder.build((Object)metaData));
    }

    private boolean shouldKeep(InsurancePolicy obj) {
        return obj.getSubscriber() != null;
    }

    private void transfer(InsurancePolicy input, InsurancePolicyMetaData metaData) throws BuilderException {
        input.setAddress(this.buildAddress(input.getAddress(), metaData.getAddress()));
        input.setBusinessPhone(this.buildPhone(input.getBusinessPhone(), metaData.getBusinessPhone()));
        input.setSubscriber(this.buildSubsciber(input.getSubscriber(), metaData.getSubscriber()));
        input.setInsurancePlan(this.buildInsurancePlan(input.getInsurancePlan(), metaData.getPlan()));
        input.setReportSite(super.build(input.getReportSite(), metaData.getReportSite()));
    }

    public static class MedicareBuilder
    extends InsurancePolicyBuilder {
        private static final long serialVersionUID = -2457859721723463485L;

        public Medicare build(MedicareMetaData metaData) throws BuilderException {
            Medicare input = metaData.getEntity();
            Medicare output = input == null ? new Medicare() : input;
            this.transfer(output, metaData);
            return this.shouldKeep(output) ? output : null;
        }

        private boolean shouldKeep(Medicare obj) {
            return ((InsurancePolicyBuilder)this).shouldKeep(obj) && obj.getMedicareClaimNumber() != null;
        }

        private void transfer(Medicare input, MedicareMetaData metaData) throws BuilderException {
            ((InsurancePolicyBuilder)this).transfer(input, metaData);
            input.setEnrolledInPartA(super.build(input.isEnrolledInPartA(), metaData.getEnrolledInPartA()));
            input.setEnrolledInPartB(super.build(input.isEnrolledInPartB(), metaData.getEnrolledInPartB()));
            input.setMedicareClaimNumber(super.build(input.getMedicareClaimNumber(), metaData.getMedicareClaimNumber()));
            input.setPartAEffectiveDate(super.build(input.getPartAEffectiveDate(), metaData.getPartAEffectiveDate()));
            input.setPartBEffectiveDate(super.build(input.getPartBEffectiveDate(), metaData.getPartBEffectiveDate()));
        }
    }

    public static class PrivateInsuranceBuilder
    extends InsurancePolicyBuilder {
        private static final long serialVersionUID = -6508537414864674678L;

        public PrivateInsurance build(PrivateInsuranceMetaData metaData) throws BuilderException {
            PrivateInsurance input = metaData.getEntity();
            PrivateInsurance output = input == null ? new PrivateInsurance() : input;
            this.transfer(output, metaData);
            return this.shouldKeep(output) ? output : null;
        }

        private boolean shouldKeep(PrivateInsurance obj) {
            return ((InsurancePolicyBuilder)this).shouldKeep(obj) && obj.getPolicyNumber() != null;
        }

        private void transfer(PrivateInsurance input, PrivateInsuranceMetaData metaData) throws BuilderException {
            ((InsurancePolicyBuilder)this).transfer(input, metaData);
            input.setCompanyName(super.build(input.getCompanyName(), metaData.getCompanyName()));
            input.setGroupName(super.build(input.getGroupName(), metaData.getGroupName()));
            input.setGroupNumber(super.build(input.getGroupNumber(), metaData.getGroupNumber()));
            input.setPolicyEffectiveDate(super.build(input.getPolicyEffectiveDate(), metaData.getEffectiveDate()));
            input.setPolicyExpirationDate(super.build(input.getPolicyExpirationDate(), metaData.getExpirationDate()));
            input.setPolicyNumber(super.build(input.getPolicyNumber(), metaData.getPolicyNumber()));
        }
    }
}

