/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.HardshipMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IncomeTestBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 6476065921296864806L;
    private Builder addressBuilder;
    private Builder hardshipBuilder;
    private Builder incomeVerificationStatusBuilder;
    private Builder sourceBuilder;
    private Builder statusBuilder;
    private Builder typeBuilder;
    private Builder mtStatusBuilder;
    private Builder wfCaseStatusBuilder;

    public Builder getAddressBuilder() {
        return this.addressBuilder;
    }

    public void setAddressBuilder(Builder addressBuilder) {
        this.addressBuilder = addressBuilder;
    }

    public Builder getHardshipBuilder() {
        return this.hardshipBuilder;
    }

    public void setHardshipBuilder(Builder hardshipBuilder) {
        this.hardshipBuilder = hardshipBuilder;
    }

    public Builder getIncomeVerificationStatusBuilder() {
        return this.incomeVerificationStatusBuilder;
    }

    public void setIncomeVerificationStatusBuilder(Builder incomeVerificationStatusBuilder) {
        this.incomeVerificationStatusBuilder = incomeVerificationStatusBuilder;
    }

    public Builder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public void setSourceBuilder(Builder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
    }

    public Builder getStatusBuilder() {
        return this.statusBuilder;
    }

    public void setStatusBuilder(Builder statusBuilder) {
        this.statusBuilder = statusBuilder;
    }

    public Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public Builder getMtStatusBuilder() {
        return this.mtStatusBuilder;
    }

    public void setMtStatusBuilder(Builder mtStatusBuilder) {
        this.mtStatusBuilder = mtStatusBuilder;
    }

    public IncomeTest build(IncomeTestMetaData metaData) throws BuilderException {
        if (metaData.isContainsDeleteRequest()) {
            return null;
        }
        IncomeTest input = metaData.getEntity();
        if (input == null && metaData.getStatuses() == null) {
            return null;
        }
        IncomeTest output = input == null ? new IncomeTest() : input;
        this.transfer(output, metaData);
        return output;
    }

    private Address buildAddress(Address input, AddressMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Address)this.addressBuilder.build((Object)metaData);
    }

    private Hardship buildHardship(Hardship input, HardshipMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Hardship)((Object)this.hardshipBuilder.build((Object)metaData));
    }

    private MeansTestStatus buildIncomeVerificationStatus(MeansTestStatus input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (MeansTestStatus)super.build(this.incomeVerificationStatusBuilder, (AbstractLookup)input, code);
    }

    private IncomeTestSource buildSource(IncomeTestSource input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (IncomeTestSource)super.build(this.sourceBuilder, (AbstractLookup)input, code);
    }

    private IncomeTestStatus buildStatus(IncomeTestStatus input, IncomeTestStatusMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (IncomeTestStatus)((Object)this.statusBuilder.build((Object)metaData));
    }

    private void buildStatuses(IncomeTest input, IncomeTestStatusMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processStatus(toAdd, metaData[index]);
        }
        input.removeAllStatuses();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addStatus((IncomeTestStatus)((Object)i.next()));
        }
    }

    private IncomeTestType buildType(IncomeTestType input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (IncomeTestType)super.build(this.typeBuilder, (AbstractLookup)input, code);
    }

    private MeansTestStatus buildMeansTestStatus(MeansTestStatus input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (MeansTestStatus)super.build(this.mtStatusBuilder, (AbstractLookup)input, code);
    }

    private WkfCaseStatusType buildWorkflowCaseStatus(WkfCaseStatusType input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (WkfCaseStatusType)super.build(this.wfCaseStatusBuilder, (AbstractLookup)input, code);
    }

    private void processStatus(Set toAdd, IncomeTestStatusMetaData metaData) throws BuilderException {
        IncomeTestStatus value = this.buildStatus(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private void transfer(IncomeTest input, IncomeTestMetaData metaData) throws BuilderException {
        IncomeTestStatus mtStatus;
        input.setAdjudicationDate(super.build(input.getAdjudicationDate(), metaData.getAdjudicationDate()));
        input.setAgreesToPayDeductible(super.build(input.getAgreesToPayDeductible(), metaData.getAgreesToPayDeductible()));
        input.setComments(super.build(input.getComments(), metaData.getComments()));
        input.setDateMTNoLongerRequired(super.build(input.getDateMTNoLongerRequired(), metaData.getDateMTNoLongerRequired()));
        input.setDeductibleExpenses(super.build(input.getDeductibleExpenses(), metaData.getDeductibleExpenses()));
        input.setDiscloseFinancialInformation(super.build(input.getDiscloseFinancialInformation(), metaData.getDiscloseFinancialInformation()));
        input.setEffectiveDate(super.build(input.getEffectiveDate(), metaData.getEffectiveDate()));
        input.setGmtAddress(this.buildAddress(input.getGmtAddress(), metaData.getGMTAddress()));
        input.setGmtThresholdAmount(super.build(input.getGmtThresholdAmount(), metaData.getGMTThresholdAmount()));
        input.setHardship(this.buildHardship(input.getHardship(), metaData.getHardship()));
        input.setIncomeVerificationStatus(this.buildIncomeVerificationStatus(input.getIncomeVerificationStatus(), metaData.getIncomeVerificationStatus()));
        input.setIncomeVerificationStatusDate(super.build(input.getIncomeVerificationStatusDate(), metaData.getIncomeVerificationStatusDate()));
        input.setIncomeYear(super.buildYear(input.getIncomeYear(), metaData.getIncomeYear()));
        input.setIVMTestCompletionDate(super.build(input.getIVMTestCompletionDate(), metaData.getIVMTestCompletionDate()));
        input.setNetWorth(super.build(input.getNetWorth(), metaData.getNetWorth()));
        input.setPreviousYearThresholdApplies(super.build(input.getPreviousYearThresholdApplies(), metaData.getPreviousYearThresholdApplies()));
        input.setPrimaryIncomeTest(super.build(input.isPrimaryIncomeTest(), metaData.getPrimaryIncomeTest()));
        input.setReasonMTNoLongerRequired(super.build(input.getReasonMTNoLongerRequired(), metaData.getReasonMTNoLongerRequired()));
        input.setRefusedToSign(super.build(input.getRefusedToSign(), metaData.getRefusedToSign()));
        input.setSiteConductingTest(super.build(input.getSiteConductingTest(), metaData.getSiteConductingTest()));
        input.setSource(this.buildSource(input.getSource(), metaData.getSource()));
        input.setThresholdA(super.build(input.getThresholdA(), metaData.getThresholdA()));
        input.setTotalIncome(super.build(input.getTotalIncome(), metaData.getTotalIncome()));
        input.setTotalNumberOfDependents(super.build(input.getTotalNumberOfDependents(), metaData.getTotalNumberOfDependents()));
        input.setType(this.buildType(input.getType(), metaData.getType()));
        input.setIvmConversionDate(super.build(input.getIvmConversionDate(), metaData.getIVMConversionDate()));
        input.setPg8RelaxationIndicator(super.build(input.getPg8RelaxationIndicator(), metaData.getPg8RelaxationIndicator()));
        input.setWorkflowCaseStatus(this.buildWorkflowCaseStatus(input.getWorkflowCaseStatus(), metaData.getIvmCaseStatus()));
        input.setBtFinancialInd(super.build(input.getBtFinancialInd(), metaData.getBtFinancialInd()));
        this.buildStatuses(input, metaData.getStatuses());
        if (input.getType() != null && IncomeTestType.CODE_MEANS_TEST.getCode().equals(input.getType().getCode()) && (mtStatus = input.getIncomeTestStatus()) != null && input.getPharmacyCoPayStatus() == null && StringUtils.isNotEmpty((String)metaData.getRxCopayExemptionStatus())) {
            IncomeTestStatus rxCopyStatus = new IncomeTestStatus();
            rxCopyStatus.setCompletedDate(mtStatus.getCompletedDate());
            rxCopyStatus.setLastEditedDate(mtStatus.getLastEditedDate());
            rxCopyStatus.setStatus(this.buildMeansTestStatus(rxCopyStatus.getStatus(), metaData.getRxCopayExemptionStatus()));
            rxCopyStatus.setType(this.buildType(rxCopyStatus.getType(), IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()));
            rxCopyStatus.setDeterminedStatus(rxCopyStatus.getStatus());
            input.addStatus(rxCopyStatus);
        }
    }

    public Builder getwfCaseStatusBuilder() {
        return this.wfCaseStatusBuilder;
    }

    public void setwfCaseStatusBuilder(Builder workflowCaseStatusBuuilder) {
        this.wfCaseStatusBuilder = workflowCaseStatusBuuilder;
    }
}

