/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class AddressBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 713793576044907489L;
    private static final String CODE_BAD_ADDRESS_UNDELIVERABLE = "VAB1";
    private static final String CODE_BAD_ADDRESS_HOMELESS = "VAB2";
    private static final String CODE_BAD_ADDRESS_OTHER = "VAB3";
    private static final String CODE_BAD_ADDRESS_NOT_FOUND = "VAB4";
    private static final String STATE_AE = "AE";
    private Builder badAddressReasonBuilder;
    private Builder changeSourceBuilder;
    private Builder typeBuilder;
    private LookupService lookupService;

    public Builder getBadAddressReasonBuilder() {
        return this.badAddressReasonBuilder;
    }

    public void setBadAddressReasonBuilder(Builder badAddressReasonBuilder) {
        this.badAddressReasonBuilder = badAddressReasonBuilder;
    }

    public Builder getChangeSourceBuilder() {
        return this.changeSourceBuilder;
    }

    public void setChangeSourceBuilder(Builder changeSourceBuilder) {
        this.changeSourceBuilder = changeSourceBuilder;
    }

    public Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public Address build(AddressMetaData metaData) throws BuilderException {
        Address input = metaData.getEntity();
        Address output = input == null ? new Address() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private AddressChangeSource buildChangeSource(AddressChangeSource input, String code) throws BuilderException {
        return (AddressChangeSource)super.build(this.changeSourceBuilder, (AbstractLookup)input, code);
    }

    private void buildStateOrProvince(Address input, String state, String county, String province) throws BuilderException {
        if (province == null) {
            try {
                input.setState(this.getStateByStateCode(state));
            }
            catch (ServiceException e) {
                throw new BuilderException("Invalid State Code: " + state, (Throwable)e);
            }
            input.setProvince(null);
        } else {
            input.setState(null);
            input.setProvince(super.build(input.getProvince(), province));
        }
        if (input.getState() != null && !input.getState().equals(STATE_AE)) {
            try {
                input.setCounty(this.getCountyByCountyCodeAndStateCode(county, input.getState()));
            }
            catch (ServiceException e) {
                throw new BuilderException("Invalid County/State Code combination: county[" + county + "] and state[" + input.getState() + "]", (Throwable)e);
            }
        }
    }

    private String getStateByStateCode(String stateCode) throws ServiceException {
        return StringUtils.isBlank((String)stateCode) ? null : this.lookupService.getStateByCode(stateCode).getCode();
    }

    private String getCountyByCountyCodeAndStateCode(String countyCode, String stateCode) throws ServiceException {
        return StringUtils.isBlank((String)countyCode) ? null : this.lookupService.getCountyByCode(countyCode + stateCode).getName();
    }

    private AddressType buildType(AddressType input, String code) throws BuilderException {
        return (AddressType)super.build(this.typeBuilder, (AbstractLookup)input, code);
    }

    private void buildZipOrPostalCode(Address input, String zipCode, String zipPlus4, String postalCode) throws BuilderException {
        if (postalCode == null) {
            try {
                input.setZipCode(super.build(input.getZipCode(), zipCode));
                input.setZipPlus4(super.build(input.getZipPlus4(), zipPlus4));
                input.setPostalCode(null);
            }
            catch (BuilderException e) {
                input.setZipCode(null);
                input.setZipPlus4(null);
                input.setPostalCode(super.build(input.getPostalCode(), zipCode + (zipPlus4 == null ? "" : zipPlus4)));
            }
        } else {
            input.setZipCode(null);
            input.setZipPlus4(null);
            input.setPostalCode(super.build(input.getPostalCode(), postalCode));
        }
    }

    private boolean shouldKeep(Address obj) {
        return true;
    }

    private void transfer(Address input, AddressMetaData metaData) throws BuilderException {
        input.setEndDate(super.build(input.getEndDate(), metaData.getEndDate()));
        input.setStartDate(super.build(input.getStartDate(), metaData.getStartDate()));
        input.setChangeDate(super.build(input.getChangeDate(), metaData.getChangeDate()));
        input.setChangeSite(super.build(input.getChangeSite(), metaData.getChangeSite()));
        String changeSource = metaData.getChangeSource();
        if (changeSource == null) {
            changeSource = AddressChangeSource.CODE_VAMC.getCode();
        }
        input.setChangeSource(this.buildChangeSource(input.getChangeSource(), changeSource));
        input.setCity(super.build(input.getCity(), metaData.getCity()));
        input.setCountry(super.build(input.getCountry(), metaData.getCountry()));
        input.setLine1(super.build(input.getLine1(), metaData.getLine1()));
        input.setLine2(super.build(input.getLine2(), metaData.getLine2()));
        input.setLine3(super.build(input.getLine3(), metaData.getLine3()));
        input.setType(this.buildType(input.getType(), metaData.getType()));
        input.setBadAddressReason(this.buildBadaddressreason(input.getBadAddressReason(), metaData.getType()));
        input.setPhoneNumber(super.build(input.getPhoneNumber(), metaData.getTemporaryAddressPhoneNumber()));
        this.buildStateOrProvince(input, metaData.getState(), metaData.getCounty(), metaData.getProvince());
        this.buildZipOrPostalCode(input, metaData.getZipCode(), metaData.getZipPlus4(), metaData.getPostalCode());
        Boolean isAddressActive = super.build(new Boolean(input.isActive()), metaData.getStatus());
        if (isAddressActive != null) {
            input.setActive(isAddressActive);
        }
    }

    private BadAddressReason buildBadaddressreason(BadAddressReason input, String code) throws BuilderException {
        BadAddressReason badAddressReason = null;
        if (code != null && (code.equals(CODE_BAD_ADDRESS_UNDELIVERABLE) || code.equals(CODE_BAD_ADDRESS_HOMELESS) || code.equals(CODE_BAD_ADDRESS_OTHER) || code.equals(CODE_BAD_ADDRESS_NOT_FOUND))) {
            badAddressReason = (BadAddressReason)super.build(this.badAddressReasonBuilder, (AbstractLookup)input, code);
        }
        return badAddressReason;
    }
}

