/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.model.ivmdm.IVMClearLoadErrorStatistics;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.fw.batchprocess.AbstractDataFileProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.List;
import org.apache.commons.lang.Validate;

public class IVMDataSynchronizationClearLoadErrorConsumerProcess
extends AbstractDataFileProcess {
    private IVMDMService ivmDMService;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.ivmDMService, (String)"IVMDMService is required.");
    }

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        IVMClearLoadErrorStatistics loadErrorStats = null;
        for (RawFileDataList fileRow : acquiredData) {
            if (fileRow.size() >= 2) {
                String icn = (String)fileRow.get(0);
                String incomeYear = (String)fileRow.get(1);
                if (StringUtils.isNotEmpty((String)icn) && StringUtils.isNotEmpty((String)incomeYear)) {
                    try {
                        if (loadErrorStats == null) {
                            loadErrorStats = new IVMClearLoadErrorStatistics();
                        }
                        this.ivmDMService.updateClearLoadError(icn, incomeYear, loadErrorStats);
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                        continue;
                    }
                    catch (Exception ex) {
                        context.getExceptionData().add(ex);
                        context.getProcessStatistics().incrementNumberOfErrorRecords();
                    }
                }
            }
            context.getProcessStatistics().incrementNumberOfErrorRecords();
        }
        try {
            if (loadErrorStats != null) {
                this.ivmDMService.saveClearLoadErrorStatistics(loadErrorStats);
            }
        }
        catch (ServiceException ex) {
            throw new IllegalStateException("Error saving the clear load error statistics. Reason: " + ex.getMessage());
        }
    }

    public IVMDMService getIvmDMService() {
        return this.ivmDMService;
    }

    public void setIvmDMService(IVMDMService ivmDMService) {
        this.ivmDMService = ivmDMService;
    }
}

