/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HECLegacyEnrollmentFileData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = 7845102091600278808L;
    private ImpreciseDate effectiveDateOfChange;
    private EnrollmentSource enrollmentSource;
    private EnrollmentStatus enrollmentStatus;
    private EGTSetting egtSetting = new EGTSetting();
    private String enrollmentStatusOverride;
    private CancelDeclineReason cancelDeclineReason;
    private EnrollmentPriorityGroup enrollmentPriorityGroup;
    private EnrollmentPrioritySubGroup enrollmentPrioritySubgroup;
    private ImpreciseDate applicationDate;
    private String cancelDeclineRemarks;
    private VAFacility preferredFacility;
    private ImpreciseDate enrollmentDate;
    private ImpreciseDate enrollmentEndDate;
    private EnrollmentCategory enrollmentCategory;

    protected void buildToString(ToStringBuilder builder) {
    }

    public ImpreciseDate getEffectiveDateOfChange() {
        return this.effectiveDateOfChange;
    }

    public void setEffectiveDateOfChange(ImpreciseDate effectiveDateOfChange) {
        this.effectiveDateOfChange = effectiveDateOfChange;
    }

    public ImpreciseDate getEnrollmentDate() {
        return this.enrollmentDate;
    }

    public void setEnrollmentDate(ImpreciseDate enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
    }

    public ImpreciseDate getEnrollmentEndDate() {
        return this.enrollmentEndDate;
    }

    public void setEnrollmentEndDate(ImpreciseDate enrollmentEndDate) {
        this.enrollmentEndDate = enrollmentEndDate;
    }

    public EnrollmentPriorityGroup getEnrollmentPriorityGroup() {
        return this.enrollmentPriorityGroup;
    }

    public void setEnrollmentPriorityGroup(EnrollmentPriorityGroup enrollmentPriorityGroup) {
        this.enrollmentPriorityGroup = enrollmentPriorityGroup;
    }

    public EnrollmentSource getEnrollmentSource() {
        return this.enrollmentSource;
    }

    public void setEnrollmentSource(EnrollmentSource enrollmentSource) {
        this.enrollmentSource = enrollmentSource;
    }

    public EnrollmentStatus getEnrollmentStatus() {
        return this.enrollmentStatus;
    }

    public void setEnrollmentStatus(EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public String getEnrollmentStatusOverride() {
        return this.enrollmentStatusOverride;
    }

    public void setEnrollmentStatusOverride(String enrollmentStatusOverride) {
        this.enrollmentStatusOverride = enrollmentStatusOverride;
    }

    public VAFacility getPreferredFacility() {
        return this.preferredFacility;
    }

    public void setPreferredFacility(VAFacility preferredFacility) {
        this.preferredFacility = preferredFacility;
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        int i = 1;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"effectiveDateOfChange", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentSource", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentStatus", (String)parsedRow.getString(i++));
        this.parseEGTSettings(parsedRow.getString(i++));
        this.enrollmentStatusOverride = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"cancelDeclineReason", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentPriorityGroup", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentPrioritySubgroup", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"applicationDate", (String)parsedRow.getString(i++));
        this.cancelDeclineRemarks = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"preferredFacility", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentDate", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentEndDate;", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"enrollmentCategory;", (String)parsedRow.getString(i++));
    }

    private void parseEGTSettings(String egtSettingsString) throws Exception {
        if (StringUtils.isBlank((String)egtSettingsString)) {
            return;
        }
        String[] tokens = egtSettingsString.split("\\|");
        if (tokens != null && tokens.length == 3) {
            this.egtSetting.setPriorityGroup((EnrollmentPriorityGroup)RawFileDataContainerUtils.convertToLookup(EnrollmentPriorityGroup.class, (String)tokens[0]));
            this.egtSetting.setPrioritySubGroup((EnrollmentPrioritySubGroup)RawFileDataContainerUtils.convertToLookup(EnrollmentPrioritySubGroup.class, (String)tokens[1]));
            RawFileDataContainerUtils.setConvertedField((Object)((Object)this.egtSetting), (String)"effectiveDate", (String)tokens[2]);
        }
    }

    public CancelDeclineReason getCancelDeclineReason() {
        return this.cancelDeclineReason;
    }

    public void setCancelDeclineReason(CancelDeclineReason cancelDeclineReason) {
        this.cancelDeclineReason = cancelDeclineReason;
    }

    public String getCancelDeclineRemarks() {
        return this.cancelDeclineRemarks;
    }

    public void setCancelDeclineRemarks(String cancelDeclineRemarks) {
        this.cancelDeclineRemarks = cancelDeclineRemarks;
    }

    public EnrollmentPrioritySubGroup getEnrollmentPrioritySubgroup() {
        return this.enrollmentPrioritySubgroup;
    }

    public void setEnrollmentPrioritySubgroup(EnrollmentPrioritySubGroup enrollmentPrioritySubgroup) {
        this.enrollmentPrioritySubgroup = enrollmentPrioritySubgroup;
    }

    public ImpreciseDate getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(ImpreciseDate applicationDate) {
        this.applicationDate = applicationDate;
    }

    public EGTSetting getEgtSetting() {
        return this.egtSetting;
    }

    public void setEgtSetting(EGTSetting egtSetting) {
        this.egtSetting = egtSetting;
    }

    public OrderedMap getRawFileData() throws Exception {
        ListOrderedMap map = new ListOrderedMap();
        map.put((Object)"header", (Object)"ENR");
        map.put((Object)"effectiveDateOfChange", (Object)this.effectiveDateOfChange);
        map.put((Object)"enrollmentSource", (Object)this.enrollmentSource);
        map.put((Object)"enrollmentStatus", (Object)this.enrollmentStatus);
        map.put((Object)"EGTSetting", (Object)this.egtSetting);
        map.put((Object)"enrollmentStatusOverride", (Object)this.enrollmentStatusOverride);
        map.put((Object)"cancelDeclineReason", (Object)this.cancelDeclineReason);
        map.put((Object)"enrollmentPriorityGroup", (Object)this.enrollmentPriorityGroup);
        map.put((Object)"enrollmentPrioritySubgroup", (Object)this.enrollmentPrioritySubgroup);
        map.put((Object)"applicationDate", (Object)this.applicationDate);
        map.put((Object)"cancelDeclineRemarks", (Object)this.cancelDeclineRemarks);
        map.put((Object)"preferredFacility", (Object)this.preferredFacility);
        map.put((Object)"enrollmentDate", (Object)this.enrollmentDate);
        map.put((Object)"enrollmentEndDate", (Object)this.enrollmentEndDate);
        map.put((Object)"enrollmentCategory", (Object)this.enrollmentCategory);
        return map;
    }

    public EnrollmentCategory getEnrollmentCategory() {
        return this.enrollmentCategory;
    }

    public void setEnrollmentCategory(EnrollmentCategory enrollmentCategory) {
        this.enrollmentCategory = enrollmentCategory;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

