/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HECLegacyDemographicsFileData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = 7026457752741239290L;
    private String claimFolderNumber;
    private VAFacility claimFolderLocation;
    private ImpreciseDate dateOfDeath;
    private VAFacility siteReportingDeath;
    private DeathDataSource sourceOfDeathNotification;
    private ImpreciseDate dateOfDeathLastUpdated;
    private Address address = new Address();
    private String addressChangedBy;
    private String residencePhone;
    private String workPhone;
    private String masterId;
    private String pseudoSSN;
    private ImpreciseDate SSNValidationDate;
    private SSAVerificationStatus SSNVerificationStatus;
    private String sensitivityLevel;

    protected void buildToString(ToStringBuilder builder) {
        builder.append("address", (Object)this.address);
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getAddressChangedBy() {
        return this.addressChangedBy;
    }

    public void setAddressChangedBy(String addressChangedBy) {
        this.addressChangedBy = addressChangedBy;
    }

    public String getClaimFolderNumber() {
        return this.claimFolderNumber;
    }

    public void setClaimFolderNumber(String claimFolderNumber) {
        this.claimFolderNumber = claimFolderNumber;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }

    public String getPseudoSSN() {
        return this.pseudoSSN;
    }

    public void setPseudoSSN(String pseudoSSN) {
        this.pseudoSSN = pseudoSSN;
    }

    public String getResidencePhone() {
        return this.residencePhone;
    }

    public void setResidencePhone(String residencePhone) {
        this.residencePhone = residencePhone;
    }

    public String getSensitivityLevel() {
        return this.sensitivityLevel;
    }

    public void setSensitivityLevel(String sensitivityLevel) {
        this.sensitivityLevel = sensitivityLevel;
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workPhone) {
        this.workPhone = workPhone;
    }

    public ImpreciseDate getDateOfDeath() {
        return this.dateOfDeath;
    }

    public void setDateOfDeath(ImpreciseDate dateOfDeath) {
        this.dateOfDeath = dateOfDeath;
    }

    public ImpreciseDate getDateOfDeathLastUpdated() {
        return this.dateOfDeathLastUpdated;
    }

    public void setDateOfDeathLastUpdated(ImpreciseDate dateOfDeathLastUpdated) {
        this.dateOfDeathLastUpdated = dateOfDeathLastUpdated;
    }

    public VAFacility getSiteReportingDeath() {
        return this.siteReportingDeath;
    }

    public void setSiteReportingDeath(VAFacility siteReportingDeath) {
        this.siteReportingDeath = siteReportingDeath;
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        int i = 1;
        this.claimFolderNumber = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"claimFolderLocation", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"dateOfDeath", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"siteReportingDeath", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"sourceOfDeathNotification", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"dateOfDeathLastUpdated", (String)parsedRow.getString(i++));
        this.address.setLine1(parsedRow.getString(i++));
        this.address.setLine2(parsedRow.getString(i++));
        this.address.setCity(parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)this.address, (String)"state", (String)parsedRow.getString(i++));
        this.address.setZipCode(parsedRow.getString(i++));
        this.address.setZipPlus4(parsedRow.getString(i++));
        this.address.setCounty(parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)this.address, (String)"changeDate", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)this.address, (String)"changeSource", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)this.address, (String)"changeSite", (String)parsedRow.getString(i++));
        this.addressChangedBy = parsedRow.getString(i++);
        this.residencePhone = parsedRow.getString(i++);
        this.workPhone = parsedRow.getString(i++);
        this.masterId = parsedRow.getString(i++);
        this.pseudoSSN = parsedRow.getString(i++);
        parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"SSNValidationDate", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"SSNVerificationStatus", (String)parsedRow.getString(i++));
        this.sensitivityLevel = parsedRow.getString(i++);
    }

    public ImpreciseDate getSSNValidationDate() {
        return this.SSNValidationDate;
    }

    public void setSSNValidationDate(ImpreciseDate validationDate) {
        this.SSNValidationDate = validationDate;
    }

    public DeathDataSource getSourceOfDeathNotification() {
        return this.sourceOfDeathNotification;
    }

    public void setSourceOfDeathNotification(DeathDataSource sourceOfDeathNotification) {
        this.sourceOfDeathNotification = sourceOfDeathNotification;
    }

    public VAFacility getClaimFolderLocation() {
        return this.claimFolderLocation;
    }

    public void setClaimFolderLocation(VAFacility claimFolderLocation) {
        this.claimFolderLocation = claimFolderLocation;
    }

    public OrderedMap getRawFileData() throws Exception {
        ListOrderedMap map = new ListOrderedMap();
        map.put((Object)"header", (Object)"DEM");
        map.put((Object)"claimFolderNumber", (Object)this.claimFolderNumber);
        map.put((Object)"claimFolderLocation", (Object)this.claimFolderLocation);
        map.put((Object)"dateOfDeath", (Object)this.dateOfDeath);
        map.put((Object)"siteReportingDeath", (Object)this.siteReportingDeath);
        map.put((Object)"sourceOfDeathNotification", (Object)this.sourceOfDeathNotification);
        map.put((Object)"dateOfDeathLastUpdated", (Object)this.dateOfDeathLastUpdated);
        map.put((Object)"addressLine1", (Object)this.address.getLine1());
        if (StringUtils.isNotBlank((String)this.address.getLine2()) || StringUtils.isNotBlank((String)this.address.getLine3())) {
            String line2 = this.address.getLine2();
            String line3 = this.address.getLine3();
            map.put((Object)"addressLine2", (Object)((StringUtils.isNotBlank((String)line2) ? line2 : "") + " " + (StringUtils.isNotBlank((String)line3) ? line3 : "")));
        } else {
            map.put((Object)"addressLine2", (Object)"");
        }
        map.put((Object)"city", (Object)this.address.getCity());
        map.put((Object)"state", (Object)this.address.getState());
        map.put((Object)"zipCode", (Object)this.address.getZipCode());
        map.put((Object)"zipPlus4", (Object)this.address.getZipPlus4());
        map.put((Object)"county", (Object)this.address);
        map.put((Object)"addressChangeDate", (Object)this.address.getChangeDate());
        map.put((Object)"addressChangeSource", (Object)this.address.getChangeSource());
        map.put((Object)"addressChangeSite", (Object)this.address.getChangeSite());
        map.put((Object)"addressChangedBy", (Object)(this.address.getModifiedBy() != null ? this.address.getModifiedBy().getName() : ""));
        map.put((Object)"residencePhone", (Object)this.residencePhone);
        map.put((Object)"workPhone", (Object)this.workPhone);
        map.put((Object)"masterId", (Object)this.masterId);
        map.put((Object)"pseudoSSN", (Object)this.pseudoSSN);
        map.put((Object)"pseudoSSNReason", (Object)"");
        map.put((Object)"SSNValidationDate", (Object)this.SSNValidationDate);
        map.put((Object)"SSNVerificationStatus", (Object)this.SSNVerificationStatus);
        map.put((Object)"sensitivityLevel", (Object)this.sensitivityLevel);
        return map;
    }

    public SSAVerificationStatus getSSNVerificationStatus() {
        return this.SSNVerificationStatus;
    }

    public void setSSNVerificationStatus(SSAVerificationStatus verificationStatus) {
        this.SSNVerificationStatus = verificationStatus;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

