/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.AbstractDataSynchronizationProducerProcess;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyCombatFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyCommunicationsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDemographicsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDependentFinancialFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyEligibilityFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyEnrollmentFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyFinancialAmountsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyFinancialFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyIdentityFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyPOWFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyPurpleHeartFileData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Financial;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.TargetDateQueryProcessStatistics;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class HECLegacyDataSynchronizationProducerProcess
extends AbstractDataSynchronizationProducerProcess {
    public static String TRUE = "1";
    public static String FALSE = "0";
    private CommsLogService commsLogService;
    private RegistryService registryService;
    private LookupService lookupService;

    protected ProcessStatistics createProcessStatistics() {
        return new TargetDateQueryProcessStatistics();
    }

    protected void prepareDataQueryDetail(DataQueryProcessExecutionContext context, DataQueryDetail query) {
        TargetDateQueryProcessStatistics stats = (TargetDateQueryProcessStatistics)context.getProcessStatistics();
        Date targetDate = stats.getTargetDate();
        if (targetDate == null) {
            Object arg;
            targetDate = context.getExecutionArguments() != null ? ((arg = context.getExecutionArguments()) instanceof Date ? (Date)arg : new ImpreciseDate((String)arg).getDate()) : DateUtils.getYesterdayDate();
            stats.setTargetDate(targetDate);
        }
        Object[] paramValues = query.getQuery().getParamValues();
        paramValues[0] = targetDate;
        query.getQuery().setParamValues(paramValues);
        if (query.getQuery().getQuery().indexOf("registryQuery.POW") > -1) {
            context.getContextData().put("queryRegistryMode", "POW");
        } else if (query.getQuery().getQuery().indexOf("registryQuery.purpleHeart") > -1) {
            context.getContextData().put("queryRegistryMode", "PH");
        }
    }

    @Override
    protected Object getProcessedObject(DataQueryProcessExecutionContext context, Object acquiredObject) throws ServiceException {
        Object processedObject = null;
        if (acquiredObject instanceof PersonChangeLogEntry) {
            processedObject = super.getProcessedObject(context, acquiredObject);
        } else {
            String registryId = (String)acquiredObject;
            RegistryType type = context.getContextData().containsValue("PH") ? this.lookupService.getRegistryTypeByCode(RegistryType.CODE_PH_REGISTRY.getCode()) : this.lookupService.getRegistryTypeByCode(RegistryType.CODE_POW_REGISTRY.getCode());
            EntityKey key = CommonEntityKeyFactory.createRegistryEntityKey(registryId, type);
            processedObject = this.registryService.getRegistryById(key, type);
        }
        return processedObject;
    }

    @Override
    protected boolean shouldProcessAcquiredObject(DataQueryProcessExecutionContext context, Object acquiredObject) {
        boolean shouldProcessAcquiredObject = true;
        if (acquiredObject instanceof PersonChangeLogEntry) {
            shouldProcessAcquiredObject = super.shouldProcessAcquiredObject(context, acquiredObject);
        }
        return shouldProcessAcquiredObject;
    }

    @Override
    protected Object transformObject(DataQueryProcessExecutionContext context, Object processedObject, Object acquiredObject) throws ServiceException {
        ArrayList fileData = new ArrayList();
        if (processedObject instanceof Person) {
            Person person = (Person)((Object)processedObject);
            this.add(fileData, (Object)this.extractIdentityData(person));
            this.add(fileData, this.extractCommunicationsData(person));
            this.add(fileData, (Object)this.extractDemographicsData(person));
            this.add(fileData, (Object)this.extractEligibilityData(person));
            this.add(fileData, this.extractCombatData(person));
            this.add(fileData, (Object)this.extractEnrollmentData(person));
            this.add(fileData, this.extractFinancialData(person));
            this.add(fileData, (Object)this.extractPOWData(person));
            this.add(fileData, (Object)this.extractPurpleHeartData(person));
        } else {
            Registry reg = (Registry)((Object)processedObject);
            if (reg.getRegistryTrait() == null) {
                throw new IllegalStateException("Unable to transform Registry object since it lacks RegistryTrait's and a RegistryType");
            }
            if (RegistryType.CODE_PH_REGISTRY.getCode().equals(reg.getRegistryTrait().getRegistryType().getCode())) {
                this.add(fileData, (Object)this.extractIdentityData(reg));
                this.add(fileData, (Object)this.extractPurpleHeartData((PurpleHeart)reg, null));
            } else if (RegistryType.CODE_POW_REGISTRY.getCode().equals(reg.getRegistryTrait().getRegistryType().getCode())) {
                this.add(fileData, (Object)this.extractIdentityData(reg));
                this.add(fileData, (Object)this.extractPOWData((PrisonerOfWar)reg, null));
            }
        }
        return fileData;
    }

    private void add(List list, Object data) {
        if (data != null) {
            if (data instanceof Collection) {
                list.addAll((Collection)data);
            } else {
                list.add(data);
            }
        }
    }

    private List extractCommunicationsData(Person person) throws ServiceException {
        ArrayList<HECLegacyCommunicationsFileData> data = new ArrayList<HECLegacyCommunicationsFileData>();
        List commsLogEntries = this.commsLogService.findLogEntriesByPersonId(person.getPersonEntityKey().getKeyValueAsString());
        Iterator<Object> itr = commsLogEntries != null ? commsLogEntries.iterator() : null;
        CommsLogEntry logEntry = null;
        HECLegacyCommunicationsFileData item = null;
        HashMap<String, CommsLogEntry> uniqueCommsLogEntries = new HashMap<String, CommsLogEntry>();
        CommsLogEntry best = null;
        while (itr != null && itr.hasNext()) {
            logEntry = (CommsLogEntry)((Object)itr.next());
            if (logEntry.getFormNumber() == null) continue;
            best = (CommsLogEntry)((Object)uniqueCommsLogEntries.get(logEntry.getFormNumber()));
            if (best != null) {
                MailingStatusLink bestStatus = best.getLatestMailingStatus();
                Date bestDateForComparison = bestStatus != null ? bestStatus.getModifiedOn() : best.getModifiedOn();
                MailingStatusLink targetStatus = logEntry.getLatestMailingStatus();
                Date targetDateForComparison = targetStatus != null ? targetStatus.getModifiedOn() : logEntry.getModifiedOn();
                if (!targetDateForComparison.after(bestDateForComparison)) continue;
                uniqueCommsLogEntries.put(logEntry.getFormNumber(), logEntry);
                continue;
            }
            uniqueCommsLogEntries.put(logEntry.getFormNumber(), logEntry);
        }
        itr = uniqueCommsLogEntries.values().iterator();
        while (itr != null && itr.hasNext()) {
            logEntry = (CommsLogEntry)((Object)itr.next());
            item = new HECLegacyCommunicationsFileData();
            item.setActionMessage(logEntry.getLatestActionComment());
            item.setLetterForm(logEntry.getFormNumber());
            item.setRemail(logEntry.getRemailIndicator());
            item.setFileName(logEntry.getAacExtractNumber());
            MailingStatusLink status = logEntry.getLatestMailingStatus();
            if (status != null) {
                item.setStatus(status.getMailingStatus().getCode());
            }
            data.add(item);
        }
        return data;
    }

    private List extractFinancialData(Person person) {
        Set set;
        IncompetenceRuling ir;
        IncomeTest test;
        ArrayList<HECLegacyFinancialFileData> data = new ArrayList<HECLegacyFinancialFileData>();
        Map stmts = person.getFinancialStatements();
        Integer incomeYear = person.getLatestIncomeYear();
        HECLegacyFinancialFileData item = new HECLegacyFinancialFileData();
        data.add(item);
        if (stmts != null && !stmts.isEmpty()) {
            FinancialStatement fs = (FinancialStatement)((Object)stmts.get(incomeYear));
            item.setIncomeYear(incomeYear);
            item.setFinancialAmounts(this.extractFinancialInformation(item, fs));
            item.setAmountContributedToSpouse(fs.getContributionToSpouse());
            if (this.isTrue(fs.getMarriedLastCalendarYear())) {
                item.setMarriedLastCalendarYear(TRUE);
            } else if (this.isFalse(fs.getMarriedLastCalendarYear())) {
                item.setMarriedLastCalendarYear(FALSE);
            }
            item.setNumberOfDependentChildren(fs.getNumberOfDependentChildren());
            data.addAll(this.extractDependentFinancialData(fs, incomeYear));
        }
        if ((test = person.getIncomeTest(incomeYear)) != null) {
            if (Boolean.TRUE.equals(test.isPrimaryIncomeTest())) {
                item.setSourceOfPrimaryIncomeTest(test.getSource());
            }
            if (IncomeTestType.CODE_MEANS_TEST.getCode().equals(test.getType().getCode())) {
                item.setMeansTestDate(this.getImpreciseDate(test.getEffectiveDate()));
                item.setMeansTestStatus(test.getStatus());
                item.setMeansTestAdjudicationDate(this.getImpreciseDate(test.getAdjudicationDate()));
                item.setMeansTestCompletedDate(this.getImpreciseDate(test.getCompletedDate()));
                item.setMeansTestDeterminedStatus(test.getDeterminedStatus());
            } else if (IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode().equals(test.getType().getCode())) {
                item.setCopayTestDate(this.getImpreciseDate(test.getEffectiveDate()));
                item.setCopayTestStatus(test.getStatus());
                item.setCopayTestAdjudicationDate(this.getImpreciseDate(test.getAdjudicationDate()));
                item.setCopayTestCompletedDate(this.getImpreciseDate(test.getCompletedDate()));
                item.setCopayTestDeterminedStatus(test.getDeterminedStatus());
            }
            item.setTotalIncome(test.getTotalIncome());
            item.setNetWorth(test.getNetWorth());
            if (this.isTrue(test.getAgreesToPayDeductible())) {
                item.setAgreedToPayDeductible(TRUE);
            } else if (this.isFalse(test.getAgreesToPayDeductible())) {
                item.setAgreedToPayDeductible(FALSE);
            }
            item.setThresholdA(test.getThresholdA());
            item.setTotalDependents(test.getTotalNumberOfDependents());
            if (this.isTrue(test.getDiscloseFinancialInformation())) {
                item.setDeclinesToGiveIncomeInfo(TRUE);
            } else if (this.isFalse(test.getDiscloseFinancialInformation())) {
                item.setDeclinesToGiveIncomeInfo(FALSE);
            }
            item.setSiteConductingMeansTest(test.getSiteConductingTest());
            item.setTestLastEditedDate(this.getImpreciseDate(test.getLastEditedDate()));
            item.setGMTThreshold(test.getGmtThresholdAmount());
            Address a = test.getGmtAddress();
            if (a != null && a.isUSAddress()) {
                item.setGMTAddress(a);
            }
        }
        if ((ir = person.getIncompetenceRuling()) != null) {
            item.setIncompetentCivilRulingDate(ir.getCivilRulingDate());
            item.setIncompetentVARulingDate(ir.getCivilRulingDate());
        }
        Iterator itr2 = (set = person.getAssociations()) != null ? set.iterator() : null;
        Association ass = null;
        while (itr2 != null && itr2.hasNext()) {
            ass = (Association)itr2.next();
            if (!AssociationType.CODE_GUARDIAN_VA.getCode().equals(ass.getType().getCode()) && !AssociationType.CODE_GUARDIAN_CIVIL.getCode().equals(ass.getType().getCode())) continue;
            item.setGuardianType(ass.getType());
            Name repName = ass.getRepresentativeName();
            if (repName != null) {
                item.setGuardianName(repName);
            }
            item.setGuardianInstitution(ass.getOrganizationName());
            Address a = ass.getAddress();
            if (a != null && a.isUSAddress()) {
                item.setGuardianAddress(a);
            }
            item.setGuardianPhone(ass.getPrimaryPhone());
            item.setGuardianRelationship(ass.getRelationship());
            break;
        }
        return data;
    }

    private HECLegacyFinancialAmountsFileData extractFinancialInformation(HECLegacyFinancialFileData item, FinancialInformation info) {
        HECLegacyFinancialAmountsFileData data = new HECLegacyFinancialAmountsFileData();
        if (info == null) {
            return data;
        }
        Map items = info.getAssets();
        Iterator itr = items != null ? items.keySet().iterator() : null;
        Lookup type = null;
        while (itr != null && itr.hasNext()) {
            type = (Lookup)itr.next();
            if (AssetType.CODE_CASH.getCode().equals(type.getCode())) {
                data.setCashInBank(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (AssetType.CODE_STOCKS_AND_BONDS.getCode().equals(type.getCode())) {
                data.setStocksAndBonds(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (AssetType.CODE_REAL_ESTATE.getCode().equals(type.getCode())) {
                data.setRealProperty(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (!AssetType.CODE_OTHER.getCode().equals(type.getCode())) continue;
            data.setOtherPropertyAndAssets(((Financial)((Object)items.get(type))).getAmount());
        }
        items = info.getIncome();
        Iterator iterator = itr = items != null ? items.keySet().iterator() : null;
        while (itr != null && itr.hasNext()) {
            type = (Lookup)itr.next();
            if (IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getCode().equals(type.getCode())) {
                data.setSocialSecurityNotSSIAmount(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_CIVIL_SERVICE.getCode().equals(type.getCode())) {
                data.setUSCivilService(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getCode().equals(type.getCode())) {
                data.setUSRailroadRetirement(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getCode().equals(type.getCode())) {
                data.setInterestDividendAnnuity(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getCode().equals(type.getCode())) {
                data.setMilitaryRetirement(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getCode().equals(type.getCode())) {
                data.setOtherRetirement(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getCode().equals(type.getCode())) {
                data.setTotalIncomeFromEmployment(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getCode().equals(type.getCode())) {
                data.setUnemploymentCompensation(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getCode().equals(type.getCode())) {
                data.setWorkersCompBlackLung(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getCode().equals(type.getCode())) {
                data.setAllOtherIncome(((Financial)((Object)items.get(type))).getAmount());
                continue;
            }
            if (!IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getCode().equals(type.getCode()) || item == null) continue;
            item.setRanchFarmOwner(TRUE);
        }
        items = info.getExpenses();
        Iterator iterator2 = itr = items != null ? items.keySet().iterator() : null;
        while (itr != null && itr.hasNext()) {
            type = (Lookup)itr.next();
            if (!ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getCode().equals(type.getCode())) continue;
            data.setEducationExpenses(((Financial)((Object)items.get(type))).getAmount());
        }
        Debt debt = info.getDebt();
        data.setDebts(debt != null ? debt.getAmount() : null);
        return data;
    }

    private List extractDependentFinancialData(FinancialStatement fs, Integer incomeYear) {
        ArrayList<HECLegacyDependentFinancialFileData> data = new ArrayList<HECLegacyDependentFinancialFileData>();
        SSN ssn = null;
        HECLegacyDependentFinancialFileData item = null;
        Set sfs = fs.getSpouseFinancials();
        Iterator itr = sfs != null ? sfs.iterator() : null;
        SpouseFinancials sf = null;
        while (itr != null && itr.hasNext()) {
            sf = (SpouseFinancials)((Object)itr.next());
            item = new HECLegacyDependentFinancialFileData();
            item.setIncomeYear(incomeYear);
            item.setFinancialAmounts(this.extractFinancialInformation(null, sf));
            if (sf.getReportedOn().getName() != null) {
                item.setName(sf.getReportedOn().getName());
            }
            item.setGender(sf.getReportedOn().getGender());
            item.setDateOfBirth(sf.getReportedOn().getDob());
            ssn = this.getTargetSSN(sf.getReportedOn());
            item.setSSN(ssn != null ? ssn.getFormattedSsnText() : null);
            item.setPseudoSSNReason(ssn != null ? ssn.getPseudoSSNReason() : null);
            item.setRelationship(sf.getReportedOn().getRelationship());
            item.setMaidenName(sf.getReportedOn().getMaidenName());
            item.setEffectiveDate(sf.getReportedOn().getStartDate());
            if (this.isTrue(sf.getLivedWithPatient())) {
                item.setLivedWithPatient(TRUE);
            } else if (this.isFalse(sf.getLivedWithPatient())) {
                item.setLivedWithPatient(FALSE);
            }
            data.add(item);
        }
        Set set = fs.getDependentFinancials();
        itr = set != null ? set.iterator() : null;
        DependentFinancials df = null;
        while (itr != null && itr.hasNext()) {
            df = (DependentFinancials)((Object)itr.next());
            item = new HECLegacyDependentFinancialFileData();
            item.setIncomeYear(incomeYear);
            item.setFinancialAmounts(this.extractFinancialInformation(null, df));
            if (df.getReportedOn().getName() != null) {
                item.setName(df.getReportedOn().getName());
            }
            item.setGender(df.getReportedOn().getGender());
            item.setDateOfBirth(df.getReportedOn().getDob());
            ssn = this.getTargetSSN(df.getReportedOn());
            item.setSSN(ssn != null ? ssn.getFormattedSsnText() : null);
            item.setPseudoSSNReason(ssn != null ? ssn.getPseudoSSNReason() : null);
            item.setRelationship(df.getReportedOn().getRelationship());
            item.setEffectiveDate(df.getReportedOn().getStartDate());
            if (this.isTrue(df.getLivedWithPatient())) {
                item.setLivedWithPatient(TRUE);
            } else if (this.isFalse(df.getLivedWithPatient())) {
                item.setLivedWithPatient(FALSE);
            }
            if (this.isTrue(df.getIncapableOfSelfSupport())) {
                item.setIncapableOfSelfSupport(TRUE);
            } else if (this.isFalse(df.getIncapableOfSelfSupport())) {
                item.setIncapableOfSelfSupport(FALSE);
            }
            if (this.isTrue(df.getContributedToSupport())) {
                item.setContributedToSupport(TRUE);
            } else if (this.isFalse(df.getContributedToSupport())) {
                item.setContributedToSupport(FALSE);
            }
            if (this.isTrue(df.getHasIncome())) {
                item.setChildHadIncome(TRUE);
            } else if (this.isFalse(df.getHasIncome())) {
                item.setChildHadIncome(FALSE);
            }
            if (this.isTrue(df.getIncomeAvailableToPatient())) {
                item.setIncomeAvailable(TRUE);
            } else if (this.isFalse(df.getIncomeAvailableToPatient())) {
                item.setIncomeAvailable(FALSE);
            }
            data.add(item);
        }
        return data;
    }

    private HECLegacyIdentityFileData extractIdentityData(Person person) {
        HECLegacyIdentityFileData data = new HECLegacyIdentityFileData();
        data.setICN(person.getVPIDEntityKey().getShortVPID());
        data.setGender(person.getGender());
        data.setDateOfBirth(person.getBirthRecord() != null ? person.getBirthRecord().getBirthDate() : null);
        data.setLegalName(person.getLegalName());
        SSN ssn = this.getTargetSSN(person);
        data.setSSN(ssn != null ? ssn.getFormattedSsnText() : null);
        return data;
    }

    private SSN getTargetSSN(Person person) {
        if (person == null) {
            return null;
        }
        SSN ssn = person.getOfficialSsn();
        if (ssn == null) {
            ssn = person.getPseudoSsn();
        }
        return ssn;
    }

    private SSN getTargetSSN(Relation relation) {
        if (relation == null) {
            return null;
        }
        SSN ssn = relation.getOfficialSsn();
        if (ssn == null) {
            ssn = relation.getPseudoSsn();
        }
        return ssn;
    }

    private HECLegacyIdentityFileData extractIdentityData(Registry reg) {
        HECLegacyIdentityFileData data = new HECLegacyIdentityFileData();
        Name name = new Name();
        name.setFamilyName(reg.getRegistryTrait().getLastName());
        name.setGivenName(reg.getRegistryTrait().getFirstName());
        data.setLegalName(name);
        data.setSSN(reg.getRegistryTrait().getSsn());
        data.setRegistryType(reg.getRegistryTrait().getRegistryType());
        return data;
    }

    private HECLegacyDemographicsFileData extractDemographicsData(Person person) {
        HECLegacyDemographicsFileData data = new HECLegacyDemographicsFileData();
        Address homeAddress = person.getPermanentAddress();
        if (homeAddress != null && homeAddress.isUSAddress()) {
            data.setAddress(homeAddress);
            data.setAddressChangedBy(homeAddress.getModifiedBy().getName());
        }
        data.setClaimFolderNumber(person.getClaimFolderNumber());
        data.setClaimFolderLocation(person.getClaimFolderLocation());
        SSN ssn = this.getTargetSSN(person);
        data.setMasterId(ssn != null ? ssn.getFormattedSsnText() : null);
        data.setSSNValidationDate(ssn != null ? this.getImpreciseDate(ssn.getSsaVerificationDate()) : null);
        SSAVerificationStatus ssaStatus = ssn != null ? ssn.getSsaVerificationStatus() : null;
        data.setSSNVerificationStatus(ssaStatus);
        if (ssn != null && ssn.getPseudoSSNReason() != null) {
            data.setPseudoSSN(TRUE);
        } else {
            data.setPseudoSSN(FALSE);
        }
        Phone phone = person.getHomePhone();
        data.setResidencePhone(phone != null ? phone.getPhoneNumber() : null);
        phone = person.getBusinessPhone();
        data.setWorkPhone(phone != null ? phone.getPhoneNumber() : null);
        if (this.isTrue(person.getSensitiveRecord())) {
            data.setSensitivityLevel(TRUE);
        } else if (this.isFalse(person.getSensitiveRecord())) {
            data.setSensitivityLevel(FALSE);
        }
        if (person.getDeathRecord() != null) {
            data.setDateOfDeath(person.getDeathRecord().getDeathDate());
            data.setDateOfDeathLastUpdated(this.getImpreciseDate(person.getDeathRecord().getDeathReportDate()));
            data.setSiteReportingDeath(person.getDeathRecord().getFacilityReceived());
            data.setSourceOfDeathNotification(person.getDeathRecord().getDataSource());
        }
        return data;
    }

    private List extractCombatData(Person person) {
        ArrayList<HECLegacyCombatFileData> fileData = new ArrayList<HECLegacyCombatFileData>();
        MilitaryService ms = person.getMilitaryService();
        Set combats = ms != null ? ms.getCombatEpisodes() : Collections.EMPTY_SET;
        CombatEpisode combat2 = null;
        for (CombatEpisode combat2 : combats) {
            HECLegacyCombatFileData data = new HECLegacyCombatFileData();
            data.setConflictLocation(combat2.getConflictLocation());
            data.setCombatFromDate(combat2.getStartDate());
            data.setCombatToDate(combat2.getEndDate());
            data.setDataSource(combat2.getOEFOIFSource());
            data.setFacility(combat2.getOEFOIFStationNumber());
            data.setLastUpdated(combat2.getModifiedOn());
            if (combat2.getCombatPayType() != null && CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER.getCode().equals(combat2.getCombatPayType().getCode())) {
                data.setHostileFireImminentDangerIndicator(TRUE);
            } else {
                data.setHostileFireImminentDangerIndicator(FALSE);
            }
            if (combat2.getCombatPayType() != null && CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode().equals(combat2.getCombatPayType().getCode())) {
                data.setCtzeIndicator(TRUE);
            } else {
                data.setCtzeIndicator(FALSE);
            }
            fileData.add(data);
        }
        return fileData;
    }

    private HECLegacyEligibilityFileData extractEligibilityData(Person person) {
        ServiceConnectionAward sc;
        MedicaidFactor mf;
        MonetaryBenefitAward mba;
        PrisonerOfWar pow;
        IncompetenceRuling ir;
        AgentOrangeExposure aoe;
        EligibilityVerification eligVerif;
        HECLegacyEligibilityFileData data = new HECLegacyEligibilityFileData();
        Boolean veteranIndicator = person.getVeteran();
        if (veteranIndicator != null) {
            if (this.isTrue(veteranIndicator)) {
                data.setVeteranIndicator(TRUE);
            } else {
                data.setVeteranIndicator(FALSE);
            }
        }
        if ((eligVerif = person.getEligibilityVerification()) != null) {
            data.setEligibilityVerificationMethod(eligVerif.getVerificationMethod());
            data.setEligibilityStatusDate(eligVerif.getEligibilityStatusDate());
            data.setEligibilityStatus(eligVerif.getEligibilityStatus());
        }
        data.setExposedToAgentOrange((aoe = (AgentOrangeExposure)person.getSpecialFactorByType(AgentOrangeExposure.class)) != null && this.isTrue(aoe.getAgentOrangeExposureIndicator()) ? TRUE : FALSE);
        data.setAgentOrangeExposureLocation(aoe != null ? aoe.getLocation() : null);
        RadiationExposure re = (RadiationExposure)person.getSpecialFactorByType(RadiationExposure.class);
        data.setRadiationExposureIndicator(re != null && this.isTrue(re.getRadiationExposureIndicator()) ? TRUE : FALSE);
        data.setRadiationExposureMethod(re != null ? re.getExposureMethod() : null);
        EnvironmentalContaminationExposure ece = (EnvironmentalContaminationExposure)person.getSpecialFactorByType(EnvironmentalContaminationExposure.class);
        data.setEnvironmentalContaminants(ece != null && this.isTrue(ece.getEnvironmentalContaminationExposureIndicator()) ? TRUE : FALSE);
        Set ers = person.getEmergencyResponseIndicators();
        data.setEmergencyResponse(ers != null && !ers.isEmpty() ? ((EmergencyResponseIndicator)((Object)ers.iterator().next())).getEmergencyResponse() : null);
        IneligibilityFactor iFact = person.getIneligibilityFactor();
        if (iFact != null) {
            data.setIneligibleDate(this.getImpreciseDate(iFact.getIneligibleDate()));
            data.setIneligibleReason(iFact.getReason());
            data.setIneligibleVaroDecision(iFact.getVaroDecision());
        }
        if ((ir = person.getIncompetenceRuling()) != null) {
            if (this.isTrue(ir.getIncompetent())) {
                data.setRatedIncompetent(TRUE);
            } else if (this.isFalse(ir.getIncompetent())) {
                data.setRatedIncompetent(FALSE);
            }
        }
        if ((pow = person.getPrisonerOfWar()) != null) {
            if (this.isTrue(pow.getPowIndicator())) {
                data.setPowStatusIndicated(TRUE);
            } else if (this.isFalse(pow.getPowIndicator())) {
                data.setPowStatusIndicated(FALSE);
            }
        }
        data.setTotalAnnualVACheckAmount((mba = person.getMonetaryBenefitAward()) != null ? mba.getCheckAmount() : null);
        Set set = mba != null ? mba.getMonetaryBenefits() : null;
        Iterator itr = set != null ? set.iterator() : null;
        MonetaryBenefitType mbType = null;
        MonetaryBenefit mb = null;
        while (itr != null && itr.hasNext()) {
            mb = (MonetaryBenefit)((Object)itr.next());
            mbType = mb.getType();
            if (mbType == null) continue;
            if (MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getCode().equals(mbType.getCode())) {
                if (this.isTrue(mb.getMonetaryBenefitIndicator())) {
                    data.setReceivingVADisability(TRUE);
                    continue;
                }
                data.setReceivingVADisability(FALSE);
                continue;
            }
            if (MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getCode().equals(mbType.getCode())) {
                if (this.isTrue(mb.getMonetaryBenefitIndicator())) {
                    data.setReceivingAABenefits(TRUE);
                    continue;
                }
                data.setReceivingAABenefits(FALSE);
                continue;
            }
            if (MonetaryBenefitType.CODE_HOUSEBOUND.getCode().equals(mbType.getCode())) {
                if (this.isTrue(mb.getMonetaryBenefitIndicator())) {
                    data.setReceivingHouseholdBenefits(TRUE);
                    continue;
                }
                data.setReceivingHouseholdBenefits(FALSE);
                continue;
            }
            if (!MonetaryBenefitType.CODE_VA_PENSION.getCode().equals(mbType.getCode())) continue;
            if (this.isTrue(mb.getMonetaryBenefitIndicator())) {
                data.setReceivingVAPension(TRUE);
                continue;
            }
            data.setReceivingVAPension(FALSE);
        }
        MilitaryService ms = person.getMilitaryService();
        if (ms != null) {
            if (this.isTrue(ms.getDisabilityRetirementIndicator())) {
                data.setMilitaryDisabilityRetirement(TRUE);
            } else if (this.isFalse(ms.getDisabilityRetirementIndicator())) {
                data.setMilitaryDisabilityRetirement(FALSE);
            }
            if (this.isTrue(ms.getDischargeDueToDisability())) {
                data.setDischargeDueToDisability(TRUE);
            } else if (this.isFalse(ms.getDischargeDueToDisability())) {
                data.setDischargeDueToDisability(FALSE);
            }
        }
        if ((mf = person.getMedicaidFactor()) != null) {
            if (this.isTrue(mf.getEligibleForMedicaid())) {
                data.setEligibleForMedicaid(TRUE);
            } else if (this.isFalse(mf.getEligibleForMedicaid())) {
                data.setEligibleForMedicaid(FALSE);
            }
        }
        if ((sc = person.getServiceConnectionAward()) != null) {
            data.setCombinedSCPercentEffectiveDate(sc.getCombinedServiceConnectedPercentageEffectiveDate());
            data.setPAndTEffectiveDate(this.getImpreciseDate(sc.getPermanentAndTotalEffectiveDate()));
            if (this.isTrue(sc.getPermanentAndTotal())) {
                data.setPAndT(TRUE);
            } else if (this.isFalse(sc.getPermanentAndTotal())) {
                data.setPAndT(FALSE);
            }
            if (this.isTrue(sc.getUnemployable())) {
                data.setUnemployable(TRUE);
            } else if (this.isFalse(sc.getUnemployable())) {
                data.setUnemployable(FALSE);
            }
            data.setServiceConnectedPercentage(sc.getServiceConnectedPercentage());
            data.setRatedDisabilities(sc.getRatedDisabilities());
            if (this.isTrue(sc.getServiceConnectedIndicator())) {
                data.setServiceConnected(TRUE);
            } else {
                data.setServiceConnected(FALSE);
            }
        } else {
            data.setServiceConnected(FALSE);
        }
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed != null) {
            Eligibility e = ed.getPrimaryEligibility();
            data.setEligibilityCode(e != null ? e.getType() : null);
            set = ed.getSecondaryEligibilities();
            Iterator iterator = itr = set != null ? set.iterator() : null;
            while (itr != null && itr.hasNext()) {
                e = (Eligibility)itr.next();
                data.addOtherEligibilityCode(e.getType());
            }
        }
        return data;
    }

    private HECLegacyEnrollmentFileData extractEnrollmentData(Person person) {
        CancelDecline cd;
        Application app;
        HECLegacyEnrollmentFileData data = new HECLegacyEnrollmentFileData();
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed != null) {
            data.setEffectiveDateOfChange(this.getImpreciseDate(ed.getEffectiveDate()));
            data.setEnrollmentSource(ed.getCalculationSource());
            data.setEnrollmentStatus(ed.getEnrollmentStatus());
            if (this.isTrue(ed.getOverridden())) {
                data.setEnrollmentStatusOverride(TRUE);
            } else if (this.isFalse(ed.getOverridden())) {
                data.setEnrollmentStatusOverride(FALSE);
            }
            data.setEnrollmentPriorityGroup(ed.getPriorityGroup());
            data.setEnrollmentPrioritySubgroup(ed.getPrioritySubGroup());
            data.setEnrollmentDate(this.getImpreciseDate(ed.getEnrollmentDate()));
            data.setEnrollmentEndDate(this.getImpreciseDate(ed.getEndDate()));
            data.setEnrollmentCategory(ed.getEnrollmentStatus() != null ? ed.getEnrollmentStatus().getEnrollmentCategory() : null);
            data.setEgtSetting(ed.getEgtSetting());
        }
        if ((app = person.getApplication()) != null) {
            data.setApplicationDate(this.getImpreciseDate(app.getApplicationDate()));
        }
        if ((cd = person.getCancelDecline()) != null) {
            data.setCancelDeclineReason(cd.getReason());
            data.setCancelDeclineRemarks(cd.getRemarks());
        }
        data.setPreferredFacility(person.getMostRecentPreferredFacility());
        return data;
    }

    private HECLegacyPOWFileData extractPOWData(PrisonerOfWar reg, Person person) {
        POWEpisode ep;
        HECLegacyPOWFileData data = new HECLegacyPOWFileData();
        Name name = new Name();
        if (person != null) {
            PersonIdentityTraits traits = person.getIdentityTraits();
            data.setLegalName(traits.getLegalName());
            data.setSSN(traits.getSsnText());
            data.setServiceNumbers(person.getMilitaryServiceNumbers());
        } else if (reg.getRegistryTrait() != null) {
            name.setFamilyName(reg.getRegistryTrait().getLastName());
            name.setGivenName(reg.getRegistryTrait().getFirstName());
            name.setMiddleName(reg.getRegistryTrait().getMiddleName());
            name.setSuffix(reg.getRegistryTrait().getSuffix());
            data.setLegalName(name);
            data.setSSN(reg.getRegistryTrait().getSsn());
            data.setServiceNumbers(reg.getRegistryTrait().getMilitaryServiceNumbersAsSet());
        }
        if (this.isTrue(reg.getPowIndicator())) {
            data.setConfirmed(TRUE);
        } else if (this.isFalse(reg.getPowIndicator())) {
            data.setConfirmed(FALSE);
        }
        data.setEntered(reg.getDateEntered() != null ? new ImpreciseDate(reg.getDateEntered()) : null);
        data.setUser(reg.getUser());
        Set set = reg.getEpisodes();
        POWEpisode pOWEpisode = ep = set != null && !set.isEmpty() ? (POWEpisode)((Object)set.iterator().next()) : null;
        if (ep != null) {
            data.setCaptureDate(ep.getCaptureDate());
            data.setReleaseDate(ep.getReleaseDate());
            data.setConfinementLocation(ep.getConfinementLocation());
            data.setCasualtyPlace(ep.getCampLocation());
            data.setSource(ep.getDataSource());
            data.setDaysIncarcirated(ep.getNumberOfDaysInCaptivity());
        }
        return data;
    }

    private HECLegacyPOWFileData extractPOWData(Person person) {
        PrisonerOfWar pow = person.getPrisonerOfWar();
        return pow != null ? this.extractPOWData(pow, person) : null;
    }

    private HECLegacyPurpleHeartFileData extractPurpleHeartData(PurpleHeart reg, PersonIdentityTraits traits) {
        PurpleHeartDocument doc;
        HECLegacyPurpleHeartFileData data = new HECLegacyPurpleHeartFileData();
        data.setContactRepAssigned(reg.getAssignedContactUser());
        Set docs = reg.getDocuments();
        PurpleHeartDocument purpleHeartDocument = doc = docs != null && !docs.isEmpty() ? (PurpleHeartDocument)docs.iterator().next() : null;
        if (doc != null) {
            data.setDataSource(doc.getDataSource());
            data.setDocLoggedInDate(this.getImpreciseDate(doc.getLoginDate()));
            data.setDocReceivedDate(this.getImpreciseDate(doc.getReceivedDate()));
            if (this.isTrue(doc.getAcceptable())) {
                data.setDocumentAcceptable(TRUE);
            } else if (this.isFalse(doc.getAcceptable())) {
                data.setDocumentAcceptable(FALSE);
            }
            data.setDocumentType(doc.getDocumentType());
            data.setUnacceptableRemarks(doc.getUnacceptableRemarks());
        }
        if (this.isTrue(reg.getPhIndicator())) {
            data.setIndicator(TRUE);
        } else if (this.isFalse(reg.getPhIndicator())) {
            data.setIndicator(FALSE);
        }
        if (traits != null) {
            data.setLegalName(traits.getLegalName());
            data.setSSN(traits.getSsnText());
        } else if (reg.getRegistryTrait() != null) {
            Name name = new Name();
            name.setFamilyName(reg.getRegistryTrait().getLastName());
            name.setGivenName(reg.getRegistryTrait().getFirstName());
            name.setMiddleName(reg.getRegistryTrait().getMiddleName());
            name.setSuffix(reg.getRegistryTrait().getSuffix());
            name.setPrefix(reg.getRegistryTrait().getPrefix());
            data.setLegalName(name);
            data.setDegree(reg.getRegistryTrait().getEducationalDegree());
            data.setSSN(reg.getRegistryTrait().getSsn());
        }
        data.setRejectedRemarks(reg.getRejectionRemark());
        data.setSite(reg.getFacility());
        data.setStatus(reg.getStatus());
        data.setStatusUpdateDate(this.getImpreciseDate(reg.getStatusLastEditDate()));
        data.setUpdateUser(reg.getStatusLastUpdateUser());
        data.setUpdatedDate(this.getImpreciseDate(reg.getModifiedOn()));
        return data;
    }

    private HECLegacyPurpleHeartFileData extractPurpleHeartData(Person person) {
        PurpleHeart ph = person.getPurpleHeart();
        return ph != null ? this.extractPurpleHeartData(ph, person.getIdentityTraits()) : null;
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.commsLogService, (String)"CommsLogService is required");
        Validate.notNull((Object)this.registryService, (String)"registryService is required");
        Validate.notNull((Object)this.lookupService, (String)"lookupService is required");
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    private Date getDate(ImpreciseDate date) {
        return date != null ? date.getDate() : null;
    }

    private ImpreciseDate getImpreciseDate(Date date) {
        return date != null ? new ImpreciseDate(date) : null;
    }

    private boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }

    private boolean isTrue(Indicator ind) {
        return ind != null && ind.getCode().equals(Indicator.YES.getCode());
    }

    private boolean isFalse(Boolean bool) {
        return bool != null && bool == false;
    }

    private boolean isFalse(Indicator ind) {
        return ind != null && ind.getCode().equals(Indicator.NO.getCode());
    }

    private boolean isUnknown(Boolean bool) {
        return bool == null;
    }

    private boolean isUnknown(Indicator ind) {
        return ind != null && ind.getCode().equals(Indicator.UNKNOWN.getCode());
    }
}

