/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.DataSynchronizationProducerStatistics;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataQueriesProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

public abstract class AbstractDataSynchronizationProducerProcess
extends AbstractDataQueriesProcess {
    public static String CONTEXT_ACQUIRED_OBJECTS = "acquiredObjects";
    public static String CONTEXT_FILE_STATS = "fileStats";
    private PersonService personService;
    private FormattedFileWriter fileWriter;
    private int entityCountPerFile;
    private int lineCountPerFile;
    private boolean blankLineAtEndOfFile = true;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        Iterator itr = acquiredData.iterator();
        Object acquiredObject = null;
        Object processedObject = null;
        Object transformedData = null;
        ArrayList data = new ArrayList();
        while (itr.hasNext()) {
            block4: {
                acquiredObject = itr.next();
                try {
                    if (!this.shouldProcessAcquiredObject(context, acquiredObject)) continue;
                    processedObject = this.getProcessedObject(context, acquiredObject);
                    if (processedObject == null) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)"Unable to retrieve processed object for data sync...it was retrieved as null....ignoring this entry");
                        continue;
                    }
                    transformedData = this.transformObject(context, processedObject, acquiredObject);
                    this.writeToFile(context, transformedData, data, processedObject, acquiredObject);
                }
                catch (Exception e) {
                    context.getExceptionData().add(e);
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    data.clear();
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error((Object)("Unable to synchronize Entity: " + acquiredObject + " due to exception"), (Throwable)e);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
    }

    protected void changeFileExtensions(String fromExtn, String toExtn) {
        block2: {
            try {
                this.fileWriter.changeFileExtensions(fromExtn, toExtn);
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)("Exception occured while convertin the files extension from " + fromExtn + " to " + toExtn), (Throwable)e);
            }
        }
    }

    protected void writeToFile(DataQueryProcessExecutionContext context, Object transformedData, List data, Object processedObject, Object acquiredObject) {
        int transformedSize = 1;
        if (transformedData instanceof Collection) {
            Collection coll = (Collection)transformedData;
            transformedSize = coll.size();
            data.addAll(coll);
        } else {
            data.add(transformedData);
        }
        if (this.shouldCreateNewFile(context, transformedSize)) {
            this.processEndOfFile(context);
            DataSynchronizationProducerStatistics stats = this.getFileStats(context);
            stats = this.createNewFileStats(context);
            this.fileWriter.writeData(data, (Object)stats.getStartTime());
        } else {
            if (!this.blankLineAtEndOfFile && context.getProcessStatistics().getNumberOfSuccessfulRecords() > 0) {
                this.fileWriter.println((Object)this.getFileStats(context).getStartTime());
            }
            this.fileWriter.appendData(data, (Object)this.getFileStats(context).getStartTime());
        }
        this.getFileStats(context).incrementEntityCount();
        this.addFileData(context, this.getFileStats(context), processedObject, acquiredObject);
        this.getFileStats(context).incrementObjectCount(transformedSize);
        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
        data.clear();
        this.postProcessAcquiredObject(context, this.getFileStats(context), processedObject, acquiredObject);
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        super.handleDataProcessCompleted(context);
        this.processEndOfFile((DataQueryProcessExecutionContext)context);
    }

    private void processEndOfFile(DataQueryProcessExecutionContext context) {
        DataSynchronizationProducerStatistics stats = this.getFileStats(context);
        if (stats != null) {
            stats.setEndTime(new Date());
            this.postProcessDataFile(context, stats);
        }
    }

    protected void addFileData(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats, Object processedObject, Object acquiredObject) {
        stats.addFileData(acquiredObject);
    }

    private DataSynchronizationProducerStatistics getFileStats(DataQueryProcessExecutionContext context) {
        DataSynchronizationProducerStatistics stats = (DataSynchronizationProducerStatistics)((Object)context.getContextData().get(CONTEXT_FILE_STATS));
        if (stats == null) {
            stats = this.createNewFileStats(context);
        }
        return stats;
    }

    private DataSynchronizationProducerStatistics createNewFileStats(DataQueryProcessExecutionContext context) {
        DataSynchronizationProducerStatistics stats = new DataSynchronizationProducerStatistics();
        Date startTime = new Date();
        stats.setStartTime(startTime);
        stats.setFileName(this.fileWriter.getFileSystemResource((Object)startTime).getFilename());
        this.setFileStats(context, stats);
        return stats;
    }

    private void setFileStats(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats) {
        context.getContextData().put(CONTEXT_FILE_STATS, stats);
    }

    private boolean shouldCreateNewFile(DataQueryProcessExecutionContext context, int transformedSize) {
        boolean result = false;
        DataSynchronizationProducerStatistics stats = this.getFileStats(context);
        if (stats == null) {
            result = true;
        } else if (this.entityCountPerFile != 0 && stats.getEntityCount() + 1 > this.entityCountPerFile) {
            result = true;
        } else if (this.lineCountPerFile != 0 && stats.getObjectCount() + transformedSize > this.lineCountPerFile) {
            result = true;
        }
        return result;
    }

    protected void postProcessDataFile(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats) {
    }

    protected void postProcessAcquiredObject(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats, Object processedObject, Object acquiredObject) {
    }

    protected boolean shouldProcessAcquiredObject(DataQueryProcessExecutionContext context, Object acquiredObject) {
        PersonChangeLogEntry log = (PersonChangeLogEntry)((Object)acquiredObject);
        PersonIdEntityKey key = log.getPersonEntityKey();
        HashMap<PersonIdEntityKey, Object> keysVisited = (HashMap<PersonIdEntityKey, Object>)context.getContextData().get(CONTEXT_ACQUIRED_OBJECTS);
        if (keysVisited == null) {
            keysVisited = new HashMap<PersonIdEntityKey, Object>();
            context.getContextData().put(CONTEXT_ACQUIRED_OBJECTS, keysVisited);
        }
        boolean shouldProcessAcquiredObject = true;
        if (keysVisited.containsKey(key)) {
            shouldProcessAcquiredObject = false;
        } else {
            keysVisited.put(key, null);
        }
        return shouldProcessAcquiredObject;
    }

    protected Object getProcessedObject(DataQueryProcessExecutionContext context, Object acquiredObject) throws ServiceException {
        PersonChangeLogEntry log = (PersonChangeLogEntry)((Object)acquiredObject);
        PersonIdEntityKey personKey = log.getPersonEntityKey();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Synchronizing data for Person: " + personKey.getKeyValueAsString()));
        }
        return this.personService.getPerson(personKey);
    }

    protected abstract Object transformObject(DataQueryProcessExecutionContext var1, Object var2, Object var3) throws ServiceException;

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"personService must be non-null");
        Validate.notNull((Object)this.fileWriter, (String)"fileWriter must be non-null");
        if (!this.blankLineAtEndOfFile) {
            this.fileWriter.setExtraCarriageReturnAfterEachDataWrite(false);
        }
    }

    public FormattedFileWriter getFileWriter() {
        return this.fileWriter;
    }

    public void setFileWriter(FormattedFileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    public int getLineCountPerFile() {
        return this.lineCountPerFile;
    }

    public void setLineCountPerFile(int lineCountPerFile) {
        this.lineCountPerFile = lineCountPerFile;
    }

    public int getEntityCountPerFile() {
        return this.entityCountPerFile;
    }

    public void setEntityCountPerFile(int entityCountPerFile) {
        this.entityCountPerFile = entityCountPerFile;
    }

    public boolean isBlankLineAtEndOfFile() {
        return this.blankLineAtEndOfFile;
    }

    public void setBlankLineAtEndOfFile(boolean blankLineAtEndOfFile) {
        this.blankLineAtEndOfFile = blankLineAtEndOfFile;
    }
}

