/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.NCOAAddressVerificationFileProcessStatistics;
import gov.va.med.esr.common.batchprocess.NCOAAddressVerificationFileSummary;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.batchprocess.DataProcessCompletedHandler;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Date;
import java.util.HashMap;

public class SendNCOAAddressFileProcessCompletedHandler
extends AbstractComponent
implements DataProcessCompletedHandler {
    private DAOOperations dao;
    private CommsEmailBulletinService bulletinService;
    private static final String PARAM_NAME_ADDRESS_CODE = "addressCode";
    private static final String PARAM_NAME_COUNTRY_CODE = "countryCode";
    private String queryNameTotalScreenedCount;
    private String queryNameTotalDeceasedCount;

    public String getQueryNameTotalDeceasedCount() {
        return this.queryNameTotalDeceasedCount;
    }

    public void setQueryNameTotalDeceasedCount(String queryNameTotalDeceasedCount) {
        this.queryNameTotalDeceasedCount = queryNameTotalDeceasedCount;
    }

    public String getQueryNameTotalScreenedCount() {
        return this.queryNameTotalScreenedCount;
    }

    public void setQueryNameTotalScreenedCount(String queryNameTotalScreenedCount) {
        this.queryNameTotalScreenedCount = queryNameTotalScreenedCount;
    }

    public void dataProcessingComplete(DataProcessExecutionContext context) {
        NCOAAddressVerificationFileProcessStatistics statistics = (NCOAAddressVerificationFileProcessStatistics)context.getProcessStatistics();
        NCOAAddressVerificationFileSummary summary = new NCOAAddressVerificationFileSummary();
        try {
            Integer numberOfRecordsScreened = (Integer)this.getDao().find(this.queryNameTotalScreenedCount).iterator().next();
            summary.setCountOfRecordsScreened(numberOfRecordsScreened);
            String[] paramNames = new String[]{PARAM_NAME_COUNTRY_CODE};
            Object[] params = new Object[]{Country.CODE_USA.getCode()};
            Integer numberOfRecordsDeceased = (Integer)this.getDao().findByNamedQueryAndNamedParam(this.queryNameTotalDeceasedCount, paramNames, params).iterator().next();
            summary.setCountOfRecordsDeceased(numberOfRecordsDeceased);
            summary.setCountOfRecordsAfterScreening(statistics.getNumberOfSuccessfulRecords());
            summary.setCountOfRecordsExcluded(numberOfRecordsScreened - statistics.getNumberOfSuccessfulRecords());
            this.getDao().saveObject((Object)summary);
            statistics.setNcoaAddressVerificationFileSummary(summary);
            if (this.bulletinService != null) {
                HashMap<String, Comparable<Date>> bulletinData = new HashMap<String, Comparable<Date>>();
                bulletinData.put("EndTime", new Date());
                bulletinData.put("TotalCount", new Integer(summary.getCountOfRecordsScreened()));
                bulletinData.put("ExcludedCount", new Integer(summary.getCountOfRecordsExcluded()));
                bulletinData.put("DeceasedCount", new Integer(summary.getCountOfRecordsDeceased()));
                bulletinData.put("SentToAACCount", new Integer(summary.getCountOfRecordsAfterScreening()));
                bulletinData.put("SentToAACFileCount", new Integer(1));
                this.bulletinService.sendEmailBulletin(BulletinTrigger.DataType.NCOA_PROCESS_ENDED, bulletinData, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while handling the completion of NCOA processing", e);
        }
    }

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }
}

