/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.batchprocess.SSNVerificationResponseProcess;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import java.io.PrintWriter;
import java.io.StringWriter;

public class SSNVerificationResponseProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private DataFileProcessExecutionContext context;
    private SSASSNVerificationData dataRecord;
    private DemographicService demographicService;

    public DataFileProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataFileProcessExecutionContext context) {
        this.context = context;
    }

    public SSASSNVerificationData getDataRecord() {
        return this.dataRecord;
    }

    public void setDataRecord(SSASSNVerificationData dataRecord) {
        this.dataRecord = dataRecord;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask started");
        }
        try {
            if (!this.context.isInterrupted()) {
                this.demographicService.updateSSNVerificationResponse(this.dataRecord);
                this.context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            }
        }
        catch (Exception e) {
            this.handleFailure(this.context, this.dataRecord, e);
        }
        finally {
            Object threadCreator;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask ended");
            }
            SSNVerificationResponseProcess.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
            Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
            synchronized (object) {
                threadCreator.notifyAll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"SSNVerificationResponseProcessSpawnedThreadTask notified creator");
            }
            this.context = null;
        }
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleFailure(DataFileProcessExecutionContext context, SSASSNVerificationData identityData, Exception e) {
        String exceptionText = null;
        exceptionText = e == null ? "Error: Unable to process identity data: " + (Object)((Object)identityData) : "Error: Unable process for identity data: " + (Object)((Object)identityData) + " because of exception: " + e;
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(identityData);
        context.getExceptionData().add(exceptionText + "\n\n");
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            context.getExceptionData().add(trackTrace);
        }
    }
}

