/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.SystemParameterUnit;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.SystemParametersChangedEvent;
import gov.va.med.fw.scheduling.DynamicCronTriggerBean;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.service.AbstractListenerService;
import gov.va.med.fw.service.event.ServiceEvent;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class RescheduleDynamicCronTriggersProcessListener
extends AbstractListenerService {
    private SchedulingService schedulingService;
    private List triggers;
    private SystemParameterService systemParameterService;

    protected void processServiceEvent(ServiceEvent event) {
        if (!(event instanceof SystemParametersChangedEvent)) {
            return;
        }
        Iterator itr = this.triggers.iterator();
        DynamicCronTriggerBean targetTrigger = null;
        while (itr.hasNext()) {
            targetTrigger = (DynamicCronTriggerBean)itr.next();
            try {
                this.schedulingService.reschedule(targetTrigger.getName(), targetTrigger.getGroup(), this.modifyTrigger(targetTrigger));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error((Object)("Unable to reschedule trigger named " + targetTrigger.getName() + " based on a System Parameter change"), (Throwable)e);
            }
        }
    }

    private Trigger modifyTrigger(DynamicCronTriggerBean trigger) throws Exception {
        SystemParameter parameter = this.systemParameterService.getByName(trigger.getSystemParameterName());
        SystemParameterUnit unit = parameter.getUnit();
        DynamicCronTriggerBean targetTrigger = trigger;
        long milliSecondInterval = 0L;
        if (SystemParameterUnit.CODE_HOURS.getCode().equals(unit.getCode())) {
            milliSecondInterval = Long.parseLong(parameter.getValue()) * 3600000L;
        } else if (SystemParameterUnit.CODE_DAYS.getCode().equals(unit.getCode())) {
            milliSecondInterval = Long.parseLong(parameter.getValue()) * 3600000L * 24L;
        } else if (SystemParameterUnit.CODE_WEEKS.getCode().equals(unit.getCode())) {
            milliSecondInterval = Long.parseLong(parameter.getValue()) * 3600000L * 24L * 7L;
        } else if (SystemParameterUnit.CODE_MONTHS.getCode().equals(unit.getCode())) {
            milliSecondInterval = Long.parseLong(parameter.getValue()) * 3600000L * 24L * 30L;
        }
        if (milliSecondInterval != 0L) {
            targetTrigger = new SimpleTrigger(trigger.getName(), trigger.getGroup(), SimpleTrigger.REPEAT_INDEFINITELY, milliSecondInterval);
            long startTime = new Date().getTime() + milliSecondInterval;
            targetTrigger.setStartTime(new Date(startTime));
            targetTrigger.setJobName(trigger.getJobName());
            targetTrigger.setJobGroup(trigger.getJobGroup());
        }
        return targetTrigger;
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.systemParameterService, (String)"systemParameterService is required");
        Validate.notNull((Object)this.schedulingService, (String)"schedulingService is required");
        Validate.notNull((Object)this.triggers, (String)"triggers is required");
        Iterator itr = this.triggers.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof DynamicCronTriggerBean) continue;
            throw new InvalidConfigurationException("triggers contain an element that is not an instanceof DynamicCronTriggerBean");
        }
    }

    public List getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List triggers) {
        this.triggers = triggers;
    }
}

