/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.RequestSSNVerificationProcess;
import gov.va.med.esr.common.batchprocess.RequestSSNVerificationStatistics;
import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.batchprocess.SSNVerificationProcessExecutionContext;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.UniqueIdentifierGenerator;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;

public class RequestSSNVerificationProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private PersonService personService;
    private PersonDAO personDAO;
    private DAOOperations dao;
    private Object[] acquiredData;
    private SSAVerificationStatus SSNVerificationStatus = null;
    private SSNVerificationProcessExecutionContext context = null;
    private String processName = null;
    private UniqueIdentifierGenerator generator;

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public UniqueIdentifierGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(UniqueIdentifierGenerator generator) {
        this.generator = generator;
    }

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    public Object[] getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(Object[] acquiredData) {
        this.acquiredData = acquiredData;
    }

    public SSNVerificationProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(SSNVerificationProcessExecutionContext context) {
        this.context = context;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public SSAVerificationStatus getSSNVerificationStatus() {
        return this.SSNVerificationStatus;
    }

    public void setSSNVerificationStatus(SSAVerificationStatus verificationStatus) {
        this.SSNVerificationStatus = verificationStatus;
    }

    private String generateControlIdentifier() throws ServiceException {
        return this.generator.generate().toString();
    }

    public void executeTask() throws Throwable {
        if (this.acquiredData.length == 3) {
            this.processVeteran();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVeteran() {
        block33: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"+++++ Entering  RequestSSNVerificationProcessSpawnedThreadTask.processVeteran()");
            }
            SSNVerificationDetail detail = (SSNVerificationDetail)((Object)this.acquiredData[0]);
            RequestSSNVerificationStatistics stats = (RequestSSNVerificationStatistics)((Object)this.acquiredData[1]);
            List vetFileOutputData = (List)this.acquiredData[2];
            BigDecimal personId = detail.getPersonId();
            VPIDEntityKey vpid = null;
            PersonIdentityTraits identityTraits = null;
            Person person = null;
            try {
                vpid = this.getPersonService().getVPIDByPersonId(new PersonIdEntityKeyImpl(personId));
                if (vpid == null) {
                    this.handleVeteranError(this.context, stats, "Empty vpid while executing Request SSN Verification batch process for personId= " + personId);
                    return;
                }
                identityTraits = this.getPersonService().getESRCorrelation(vpid);
                if (identityTraits == null) {
                    this.handleVeteranError(this.context, stats, "Empty identityTraits while executing Request SSN Verification batch process for vpid= " + vpid);
                    return;
                }
                SSN ssn = identityTraits.getSsn();
                if (!identityTraits.isHasPendingUpdates() && ssn != null) {
                    ssn.setSsaVerificationStatus(this.SSNVerificationStatus);
                    ssn.setSsaSentDate(Calendar.getInstance().getTime());
                    person = (Person)((Object)this.getPersonDAO().getByKey((EntityKey)new PersonIdEntityKeyImpl(personId)));
                    person.setIdentityTraits(identityTraits);
                    this.getPersonService().updateProfileForESRCorrelation(person);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"RequestSSNVerificationProcessSpawnedThreadTask.processVeteran(): after updateProfileForESRCorrelation()");
                    }
                    SSASSNVerificationData data = this.convertIdentityTraitToOutputFileData(personId.toString(), vpid.getKeyValueAsString(), identityTraits);
                    RequestSSNVerificationProcessSpawnedThreadTask requestSSNVerificationProcessSpawnedThreadTask = this;
                    synchronized (requestSSNVerificationProcessSpawnedThreadTask) {
                        vetFileOutputData.add(data);
                    }
                    detail.setHECInternalId(data.getHECInternalID());
                    detail.setPersonId(new BigDecimal(data.getPersonId()));
                    detail.setSsnText(data.getSsn());
                    this.getDao().saveObject((Object)detail);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("RequestSSNVerificationProcessSpawnedThreadTask.processVeteran(): after saveObject(detail): " + (Object)((Object)detail)));
                    }
                    break block33;
                }
                stats.setNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits(stats.getNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits() + 1);
                stats.setNumberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits(stats.getNumberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits() + 1);
            }
            catch (Exception e) {
                stats.setNumberOfErrorRecords(stats.getNumberOfErrorRecords() + 1);
                stats.setNumberOfErrorVetRecords(stats.getNumberOfErrorVetRecords() + 1);
                String errorMessage = "Error while executing Request SSN Verification batch process for veterans: Reason: " + e.getMessage();
                this.context.getExceptionData().add(errorMessage);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)errorMessage, (Throwable)e);
                }
            }
            finally {
                Object threadCreator;
                RequestSSNVerificationProcess.adjustTaskCount(this.context, -1);
                Object object = threadCreator = this.getThreadCreator(this.context);
                synchronized (object) {
                    threadCreator.notifyAll();
                }
                this.context = null;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"+++++ Leaving RequestSSNVerificationProcessSpawnedThreadTask.processVeteran() finally block");
                }
            }
        }
    }

    private Object getThreadCreator(SSNVerificationProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleVeteranError(SSNVerificationProcessExecutionContext context, RequestSSNVerificationStatistics stats, String errorMessage) {
        stats.setNumberOfErrorRecords(stats.getNumberOfErrorRecords() + 1);
        stats.setNumberOfErrorVetRecords(stats.getNumberOfErrorVetRecords() + 1);
        context.getExceptionData().add(errorMessage);
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)errorMessage);
        }
    }

    private SSASSNVerificationData convertIdentityTraitToOutputFileData(String personId, String vpidKey, PersonIdentityTraits identityTraits) {
        SSASSNVerificationData ssnVerificationData = new SSASSNVerificationData();
        ssnVerificationData.setVpidValue(vpidKey);
        try {
            ssnVerificationData.setHECInternalID(this.generateControlIdentifier());
            ssnVerificationData.setSsn(identityTraits.getSsn().getSsnText());
            ssnVerificationData.setLastName(identityTraits.getLegalName().getFamilyName());
            ssnVerificationData.setFirstName(identityTraits.getLegalName().getGivenName());
            ssnVerificationData.setMiddleInitial(identityTraits.getLegalName().getMiddleName());
            ssnVerificationData.setDateOfBirth(identityTraits.getBirthRecord() == null ? null : identityTraits.getBirthRecord().getBirthDate());
            ssnVerificationData.setGender(identityTraits.getGender() == null ? null : identityTraits.getGender().getCode());
            ssnVerificationData.setPersonId(personId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error converting to putput data for veteran with vpid key " + vpidKey), (Throwable)e);
        }
        return ssnVerificationData;
    }
}

