/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.PersonIdFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PCMMZ11Process
extends AbstractDataFileSingleRowIncrementProcess {
    private TriggerRouter triggerRouter;

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        boolean success = false;
        try {
            PersonIdFileData dataRecord = (PersonIdFileData)((Object)bean);
            PersonIdEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey(dataRecord.getPersonId());
            this.getTriggerRouter().processTriggerEvent(this.getTriggerEvent(key));
            success = true;
        }
        catch (Exception e) {
            this.handleFailure(context, (PersonIdFileData)((Object)bean), e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count = " + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
        if (context.getProcessStatistics().isTotalNumberMod(5)) {
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        return success;
    }

    private void handleFailure(DataFileProcessExecutionContext context, PersonIdFileData data, Exception e) {
        String exceptionText = null;
        exceptionText = e == null ? "Error: Unable to process personId data: " + (Object)((Object)data) : "Error: Unable process personId data: " + (Object)((Object)data) + " because of exception: " + e;
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getExceptionData().add(data);
        context.getExceptionData().add(exceptionText + "\n\n");
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            context.getExceptionData().add(trackTrace);
        }
    }

    private TriggerEvent getTriggerEvent(PersonEntityKey key) {
        PersonTriggerEvent triggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY);
        triggerEvent.setPersonId(key);
        return triggerEvent;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }
}

