/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.OPPExtractCommonOutputFileProducer;
import gov.va.med.esr.common.batchprocess.OPPExtractExecutionContext;
import gov.va.med.esr.common.batchprocess.OPPExtractProcessStatistics;
import gov.va.med.esr.common.model.lookup.DescriptorType;
import gov.va.med.fw.io.RawFileDataList;
import java.util.List;

public class OPPExtractCDDescriptorOutputFileProducer
extends OPPExtractCommonOutputFileProducer {
    @Override
    protected void incrementStatistics(OPPExtractExecutionContext context, List outputFileData) {
        OPPExtractProcessStatistics statistics = (OPPExtractProcessStatistics)context.getProcessStatistics();
        this.setStatistics(statistics, outputFileData);
    }

    private void setStatistics(OPPExtractProcessStatistics statistics, List outputFileData) {
        statistics.incrementNumberOfSuccessfulRecords(outputFileData.size());
        statistics.incrementNumberOfCDDescriptorFileRecords(outputFileData.size());
        if (outputFileData != null && !outputFileData.isEmpty()) {
            for (RawFileDataList dataRow : outputFileData) {
                String descriptorCode = (String)dataRow.get(2);
                if (descriptorCode == null) continue;
                if (DescriptorType.CODE_QUADRIPLEGIA.getName().equals(descriptorCode)) {
                    statistics.incrementNumberOfDescriptorQuadriplegia(1);
                    continue;
                }
                if (DescriptorType.CODE_PARAPLEGIA.getName().equals(descriptorCode)) {
                    statistics.incrementNumberOfDescriptorParaplegia(1);
                    continue;
                }
                if (DescriptorType.CODE_PERSISTENT_VEGETATIVE_STATE.getName().equals(descriptorCode)) {
                    statistics.incrementNumberOfDescriptorVegetative(1);
                    continue;
                }
                if (DescriptorType.CODE_LEGAL_BLINDNESS.getName().equals(descriptorCode)) {
                    statistics.incrementNumberOfDescriptorBlindness(1);
                    continue;
                }
                if (DescriptorType.CODE_AMPUTATION_DISARTICULATION_DETACHMENT.getName().equals(descriptorCode)) {
                    statistics.incrementNumberOfDescriptorAmputation(1);
                    continue;
                }
                if (DescriptorType.CODE_DEFICIENCIES_OF_PHYSICAL_OR_MENTAL_FUNCTION.getName().equals(descriptorCode)) {
                    statistics.incrementNumberOfDescriptorFunction(1);
                    continue;
                }
                if (!DescriptorType.CODE_DEAFNESS.getName().equals(descriptorCode)) continue;
                statistics.incrementNumberOfDescriptorDeafness(1);
            }
        }
    }
}

