/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.AacExportCommand;
import gov.va.med.esr.common.batchprocess.CommsExportStatistics;
import gov.va.med.fw.batchprocess.AacExportProcessStatistics;
import gov.va.med.fw.batchprocess.AbstractLegacyDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.service.ServiceException;

public class InitiateAACLetterExportProcess
extends AbstractLegacyDataProcess {
    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        try {
            CommsExportStatistics legacyStats;
            AacExportCommand cmd = (AacExportCommand)this.getComponent("aacExportCommand");
            String[] args = null;
            if (context.getExecutionArguments() != null) {
                args = context.getExecutionArguments() instanceof String[] ? (String[])context.getExecutionArguments() : new String[]{(String)context.getExecutionArguments()};
            }
            if ((legacyStats = cmd.execute(args, context, this)) != null) {
                AacExportProcessStatistics aacstats = this.prepareStatistics(context, legacyStats);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception executing AacExportCommand", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void updateLiveJobStatistics(DataProcessExecutionContext context, CommsExportStatistics stats) {
        AacExportProcessStatistics aacstats = this.prepareStatistics(context, stats);
        if (this.logger.isTraceEnabled()) {
            this.logger.debug((Object)("updateLiveJobStatistics:" + context.getProcessStatistics().getNumberOfTotalRecords()));
        }
        if (context.getProcessStatistics().isTotalNumberMod(5)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"updateLiveJobStatistics:Updating the job stats");
            }
            this.updateJobResult(context);
        }
    }

    private AacExportProcessStatistics prepareStatistics(DataProcessExecutionContext context, CommsExportStatistics stats) {
        AacExportProcessStatistics aacstats = (AacExportProcessStatistics)context.getProcessStatistics();
        aacstats.setNumberOfTotalRecords(stats.getNumberSent() + stats.getNumberCancelled() + stats.getNumberRejected());
        aacstats.setNumberOfSuccessfulRecords(stats.getNumberSent());
        aacstats.setNumberOfErrorRecords(stats.getNumberRejected() + stats.getNumberCancelled());
        aacstats.setNumberWithException(stats.getNumberWithException());
        return aacstats;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new AacExportProcessStatistics();
    }
}

