/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.List;
import org.apache.commons.lang.Validate;

public class HandBookBatchRequestConsumerSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private DataFileProcessExecutionContext context;
    private List acquiredData;
    private HandBookService handBookService;

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask started");
        }
        HandBookBatchRequest handBookBatchRequest = (HandBookBatchRequest)((Object)this.acquiredData.get(0));
        try {
            this.handBookService.updateBatchRequestEstCountRecord(handBookBatchRequest);
        }
        catch (Exception e) {
            this.handleFailure(this.context, this.acquiredData, e);
        }
        finally {
            Object threadCreator;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask ended");
            }
            Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
            synchronized (object) {
                threadCreator.notifyAll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask notified creator");
            }
            this.context = null;
        }
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleFailure(DataFileProcessExecutionContext context, List identityData, Exception e) {
        String exceptionText = null;
        if (e == null) {
            exceptionText = "Error: Unable to synchronize data for identity data: " + identityData;
        } else if (e instanceof BuilderException) {
            Throwable cause = e.getCause();
            Throwable causesCause = cause != null ? cause.getCause() : null;
            exceptionText = "Error: Unable to synchronize data for identity data: " + identityData + " because of BuilderException with cause: " + cause + " and causes cause: " + causesCause;
        } else {
            exceptionText = "Error: Unable to synchronize data for identity data: " + identityData + " because of exception: " + e;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(identityData);
        context.getExceptionData().add(exceptionText + "\n\n");
    }

    public List getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(List acquiredData) {
        this.acquiredData = acquiredData;
    }

    public DataFileProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataFileProcessExecutionContext context) {
        this.context = context;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.handBookService, (String)"personService can not be null");
    }
}

