/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.GenerateQRYZ11MessagingService;
import gov.va.med.esr.service.impl.GenerateQRYZ11MessagingServiceImpl;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.Validate;

public class GenerateQRYZ11Process
extends AbstractDataQueryIncrementalProcess {
    private GenerateQRYZ11MessagingService messagingService = null;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block7: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal personId = (BigDecimal)row[0];
                PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(personId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
                }
                try {
                    this.processRecord(key, row);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing " + this.getProcessName() + " for person " + personId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block7;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    protected void processRecord(PersonEntityKey key, Object[] dataRow) throws Exception {
        String VPID = (String)dataRow[1];
        this.messagingService.generateMessage(key, VPID);
    }

    public void setMessagingService(GenerateQRYZ11MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected GenerateQRYZ11MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.messagingService, (String)"A MessagingService is needed");
        Validate.isTrue((!(this.messagingService instanceof GenerateQRYZ11MessagingServiceImpl) ? 1 : 0) != 0, (String)"A GenerateQRYZ11 Messaging Service is required");
    }
}

