/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.ExpireMeansTestProcessStatistics;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ExpireMeansTestProcess
extends AbstractDataQueryIncrementalProcess {
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;

    protected ProcessStatistics createProcessStatistics() {
        return new ExpireMeansTestProcessStatistics();
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Expire MeansTest batch process: Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block9: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal personId = (BigDecimal)row[0];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
                }
                try {
                    if (this.eligibilityEnrollmentService.processExpiredMeansTestForBatchProcess(new PersonIdEntityKeyImpl(personId))) {
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    } else {
                        ((ExpireMeansTestProcessStatistics)context.getProcessStatistics()).incrementNumberOfNotSubjectToMeansTestRecords();
                    }
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing Expire MeansTest batch process for person " + personId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block9;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"ExpireMeansTest: Processing of current batch complete.");
            this.logger.debug((Object)("ExpireMeansTest: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("ExpireMeansTest: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
            this.logger.debug((Object)("ExpireMeansTest: Not subject to means test records count =" + ((ExpireMeansTestProcessStatistics)context.getProcessStatistics()).getNumberOfNotSubjectToMeansTestRecords()));
        }
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.eligibilityEnrollmentService, (String)"A EligibilityEnrollmentService is needed");
    }
}

