/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.VPIDFileData;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.math.BigDecimal;
import java.util.List;

public class ContinuousEnrollmentCleanUpProcess
extends AbstractDataFileIncrementalProcess {
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List beans) {
        if (this.logger.isDebugEnabled()) {
            int listSize = 0;
            if (beans != null) {
                listSize = beans.size();
            }
            this.logger.error((Object)("Processing VPID  " + listSize));
        }
        for (int i = 0; beans != null && i < beans.size(); ++i) {
            VPIDFileData dataRecord = (VPIDFileData)((Object)beans.get(i));
            String personIdinString = dataRecord.getVpid();
            System.out.println(personIdinString);
            try {
                BigDecimal personId = new BigDecimal(personIdinString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)("Processing person ID  " + dataRecord.getVpid()));
                }
                this.getEligibilityEnrollmentService().processCalculateEEForCleanup(new PersonIdEntityKeyImpl(personId), true, true);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during continous Enrollment clean up process for person ID " + dataRecord.getVpid()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }
}

