/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.HecRejectReason;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class CommsExportStatistics
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 5284593107794163278L;
    public static String LINE_BREAK = "\n";
    private static String APPEND_TEXT = " to be send to AAC = ";
    private static String CMS_APPEND_TEXT = " to be send to CMS = ";
    private static String APPEND_HB_TEXT = " to be send to HANDBOOK CMS = ";
    private Hashtable countPerFormTable = new Hashtable();
    private Hashtable rejectPerReasonPerformTable = new Hashtable();
    private String fileName = null;
    private String originalFileName = null;
    private Date startTime;
    private Date endTime;
    private int numberSent;
    private int numberRejected;
    private int numberCancelled;
    private int numberRemailed;
    private int numberWithException;

    public synchronized void addToCountPerFormTable(String formNumber) {
        if (this.countPerFormTable.get(formNumber) == null) {
            this.countPerFormTable.put(formNumber, new Integer(1));
        } else {
            this.countPerFormTable.put(formNumber, new Integer((Integer)this.countPerFormTable.get(formNumber) + 1));
        }
    }

    public void addToCountPerFormTable(AacLetterRequest entry) {
        if (entry == null) {
            return;
        }
        String formNumber = entry.getCommsTemplateFormNumber();
        if (this.countPerFormTable.get(formNumber) == null) {
            this.countPerFormTable.put(formNumber, new Integer(1));
        } else {
            this.countPerFormTable.put(formNumber, new Integer((Integer)this.countPerFormTable.get(formNumber) + 1));
        }
    }

    public String getCountPerFormTableText() {
        if (this.countPerFormTable == null || this.countPerFormTable.size() == 0) {
            return "";
        }
        StringBuffer txt = new StringBuffer();
        Enumeration keys = this.countPerFormTable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (this.isIVMFinalLetter((String)key) || this.isCompassionLetter((String)key)) {
                txt.append(key).append(CMS_APPEND_TEXT).append(this.countPerFormTable.get(key)).append(LINE_BREAK);
                continue;
            }
            txt.append(key).append(APPEND_TEXT).append(this.countPerFormTable.get(key)).append(LINE_BREAK);
        }
        return txt.toString();
    }

    public String getHbCountPerFormTableText() {
        if (this.countPerFormTable == null || this.countPerFormTable.size() == 0) {
            return "";
        }
        StringBuffer txt = new StringBuffer();
        Enumeration keys = this.countPerFormTable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            txt.append(key).append(APPEND_HB_TEXT).append(this.countPerFormTable.get(key)).append(LINE_BREAK);
        }
        return txt.toString();
    }

    public synchronized void updateRejectPerReasonPerformTable(String errorText, String formNumber) {
        if (errorText == null || errorText.length() == 0) {
            return;
        }
        String[] errorReasons = errorText.split(LINE_BREAK);
        String reason = null;
        Hashtable formTab = null;
        for (int i = 0; i < errorReasons.length; ++i) {
            reason = errorReasons[i];
            if (this.rejectPerReasonPerformTable.get(reason) == null) {
                formTab = new Hashtable();
                formTab.put(formNumber, new Integer(1));
                this.rejectPerReasonPerformTable.put(reason, formTab);
                continue;
            }
            formTab = (Hashtable)this.rejectPerReasonPerformTable.get(reason);
            if (formTab.get(formNumber) == null) {
                formTab.put(formNumber, new Integer(1));
                continue;
            }
            formTab.put(formNumber, new Integer((Integer)formTab.get(formNumber) + 1));
        }
    }

    public void updateRejectPerReasonPerformTable(CommsLogEntry entry) {
        if (entry == null || entry.getHecRejectionReasons() == null || entry.getHecRejectionReasons().size() == 0) {
            return;
        }
        String reasonDesc = null;
        String formNumber = entry.getFormNumber();
        Hashtable formTab = null;
        for (int i = 0; i < entry.getHecRejectionReasons().size(); ++i) {
            reasonDesc = ((HecRejectReason)((Object)entry.getHecRejectionReasons().get(i))).getHecRejectReasonDescription();
            if (this.rejectPerReasonPerformTable.get(reasonDesc) == null) {
                formTab = new Hashtable();
                formTab.put(formNumber, new Integer(1));
                this.rejectPerReasonPerformTable.put(reasonDesc, formTab);
                continue;
            }
            formTab = (Hashtable)this.rejectPerReasonPerformTable.get(reasonDesc);
            if (formTab.get(formNumber) == null) {
                formTab.put(formNumber, new Integer(1));
                continue;
            }
            formTab.put(formNumber, new Integer((Integer)formTab.get(formNumber) + 1));
        }
    }

    public String getRejectPerReasonPerFormText() {
        if (this.rejectPerReasonPerformTable == null || this.rejectPerReasonPerformTable.size() == 0) {
            return "";
        }
        StringBuffer txt = new StringBuffer();
        Enumeration reasonKeys = this.rejectPerReasonPerformTable.keys();
        String reasonDesc = null;
        Hashtable formTab = null;
        String formNumber = null;
        while (reasonKeys.hasMoreElements()) {
            reasonDesc = (String)reasonKeys.nextElement();
            txt.append(LINE_BREAK).append(reasonDesc).append(" : ").append(LINE_BREAK);
            formTab = (Hashtable)this.rejectPerReasonPerformTable.get(reasonDesc);
            Enumeration formKeys = formTab.keys();
            while (formKeys.hasMoreElements()) {
                formNumber = (String)formKeys.nextElement();
                txt.append(formNumber).append(" = ").append(((Integer)formTab.get(formNumber)).toString()).append(LINE_BREAK);
            }
        }
        return txt.toString();
    }

    public Hashtable getCountPerFormTable() {
        return this.countPerFormTable;
    }

    public void setCountPerFormTable(Hashtable countPerFormTable) {
        this.countPerFormTable = countPerFormTable;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getNumberCancelled() {
        return this.numberCancelled;
    }

    public void setNumberCancelled(int numberCancelled) {
        this.numberCancelled = numberCancelled;
    }

    public int getNumberRejected() {
        return this.numberRejected;
    }

    public void setNumberRejected(int numberRejected) {
        this.numberRejected = numberRejected;
    }

    public synchronized void incrementNumberRejected() {
        ++this.numberRejected;
    }

    public int getNumberSent() {
        return this.numberSent;
    }

    public void setNumberSent(int numberSent) {
        this.numberSent = numberSent;
    }

    public synchronized void incrementNumberSent() {
        ++this.numberSent;
    }

    public Hashtable getRejectPerReasonPerFormTable() {
        return this.rejectPerReasonPerformTable;
    }

    public void setRejectPerReasonPerformTable(Hashtable rejectPerReasonPerformTable) {
        this.rejectPerReasonPerformTable = rejectPerReasonPerformTable;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public int getNumberRemailed() {
        return this.numberRemailed;
    }

    public void setNumberRemailed(int numberRemailed) {
        this.numberRemailed = numberRemailed;
    }

    public int getNumberWithException() {
        return this.numberWithException;
    }

    public void setNumberWithException(int numberWithException) {
        this.numberWithException = numberWithException;
    }

    public synchronized void incrementNumberWithException() {
        ++this.numberWithException;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    private boolean isIVMFinalLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_400.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_450.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_451.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_452.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_453.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_454.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_455.getCode());
    }

    private boolean isCompassionLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_683A.getCode());
    }
}

