/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.comms.CmsErrorFileEntry;
import gov.va.med.esr.common.model.comms.CmsMailedFileEntry;
import gov.va.med.esr.common.model.comms.CmsRejectFileEntry;
import gov.va.med.esr.common.model.comms.CmsReturnedByUSPSFileEntry;
import gov.va.med.esr.common.model.comms.CommsImportStatistics;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTransByFormNumber;
import gov.va.med.esr.common.model.comms.CommsTransLog;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.CommsTransLogDAO;
import gov.va.med.esr.common.persistent.comms.hibernate.ImportFileDAOImpl;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class CmsImportProcess
extends AbstractRuleAwareServiceImpl {
    private static final String IMPORT_TRANS_REJECT_TYPE_CODE = "COMREJ-E";
    private static final String IMPORT_TRANS_ERROR_TYPE_CODE = "COMERR-E";
    private static final String IMPORT_TRANS_MAILED_TYPE_CODE = "COMADD-E";
    private static MessageType IMPORT_TRANSMISSION_REJECT_TYPE = null;
    private static MessageType IMPORT_TRANSMISSION_ERROR_TYPE = null;
    private static MessageType IMPORT_TRANSMISSION_MAILED_TYPE = null;
    private static ComMailingStatusType REJECT_BY_CMS_STATUS = null;
    private static ComMailingStatusType ERROR_BY_CMS_STATUS = null;
    private static ComMailingStatusType MAILED_BY_CMS_STATUS = null;
    private static ComMailingStatusType RETURNED_BY_POST_OFFICE_STATUS = null;
    private static final String REMAILED_INDICATOR = "REMAILED";
    private static final String ERROR_REASONS_SEPERATOR = "^";
    private LookupService lookupService = null;
    private CommsTransLogDAO transDAO = null;
    private CommsLogEntryDAO commsLogDAO = null;
    private ImportFileDAOImpl fileDAO = null;
    private CommsLogService commsLogService;

    private void init() throws ServiceException {
        if (this.lookupService == null) {
            this.lookupService = (LookupService)this.getComponent("lookupService");
            IMPORT_TRANSMISSION_REJECT_TYPE = this.lookupService.getMessageTypeByCode(IMPORT_TRANS_REJECT_TYPE_CODE);
            IMPORT_TRANSMISSION_ERROR_TYPE = this.lookupService.getMessageTypeByCode(IMPORT_TRANS_ERROR_TYPE_CODE);
            IMPORT_TRANSMISSION_MAILED_TYPE = this.lookupService.getMessageTypeByCode(IMPORT_TRANS_MAILED_TYPE_CODE);
            REJECT_BY_CMS_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.REJECT_BY_CMS.getCode());
            ERROR_BY_CMS_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.ERROR_BY_CMS.getCode());
            MAILED_BY_CMS_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.MAILED_BY_CMS.getCode());
            RETURNED_BY_POST_OFFICE_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.RETURN_BY_POST_OFFICE.getCode());
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.commsLogDAO, (String)"A Comms Log Entry DAO must be configured");
        Validate.notNull((Object)this.transDAO, (String)"An Comms Transmission Log DAO must be configured");
        Validate.notNull((Object)this.fileDAO, (String)"An Comms Import File DAO must be configured");
        Validate.notNull((Object)this.commsLogService, (String)"commsLogService is required");
    }

    public CommsImportStatistics execute(String[] args) throws Exception {
        this.init();
        CommsImportStatistics stat = new CommsImportStatistics();
        stat.setProcessStartTime(new Date());
        stat.setErrorFileProcessStartTime(new Date());
        try {
            this.processCmsErrorFile(stat);
        }
        catch (Exception ex1) {
            this.logger.error((Object)"Failed to process CMS import error file", (Throwable)ex1);
        }
        stat.setErrorFileProcessEndTime(new Date());
        stat.setRejectFileProcessStartTime(new Date());
        try {
            this.processCmsRejectFile(stat);
        }
        catch (Exception ex2) {
            this.logger.error((Object)"Failed to process CMS import rejected file", (Throwable)ex2);
        }
        stat.setRejectFileProcessEndTime(new Date());
        stat.setMailedFileProcessStartTime(new Date());
        try {
            this.processCmsMailedFile(stat);
        }
        catch (Exception ex3) {
            this.logger.error((Object)"Failed to process CMS import mailed file", (Throwable)ex3);
        }
        stat.setMailedFileProcessEndTime(new Date());
        try {
            this.processCmsReturnedMailFile(stat);
        }
        catch (Exception ex3) {
            this.logger.error((Object)"Failed to process CMS returned mail file", (Throwable)ex3);
        }
        stat.setProcessEndTime(new Date());
        try {
            this.updateCommsTransLog(stat);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to update comms trans log");
        }
        return stat;
    }

    public CommsLogEntryDAO getCommsLogDAO() {
        return this.commsLogDAO;
    }

    public void setCommsLogDAO(CommsLogEntryDAO commsLogDAO) {
        this.commsLogDAO = commsLogDAO;
    }

    public ImportFileDAOImpl getFileDAO() {
        return this.fileDAO;
    }

    public void setFileDAO(ImportFileDAOImpl fileDAO) {
        this.fileDAO = fileDAO;
    }

    public CommsTransLogDAO getTransDAO() {
        return this.transDAO;
    }

    public void setTransDAO(CommsTransLogDAO transDAO) {
        this.transDAO = transDAO;
    }

    private PersonChangeLogEntry createPersonChangeLogEntry(CommsLogEntry cle) {
        PersonChangeLogEntry p = new PersonChangeLogEntry();
        p.setPersonEntityKey(cle.getPersonIdEntityKey());
        p.setSubmitterDescription("UI");
        return p;
    }

    private void processCmsMailedFile(CommsImportStatistics stat) throws Exception {
        ArrayList cmsMailedFileList = this.fileDAO.readCmsMailedFile(stat);
        if (cmsMailedFileList == null || cmsMailedFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        CmsMailedFileEntry entry = null;
        for (int i = 0; i < cmsMailedFileList.size(); ++i) {
            entry = (CmsMailedFileEntry)cmsMailedFileList.get(i);
            EntityKey key = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(entry.getCommunicationId()), CommsLogEntry.class);
            log = (CommsLogEntry)((Object)this.commsLogDAO.getByKey(key));
            if (log != null) {
                try {
                    log.setSentToIVM(Boolean.TRUE);
                    log.addMailingStatus(MAILED_BY_CMS_STATUS);
                    log.setMailingDate(entry.getMailedDate());
                    if (log.getRemailIndicator() != null) {
                        log.setRemailIndicator(REMAILED_INDICATOR);
                    }
                    this.commsLogDAO.update(log);
                    stat.updateCmsMailedStatistics(entry);
                    changeLogs.clear();
                    changeLogs.add(this.createPersonChangeLogEntry(log));
                    this.getPersonService().logChanges(changeLogs);
                    stat.incrementMailedFileProcessedCount();
                }
                catch (Exception ex) {
                    stat.incrementMailedFileFailedCount();
                    this.logger.error((Object)("Failed to process mailed file entry id = " + log.getCommsLogIdString()), (Throwable)ex);
                }
                continue;
            }
            stat.incrementMailedFileFailedCount();
        }
    }

    private void processCmsErrorFile(CommsImportStatistics stat) throws Exception {
        ArrayList cmsErrorFileList = this.fileDAO.readCmsErrorFile(stat);
        if (cmsErrorFileList == null || cmsErrorFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        CmsErrorFileEntry entry = null;
        for (int i = 0; i < cmsErrorFileList.size(); ++i) {
            try {
                entry = (CmsErrorFileEntry)cmsErrorFileList.get(i);
                EntityKey key = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(entry.getCommunicationId()), CommsLogEntry.class);
                log = (CommsLogEntry)((Object)this.commsLogDAO.getByKey(key));
                if (log != null) {
                    log.setSentToIVM(Boolean.TRUE);
                    log.addMailingStatus(ERROR_BY_CMS_STATUS);
                    log.addAacErrorReason(this.lookupService.getComAACErrorTypeByCode(entry.getErrorCode()));
                    stat.updateCmsErrorStatistics(entry, true);
                    changeLogs.clear();
                    changeLogs.add(this.createPersonChangeLogEntry(log));
                    this.getPersonService().logChanges(changeLogs);
                    stat.incrementErrorFileProcessedCount();
                    this.commsLogDAO.update(log);
                    continue;
                }
                stat.incrementErrorFileFailedCount();
                continue;
            }
            catch (Exception ex) {
                stat.incrementErrorFileFailedCount();
                this.logger.error((Object)("Failed to log cms error file entry id = " + entry != null ? entry.getCommunicationId() : null), (Throwable)ex);
            }
        }
    }

    private void processCmsRejectFile(CommsImportStatistics stat) throws Exception {
        ArrayList cmsRejectFileList = this.fileDAO.readCmsRejectFile(stat);
        if (cmsRejectFileList == null || cmsRejectFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        CmsRejectFileEntry entry = null;
        for (int i = 0; i < cmsRejectFileList.size(); ++i) {
            entry = (CmsRejectFileEntry)cmsRejectFileList.get(i);
            EntityKey key = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(entry.getCommunicationId()), CommsLogEntry.class);
            log = (CommsLogEntry)((Object)this.commsLogDAO.getByKey(key));
            if (log != null) {
                try {
                    log.setSentToIVM(Boolean.TRUE);
                    log.addMailingStatus(REJECT_BY_CMS_STATUS);
                    log.setCode1RejectReason(this.lookupService.getComAACRejectReasonTypeByCode(entry.getCode1Reject()));
                    this.commsLogDAO.update(log);
                    stat.updateCmsRejectStatistics(entry);
                    changeLogs.clear();
                    changeLogs.add(this.createPersonChangeLogEntry(log));
                    this.getPersonService().logChanges(changeLogs);
                    stat.incrementRejectFileProcessedCount();
                }
                catch (Exception ex) {
                    stat.incrementRejectFileFailedCount();
                    this.logger.error((Object)("Failed to update comms log status id = " + log.getCommsLogIdString()), (Throwable)ex);
                }
                continue;
            }
            stat.incrementRejectFileFailedCount();
        }
    }

    private void processCmsReturnedMailFile(CommsImportStatistics stat) throws Exception {
        ArrayList cmsReturnedFileList = this.fileDAO.readCmsReturnedMailFile(stat);
        if (cmsReturnedFileList == null || cmsReturnedFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        CmsReturnedByUSPSFileEntry entry = null;
        for (int i = 0; i < cmsReturnedFileList.size(); ++i) {
            entry = (CmsReturnedByUSPSFileEntry)cmsReturnedFileList.get(i);
            EntityKey key = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(entry.getCommunicationId()), CommsLogEntry.class);
            log = (CommsLogEntry)((Object)this.commsLogDAO.getByKey(key));
            if (log != null) {
                try {
                    log.setSentToIVM(Boolean.TRUE);
                    log.addMailingStatus(RETURNED_BY_POST_OFFICE_STATUS);
                    this.commsLogDAO.update(log);
                    stat.incrementReturnedMailFileProcessedCount();
                    changeLogs.clear();
                    changeLogs.add(this.createPersonChangeLogEntry(log));
                    this.getPersonService().logChanges(changeLogs);
                }
                catch (Exception ex) {
                    stat.incrementRejectFileFailedCount();
                    this.logger.error((Object)("Failed to update comms log status id = " + log.getCommsLogIdString()), (Throwable)ex);
                }
                continue;
            }
            stat.incrementRejectFileFailedCount();
        }
    }

    private void updateCommsTransLog(CommsImportStatistics stat) throws DAOException {
        if (stat == null) {
            return;
        }
        CommsTransLog errLog = new CommsTransLog();
        errLog.setTransmissionType(IMPORT_TRANSMISSION_ERROR_TYPE);
        errLog.setFileName(stat.getErrorFileName());
        errLog.setFileProcessStartDate(stat.getErrorFileProcessStartTime());
        errLog.setFileProcessEndDate(stat.getErrorFileProcessEndTime());
        errLog.setFileReceivedDate(stat.getErrorFileReceivedDate());
        errLog.setFileRecordCount(new Integer(stat.getErrorFileRecordCount()));
        this.updateErrorByFormNumber(errLog, stat);
        CommsTransLog rejLog = new CommsTransLog();
        rejLog.setTransmissionType(IMPORT_TRANSMISSION_REJECT_TYPE);
        rejLog.setFileName(stat.getRejectFileName());
        rejLog.setFileProcessStartDate(stat.getRejectFileProcessStartTime());
        rejLog.setFileProcessEndDate(stat.getRejectFileProcessEndTime());
        rejLog.setFileReceivedDate(stat.getRejectFileReceivedDate());
        rejLog.setFileRecordCount(new Integer(stat.getRejectFileRecordCount()));
        this.updateRejectByFormNumber(rejLog, stat);
        CommsTransLog mailedLog = new CommsTransLog();
        mailedLog.setTransmissionType(IMPORT_TRANSMISSION_MAILED_TYPE);
        mailedLog.setFileName(stat.getMailedFileName());
        mailedLog.setFileProcessStartDate(stat.getMailedFileProcessStartTime());
        mailedLog.setFileProcessEndDate(stat.getMailedFileProcessEndTime());
        mailedLog.setFileReceivedDate(stat.getMailedFileReceivedDate());
        mailedLog.setFileRecordCount(new Integer(stat.getMailedFileRecordCount()));
        this.updateMailedByFormNumber(mailedLog, stat);
    }

    private void updateErrorByFormNumber(CommsTransLog errLog, CommsImportStatistics stat) {
        if (errLog == null || stat == null || stat.getErrorPerTypeNumberTable() == null) {
            return;
        }
        String formNumber = null;
        Hashtable errorReasonPerLetterTypeTable = null;
        CommsTransByFormNumber transByForm = null;
        Hashtable errorPerTypeNumberTable = stat.getErrorPerTypeNumberTable();
        Enumeration enumer = errorPerTypeNumberTable.keys();
        while (enumer.hasMoreElements()) {
            transByForm = new CommsTransByFormNumber();
            formNumber = (String)enumer.nextElement();
            transByForm.setFormNumber(formNumber);
            transByForm.setFormNumberRecordCount((Integer)errorPerTypeNumberTable.get(formNumber));
            errorReasonPerLetterTypeTable = stat.getErrorReasonPerLetterTypeTable();
            if (errorReasonPerLetterTypeTable != null) {
                transByForm.setFormNumberErrorReasons(this.getFormNumberErrorReasons((Set)errorReasonPerLetterTypeTable.get(formNumber)));
            }
            errLog.addTransByFormNumber(transByForm);
        }
    }

    private String getFormNumberErrorReasons(Set errorReasons) {
        if (errorReasons == null || errorReasons.isEmpty()) {
            return null;
        }
        Iterator it = errorReasons.iterator();
        StringBuffer str = new StringBuffer();
        while (it.hasNext()) {
            str.append(it.next()).append(ERROR_REASONS_SEPERATOR);
        }
        return str.substring(0, str.length() - 1);
    }

    private void updateRejectByFormNumber(CommsTransLog rejLog, CommsImportStatistics stat) {
        if (rejLog == null || stat == null) {
            return;
        }
        String formNumber = null;
        Hashtable rejectReasonPerLetterTypeTable = null;
        CommsTransByFormNumber transByForm = null;
        Hashtable rejectPerTypeNumberTable = stat.getRejectPerTypeNumberTable();
        Enumeration enumer = rejectPerTypeNumberTable.keys();
        while (enumer.hasMoreElements()) {
            transByForm = new CommsTransByFormNumber();
            formNumber = (String)enumer.nextElement();
            transByForm.setFormNumber(formNumber);
            transByForm.setFormNumberRecordCount((Integer)rejectPerTypeNumberTable.get(formNumber));
            rejectReasonPerLetterTypeTable = stat.getRejectReasonPerLetterTypeTable();
            if (rejectReasonPerLetterTypeTable != null) {
                transByForm.setFormNumberRejectReasons(this.getFormNumberRejectReasons((Set)rejectReasonPerLetterTypeTable.get(formNumber)));
            }
            rejLog.addTransByFormNumber(transByForm);
        }
    }

    private String getFormNumberRejectReasons(Set rejectReasons) {
        if (rejectReasons == null || rejectReasons.isEmpty()) {
            return null;
        }
        Iterator it = rejectReasons.iterator();
        StringBuffer str = new StringBuffer();
        while (it.hasNext()) {
            str.append(it.next()).append(ERROR_REASONS_SEPERATOR);
        }
        return str.substring(0, str.length() - 1);
    }

    private void updateMailedByFormNumber(CommsTransLog mailedLog, CommsImportStatistics stat) {
        if (mailedLog == null || stat == null) {
            return;
        }
        String formNumber = null;
        CommsTransByFormNumber transByForm = null;
        Hashtable mailedPerTypeNumberTable = stat.getMailedPerTypeNumberTable();
        Enumeration enumer = mailedPerTypeNumberTable.keys();
        while (enumer.hasMoreElements()) {
            transByForm = new CommsTransByFormNumber();
            formNumber = (String)enumer.nextElement();
            transByForm.setFormNumber(formNumber);
            transByForm.setFormNumberRecordCount((Integer)mailedPerTypeNumberTable.get(formNumber));
            mailedLog.addTransByFormNumber(transByForm);
        }
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }
}

