/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatisticsHandler;
import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class CheckUnprocessedVBAQueryRecords
extends AbstractDataQueryIncrementalProcess {
    private CommsEmailBulletinService bulletinService;
    private ProcessStatisticsHandler processStatisticsHandler;
    private StringBuffer emailTextBuffer;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        block11: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getProcessName() + ": Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
            }
            if (acquiredData == null) {
                return;
            }
            this.emailTextBuffer = new StringBuffer();
            for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
                block10: {
                    Object[] row = (Object[])acquiredData.get(i);
                    BigDecimal personId = (BigDecimal)row[0];
                    PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(personId);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
                    }
                    try {
                        this.processRecord(key, row);
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    }
                    catch (Exception ex) {
                        context.getProcessStatistics().incrementNumberOfErrorRecords();
                        String errMsg = "Error while executing " + this.getProcessName() + " for person " + personId;
                        context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                        if (!this.logger.isWarnEnabled()) break block10;
                        this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                    }
                }
                if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
                this.updateJobResult((DataProcessExecutionContext)context);
            }
            if (context.getProcessStatistics() != null && context.getProcessStatistics().getNumberOfTotalRecords() > 0) {
                try {
                    this.sendEmailNotification(context);
                }
                catch (Exception ex) {
                    String errMsg = "Error sending bulletin notification for Unprocessed VBA Queries";
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block11;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    protected void processRecord(PersonEntityKey key, Object[] dataRow) throws Exception {
        BigDecimal personId = (BigDecimal)dataRow[0];
        BigDecimal HL7_LOG_id = (BigDecimal)dataRow[1];
        this.emailTextBuffer.append("\n");
        this.emailTextBuffer.append(personId.toString());
        this.emailTextBuffer.append("|");
        this.emailTextBuffer.append(HL7_LOG_id.toString());
    }

    private void sendEmailNotification(DataQueryProcessExecutionContext context) throws ServiceException {
        this.processStatisticsHandler = this.getProcessStatisticsHandler();
        try {
            if (this.processStatisticsHandler != null) {
                JobConfig config = this.getBatchProcessService().getJobConfig(this.getJobName((DataProcessExecutionContext)context), this.getJobGroupName((DataProcessExecutionContext)context));
                String subject = "List of UNprocessed VBA Queries";
                if (config != null && StringUtils.isNotBlank((String)config.getEmailDistributionList())) {
                    List emailList = config.getEmailsAsList();
                    this.bulletinService.sendSimpleMailMessage(null, emailList.toArray(new String[0]), null, subject, this.emailTextBuffer.toString());
                    this.logger.info((Object)("CheckUnprocessedVBAQueryRecords batch job - email of unprocessed list was sent to " + config.getEmailDistributionList() + "\n"));
                } else {
                    ArrayList<String> defaultEmailList = new ArrayList<String>();
                    defaultEmailList.add("Corrie.Kittles@va.gov");
                    this.processStatisticsHandler.processStatisticsWithDynamicRecipients(context.getProcessStatistics(), defaultEmailList);
                    this.logger.info((Object)"CheckUnprocessedVBAQueryRecords batch job - email of total unprocessed count was sent to corrie.kittles@va.gov\n");
                    this.bulletinService.sendSimpleMailMessage(null, defaultEmailList.toArray(new String[0]), null, subject, this.emailTextBuffer.toString());
                    this.logger.info((Object)"CheckUnprocessedVBAQueryRecords batch job - email of unprocessed list was sent to corrie.kittles@va.gov\n");
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"CheckUnprocessedVBAQueryRecords - ERROR send email of UNprocessed VBA queries ", (Throwable)ex);
        }
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.bulletinService);
    }
}

