/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.AppointmentConversionResult;
import gov.va.med.esr.common.batchprocess.AppointmentConversionStatistics;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.Validate;

public class AppointmentConversionProcess
extends AbstractDataQueryIncrementalProcess {
    private PersonService personService;
    private String totalCountQueryName = null;
    private CommsEmailBulletinService commsEmailBulletinService = null;
    protected static final String CURRENT_RECORDS_PROCESSED = "totalRecordsProcessed";
    private static final String JNAME = "Job-AppointmentConversionProcess";
    private static final String JGROUP = "DEFAULT";
    private static final String PREFIX_MAX_NUMBER_TO_CONVERT = "-size=";
    private static final String MAX_RECORDS_QUERIED = "maxRecordsQueries";
    protected static final String TOTAL_QUERY_COUNT = "totalQueryCount";

    public boolean continueScrolling(QueryIncrementTracker tracker) {
        DataQueryProcessExecutionContext context = (DataQueryProcessExecutionContext)tracker;
        if (context.getContextData().containsKey(MAX_RECORDS_QUERIED)) {
            Integer maxTotalCount = (Integer)context.getContextData().get(MAX_RECORDS_QUERIED);
            Integer currentRecordsProcessed = (Integer)context.getContextData().get(CURRENT_RECORDS_PROCESSED);
            if (currentRecordsProcessed != null && maxTotalCount <= currentRecordsProcessed) {
                return false;
            }
        }
        return !this.isInterrupted((DataProcessExecutionContext)tracker);
    }

    protected ProcessStatistics createProcessStatistics() {
        return new AppointmentConversionStatistics();
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Appointment Data Conversion batch process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        try {
            acquiredData = this.checkAgainstMax(context, acquiredData);
        }
        catch (Exception e) {
            super.throwIllegalStateException("Failed to process", (Throwable)e);
        }
        if (acquiredData == null) {
            return;
        }
        Integer currentRecordsProcessed = (Integer)context.getContextData().get(CURRENT_RECORDS_PROCESSED);
        currentRecordsProcessed = currentRecordsProcessed == null ? new Integer(acquiredData.size()) : new Integer(currentRecordsProcessed + acquiredData.size());
        context.getContextData().put(CURRENT_RECORDS_PROCESSED, currentRecordsProcessed);
        AppointmentConversionStatistics stats = (AppointmentConversionStatistics)context.getProcessStatistics();
        for (int i = 0; i < acquiredData.size(); ++i) {
            BigDecimal personId = (BigDecimal)((Object[])acquiredData.get(i))[0];
            try {
                PersonIdEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey(personId.toString());
                AppointmentConversionResult result = this.getPersonService().processAppointmentConversion(key);
                stats.incrementNumberOfSuccessfulRecords();
                stats.incrementNumberWithCancelledDeclinedStatus(result.getNumberWithCancelledDeclinedStatus());
                stats.incrementNumberWithRejectedEnrollmentStatus(result.getNumberWithRejectedEnrollmentStatus());
                continue;
            }
            catch (ServiceException ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Error while executing Appointment conversion process for person " + personId;
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"AppointmentConversionProcess: Processing complete.");
            this.logger.debug((Object)("AppointmentConversionProcess: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("AppointmentConversionProcess: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block2: {
            AppointmentConversionStatistics stats = (AppointmentConversionStatistics)context.getProcessStatistics();
            try {
                this.sendEmailNotification(stats);
            }
            catch (ServiceException ex) {
                String errMsg = "Error sending bulletin notification for appointment conversion";
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
        }
        super.handleDataProcessCompleted(context);
    }

    private int getRemainingCount() throws ServiceException {
        try {
            Number num = this.getTotalCount();
            return num != null ? num.intValue() : 0;
        }
        catch (Exception ex) {
            String errMsg = "Error getting total count for appointment conversion. Reason: " + ex.getMessage();
            throw new ServiceException(errMsg, (Throwable)ex);
        }
    }

    private void sendEmailNotification(AppointmentConversionStatistics stats) throws ServiceException {
        Hashtable<String, String> dataTab = new Hashtable<String, String>();
        int totalCancel = 0;
        int totalRejects = 0;
        totalCancel += stats.getNumberWithCancelledDeclinedStatus();
        totalRejects += stats.getNumberWithRejectedEnrollmentStatus();
        List results = this.getBatchProcessService().getFinishedJobResults(JNAME, JGROUP);
        for (JobResult result : results) {
            String str = result.getStatistics();
            AppointmentConversionStatistics statistics = new AppointmentConversionStatistics();
            try {
                statistics.importFromCSV(str);
                totalCancel += statistics.getNumberWithCancelledDeclinedStatus();
                totalRejects += statistics.getNumberWithRejectedEnrollmentStatus();
            }
            catch (Exception ex) {
                String errMsg = "Error collecting statistics for appointment conversion. Reason: " + ex.getMessage();
                throw new ServiceException(errMsg, (Throwable)ex);
            }
        }
        dataTab.put("canceldeclineCount", totalCancel + "");
        dataTab.put("rejectedCount", totalRejects + "");
        CommsEmailBulletinService emailSrv = this.getCommsEmailBulletinService();
        emailSrv.sendEmailBulletin(BulletinTrigger.DataType.HEC_NOTIFY_APPLICATION_CONVERSION_COMPLETE, dataTab, null);
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        Object args = context.getExecutionArguments();
        String singleArg = (String)args;
        if (args != null && singleArg.startsWith(PREFIX_MAX_NUMBER_TO_CONVERT)) {
            String maxNumberToConvert = singleArg.substring(PREFIX_MAX_NUMBER_TO_CONVERT.length());
            if (maxNumberToConvert == null || maxNumberToConvert.length() == 0) {
                return null;
            }
            Integer maxNumber = new Integer(maxNumberToConvert);
            if (maxNumber <= 0) {
                return null;
            }
            context.getContextData().put(MAX_RECORDS_QUERIED, maxNumber);
            return super.doAcquireData(context);
        }
        return super.doAcquireData(context);
    }

    private List checkAgainstMax(DataQueryProcessExecutionContext context, List acquiredData) throws Exception {
        if (!context.getContextData().containsKey(MAX_RECORDS_QUERIED)) {
            return acquiredData;
        }
        int realizedTotalCount = (Integer)context.getContextData().get(MAX_RECORDS_QUERIED);
        int currentRecordsQueried = 0;
        if (context.getContextData().containsKey(CURRENT_RECORDS_PROCESSED)) {
            currentRecordsQueried = (Integer)context.getContextData().get(CURRENT_RECORDS_PROCESSED);
        }
        if (currentRecordsQueried >= realizedTotalCount) {
            return null;
        }
        if (currentRecordsQueried + acquiredData.size() > realizedTotalCount) {
            int lastIndex;
            int totalToRemove = currentRecordsQueried + acquiredData.size() - realizedTotalCount;
            for (int i = lastIndex = acquiredData.size() - 1; i > lastIndex - totalToRemove; --i) {
                acquiredData.remove(i);
            }
        }
        return acquiredData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getTotalCount(DataQueryProcessExecutionContext context) throws Exception {
        Number count = null;
        DataQueryProcessExecutionContext dataQueryProcessExecutionContext = context;
        synchronized (dataQueryProcessExecutionContext) {
            count = (Number)context.getContextData().get(TOTAL_QUERY_COUNT);
            if (count == null) {
                count = this.getTotalCount();
                context.getContextData().put(TOTAL_QUERY_COUNT, count);
            }
        }
        return count.intValue();
    }

    private Number getTotalCount() throws Exception {
        return (Number)this.getDao().find(this.totalCountQueryName).get(0);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"A PersonService is needed");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CommsEmailBulletinService getCommsEmailBulletinService() {
        return this.commsEmailBulletinService;
    }

    public void setCommsEmailBulletinService(CommsEmailBulletinService commsEmailBulletinService) {
        this.commsEmailBulletinService = commsEmailBulletinService;
    }

    public String getTotalCountQueryName() {
        return this.totalCountQueryName;
    }

    public void setTotalCountQueryName(String totalCountQueryName) {
        this.totalCountQueryName = totalCountQueryName;
    }
}

