/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ActivateFutureMeansTestProcess
extends AbstractDataQueryProcess {
    private FinancialsService financialsService = null;

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ActivateFutureMeansTestProcess: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            PersonIdEntityKey personKey = null;
            Integer incomeYear = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing record # " + (i + 1) + ":: person id = " + personKey + " incomeYear = " + incomeYear));
            }
            try {
                Object[] args = (Object[])acquiredData.get(i);
                personKey = CommonEntityKeyFactory.createPersonIdEntityKey(args[0].toString());
                incomeYear = (Integer)args[1];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing record # " + (i + 1) + ":: person id = " + personKey + " incomeYear = " + incomeYear));
                }
                this.financialsService.processFutureDatedTestFlag(personKey, incomeYear);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Error while executing ActivateFutureMeansTestProcess batch process for person id = " + personKey + " incomeYear = " + incomeYear;
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"ActivateFutureMeansTestProcess: Processing complete.");
            this.logger.debug((Object)("ActivateFutureMeansTestProcess: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("ActivateFutureMeansTestProcess: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public FinancialsService getFinancialsService() {
        return this.financialsService;
    }

    public void setFinancialsService(FinancialsService financialsService) {
        this.financialsService = financialsService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.financialsService, (String)"A FinancialsService is needed");
    }
}

