/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.comms.CommsImportStatistics;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTransByFormNumber;
import gov.va.med.esr.common.model.comms.CommsTransLog;
import gov.va.med.esr.common.model.comms.ErrorFileEntry;
import gov.va.med.esr.common.model.comms.MailedFileEntry;
import gov.va.med.esr.common.model.comms.RejectFileEntry;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.CommsTransLogDAO;
import gov.va.med.esr.common.persistent.comms.hibernate.ImportFileDAOImpl;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class AacImportProcess
extends AbstractRuleAwareServiceImpl {
    private static final String IMPORT_TRANS_REJECT_TYPE_CODE = "COMREJ-E";
    private static final String IMPORT_TRANS_ERROR_TYPE_CODE = "COMERR-E";
    private static final String IMPORT_TRANS_MAILED_TYPE_CODE = "COMADD-E";
    private static MessageType IMPORT_TRANSMISSION_REJECT_TYPE = null;
    private static MessageType IMPORT_TRANSMISSION_ERROR_TYPE = null;
    private static MessageType IMPORT_TRANSMISSION_MAILED_TYPE = null;
    private static ComMailingStatusType REJECT_BY_AAC_STATUS = null;
    private static ComMailingStatusType ERROR_BY_AAC_STATUS = null;
    private static ComMailingStatusType MAILED_BY_AAC_STATUS = null;
    private static final String REMAILED_INDICATOR = "REMAILED";
    private static final String ERROR_REASONS_SEPERATOR = "^";
    private LookupService lookupService = null;
    private CommsTransLogDAO transDAO = null;
    private CommsLogEntryDAO commsLogDAO = null;
    private ImportFileDAOImpl fileDAO = null;
    private CommsLogService commsLogService;

    private void init() throws ServiceException {
        if (this.lookupService == null) {
            this.lookupService = (LookupService)this.getComponent("lookupService");
            IMPORT_TRANSMISSION_REJECT_TYPE = this.lookupService.getMessageTypeByCode(IMPORT_TRANS_REJECT_TYPE_CODE);
            IMPORT_TRANSMISSION_ERROR_TYPE = this.lookupService.getMessageTypeByCode(IMPORT_TRANS_ERROR_TYPE_CODE);
            IMPORT_TRANSMISSION_MAILED_TYPE = this.lookupService.getMessageTypeByCode(IMPORT_TRANS_MAILED_TYPE_CODE);
            REJECT_BY_AAC_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.REJECT_BY_AAC.getCode());
            ERROR_BY_AAC_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.ERROR_BY_AAC.getCode());
            MAILED_BY_AAC_STATUS = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.MAILED_BY_AAC.getCode());
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.commsLogDAO, (String)"A Comms Log Entry DAO must be configured");
        Validate.notNull((Object)this.transDAO, (String)"An Comms Transmission Log DAO must be configured");
        Validate.notNull((Object)this.fileDAO, (String)"An Comms Import File DAO must be configured");
        Validate.notNull((Object)this.commsLogService, (String)"commsLogService is required");
    }

    public CommsImportStatistics execute(String[] args) throws Exception {
        this.init();
        CommsImportStatistics stat = new CommsImportStatistics();
        stat.setProcessStartTime(new Date());
        stat.setErrorFileProcessStartTime(new Date());
        try {
            this.processErrorFile(stat);
        }
        catch (Exception ex1) {
            this.logger.error((Object)"Failed to process Aac import error file", (Throwable)ex1);
        }
        stat.setErrorFileProcessEndTime(new Date());
        stat.setRejectFileProcessStartTime(new Date());
        try {
            this.processRejectFile(stat);
        }
        catch (Exception ex2) {
            this.logger.error((Object)"Failed to process Aac import rejected file", (Throwable)ex2);
        }
        stat.setRejectFileProcessEndTime(new Date());
        stat.setMailedFileProcessStartTime(new Date());
        try {
            this.processMailedFile(stat);
        }
        catch (Exception ex3) {
            this.logger.error((Object)"Failed to process Aac import mailed file", (Throwable)ex3);
        }
        stat.setMailedFileProcessEndTime(new Date());
        stat.setProcessEndTime(new Date());
        try {
            this.updateCommsTransLog(stat);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to update comms trans log");
        }
        return stat;
    }

    public CommsLogEntryDAO getCommsLogDAO() {
        return this.commsLogDAO;
    }

    public void setCommsLogDAO(CommsLogEntryDAO commsLogDAO) {
        this.commsLogDAO = commsLogDAO;
    }

    public ImportFileDAOImpl getFileDAO() {
        return this.fileDAO;
    }

    public void setFileDAO(ImportFileDAOImpl fileDAO) {
        this.fileDAO = fileDAO;
    }

    public CommsTransLogDAO getTransDAO() {
        return this.transDAO;
    }

    public void setTransDAO(CommsTransLogDAO transDAO) {
        this.transDAO = transDAO;
    }

    private PersonChangeLogEntry createPersonChangeLogEntry(CommsLogEntry cle) {
        PersonChangeLogEntry p = new PersonChangeLogEntry();
        p.setPersonEntityKey(cle.getPersonIdEntityKey());
        p.setSubmitterDescription("UI");
        return p;
    }

    private void processErrorFile(CommsImportStatistics stat) throws Exception {
        ArrayList errorFileList = this.fileDAO.readErrorFile(stat);
        if (errorFileList == null || errorFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        ErrorFileEntry entry = null;
        String prevBarcode = null;
        String currBarcode = null;
        for (int i = 0; i < errorFileList.size(); ++i) {
            try {
                entry = (ErrorFileEntry)errorFileList.get(i);
                currBarcode = entry.getBarCode();
                if (i == 0 || !prevBarcode.equals(currBarcode)) {
                    log = this.commsLogDAO.findCommsLogEntryByBarcode(currBarcode);
                    if (log != null) {
                        log.addMailingStatus(ERROR_BY_AAC_STATUS);
                        log.addAacErrorReason(this.lookupService.getComAACErrorTypeByCode(entry.getErrorCode()));
                        stat.updateErrorStatistics(entry, true);
                        changeLogs.clear();
                        changeLogs.add(this.createPersonChangeLogEntry(log));
                        this.getPersonService().logChanges(changeLogs);
                        stat.incrementErrorFileProcessedCount();
                    } else {
                        stat.incrementErrorFileFailedCount();
                    }
                } else if (log != null) {
                    log.addAacErrorReason(this.lookupService.getComAACErrorTypeByCode(entry.getErrorCode()));
                    stat.updateErrorStatistics(entry, false);
                    stat.incrementErrorFileProcessedCount();
                } else {
                    stat.incrementErrorFileFailedCount();
                }
                prevBarcode = currBarcode;
                if (log == null) continue;
                this.commsLogDAO.update(log);
                continue;
            }
            catch (Exception ex) {
                stat.incrementErrorFileFailedCount();
                this.logger.error((Object)("Failed to log error file entry bar code = " + currBarcode), (Throwable)ex);
            }
        }
    }

    private void processRejectFile(CommsImportStatistics stat) throws Exception {
        ArrayList rejectFileList = this.fileDAO.readRejectFile(stat);
        if (rejectFileList == null || rejectFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        RejectFileEntry entry = null;
        for (int i = 0; i < rejectFileList.size(); ++i) {
            entry = (RejectFileEntry)rejectFileList.get(i);
            log = this.commsLogDAO.findCommsLogEntryByBarcode(entry.getBarCode());
            if (log != null) {
                try {
                    log.addMailingStatus(REJECT_BY_AAC_STATUS);
                    log.setCode1RejectReason(this.lookupService.getComAACRejectReasonTypeByCode(entry.getCode1Reject()));
                    this.commsLogDAO.update(log);
                    this.commsLogService.handleMailingResponses(log);
                    stat.updateRejectStatistics(entry);
                    changeLogs.clear();
                    changeLogs.add(this.createPersonChangeLogEntry(log));
                    this.getPersonService().logChanges(changeLogs);
                    stat.incrementRejectFileProcessedCount();
                }
                catch (Exception ex) {
                    stat.incrementRejectFileFailedCount();
                    this.logger.error((Object)("Failed to update comms log status id = " + log.getCommsLogIdString()), (Throwable)ex);
                }
                continue;
            }
            stat.incrementRejectFileFailedCount();
        }
    }

    private void processMailedFile(CommsImportStatistics stat) throws Exception {
        ArrayList mailedFileList = this.fileDAO.readMailedFile(stat);
        if (mailedFileList == null || mailedFileList.isEmpty()) {
            return;
        }
        HashSet<PersonChangeLogEntry> changeLogs = new HashSet<PersonChangeLogEntry>();
        CommsLogEntry log = null;
        MailedFileEntry entry = null;
        for (int i = 0; i < mailedFileList.size(); ++i) {
            entry = (MailedFileEntry)mailedFileList.get(i);
            log = this.commsLogDAO.findCommsLogEntryByBarcode(entry.getBarCode());
            if (log != null) {
                try {
                    log.addMailingStatus(MAILED_BY_AAC_STATUS);
                    log.setMailingDate(entry.getMailedDate());
                    if (log.getRemailIndicator() != null) {
                        log.setRemailIndicator(REMAILED_INDICATOR);
                    }
                    this.commsLogDAO.update(log);
                    stat.updateMailedStatistics(entry);
                    changeLogs.clear();
                    changeLogs.add(this.createPersonChangeLogEntry(log));
                    this.getPersonService().logChanges(changeLogs);
                    stat.incrementMailedFileProcessedCount();
                }
                catch (Exception ex) {
                    stat.incrementMailedFileFailedCount();
                    this.logger.error((Object)("Failed to process mailed file entry id = " + log.getCommsLogIdString()), (Throwable)ex);
                }
                continue;
            }
            stat.incrementMailedFileFailedCount();
        }
    }

    private void updateCommsTransLog(CommsImportStatistics stat) throws DAOException {
        if (stat == null) {
            return;
        }
        CommsTransLog errLog = new CommsTransLog();
        errLog.setTransmissionType(IMPORT_TRANSMISSION_ERROR_TYPE);
        errLog.setFileName(stat.getErrorFileName());
        errLog.setFileProcessStartDate(stat.getErrorFileProcessStartTime());
        errLog.setFileProcessEndDate(stat.getErrorFileProcessEndTime());
        errLog.setFileReceivedDate(stat.getErrorFileReceivedDate());
        errLog.setFileRecordCount(new Integer(stat.getErrorFileRecordCount()));
        this.updateErrorByFormNumber(errLog, stat);
        CommsTransLog rejLog = new CommsTransLog();
        rejLog.setTransmissionType(IMPORT_TRANSMISSION_REJECT_TYPE);
        rejLog.setFileName(stat.getRejectFileName());
        rejLog.setFileProcessStartDate(stat.getRejectFileProcessStartTime());
        rejLog.setFileProcessEndDate(stat.getRejectFileProcessEndTime());
        rejLog.setFileReceivedDate(stat.getRejectFileReceivedDate());
        rejLog.setFileRecordCount(new Integer(stat.getRejectFileRecordCount()));
        this.updateRejectByFormNumber(rejLog, stat);
        CommsTransLog mailedLog = new CommsTransLog();
        mailedLog.setTransmissionType(IMPORT_TRANSMISSION_MAILED_TYPE);
        mailedLog.setFileName(stat.getMailedFileName());
        mailedLog.setFileProcessStartDate(stat.getMailedFileProcessStartTime());
        mailedLog.setFileProcessEndDate(stat.getMailedFileProcessEndTime());
        mailedLog.setFileReceivedDate(stat.getMailedFileReceivedDate());
        mailedLog.setFileRecordCount(new Integer(stat.getMailedFileRecordCount()));
        this.updateMailedByFormNumber(mailedLog, stat);
    }

    private void updateErrorByFormNumber(CommsTransLog errLog, CommsImportStatistics stat) {
        if (errLog == null || stat == null || stat.getErrorPerTypeNumberTable() == null) {
            return;
        }
        String formNumber = null;
        Hashtable errorReasonPerLetterTypeTable = null;
        CommsTransByFormNumber transByForm = null;
        Hashtable errorPerTypeNumberTable = stat.getErrorPerTypeNumberTable();
        Enumeration enumer = errorPerTypeNumberTable.keys();
        while (enumer.hasMoreElements()) {
            transByForm = new CommsTransByFormNumber();
            formNumber = (String)enumer.nextElement();
            transByForm.setFormNumber(formNumber);
            transByForm.setFormNumberRecordCount((Integer)errorPerTypeNumberTable.get(formNumber));
            errorReasonPerLetterTypeTable = stat.getErrorReasonPerLetterTypeTable();
            if (errorReasonPerLetterTypeTable != null) {
                transByForm.setFormNumberErrorReasons(this.getFormNumberErrorReasons((Set)errorReasonPerLetterTypeTable.get(formNumber)));
            }
            errLog.addTransByFormNumber(transByForm);
        }
    }

    private String getFormNumberErrorReasons(Set errorReasons) {
        if (errorReasons == null || errorReasons.isEmpty()) {
            return null;
        }
        Iterator it = errorReasons.iterator();
        StringBuffer str = new StringBuffer();
        while (it.hasNext()) {
            str.append(it.next()).append(ERROR_REASONS_SEPERATOR);
        }
        return str.substring(0, str.length() - 1);
    }

    private void updateRejectByFormNumber(CommsTransLog rejLog, CommsImportStatistics stat) {
        if (rejLog == null || stat == null) {
            return;
        }
        String formNumber = null;
        Hashtable rejectReasonPerLetterTypeTable = null;
        CommsTransByFormNumber transByForm = null;
        Hashtable rejectPerTypeNumberTable = stat.getRejectPerTypeNumberTable();
        Enumeration enumer = rejectPerTypeNumberTable.keys();
        while (enumer.hasMoreElements()) {
            transByForm = new CommsTransByFormNumber();
            formNumber = (String)enumer.nextElement();
            transByForm.setFormNumber(formNumber);
            transByForm.setFormNumberRecordCount((Integer)rejectPerTypeNumberTable.get(formNumber));
            rejectReasonPerLetterTypeTable = stat.getRejectReasonPerLetterTypeTable();
            if (rejectReasonPerLetterTypeTable != null) {
                transByForm.setFormNumberRejectReasons(this.getFormNumberRejectReasons((Set)rejectReasonPerLetterTypeTable.get(formNumber)));
            }
            rejLog.addTransByFormNumber(transByForm);
        }
    }

    private String getFormNumberRejectReasons(Set rejectReasons) {
        if (rejectReasons == null || rejectReasons.isEmpty()) {
            return null;
        }
        Iterator it = rejectReasons.iterator();
        StringBuffer str = new StringBuffer();
        while (it.hasNext()) {
            str.append(it.next()).append(ERROR_REASONS_SEPERATOR);
        }
        return str.substring(0, str.length() - 1);
    }

    private void updateMailedByFormNumber(CommsTransLog mailedLog, CommsImportStatistics stat) {
        if (mailedLog == null || stat == null) {
            return;
        }
        String formNumber = null;
        CommsTransByFormNumber transByForm = null;
        Hashtable mailedPerTypeNumberTable = stat.getMailedPerTypeNumberTable();
        Enumeration enumer = mailedPerTypeNumberTable.keys();
        while (enumer.hasMoreElements()) {
            transByForm = new CommsTransByFormNumber();
            formNumber = (String)enumer.nextElement();
            transByForm.setFormNumber(formNumber);
            transByForm.setFormNumberRecordCount((Integer)mailedPerTypeNumberTable.get(formNumber));
            mailedLog.addTransByFormNumber(transByForm);
        }
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }
}

