/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.filedelegate;

import gov.vha.hvm.dsd.IEndpointLookupService;
import gov.vha.hvm.dsd.IMessageFactoryService;
import gov.vha.hvm.dsd.ITrackingService;
import gov.vha.hvm.dsd.delegates.BaseDeliveryServiceDelegate;
import gov.vha.hvm.dsd.delegates.NoopEndpointLookupService;
import gov.vha.hvm.dsd.delegates.SimpleHapiMessageFactory;
import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.exceptions.HVMException;
import gov.vha.hvm.dsd.exceptions.NonTransactionalDelegateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class FileDelegate
extends BaseDeliveryServiceDelegate {
    public static final String BASEDIR = "dsd.filedelegate.basedir";
    private static final String XMLHEADER = "<?xml version=\"1.0\"?>";
    private String baseDir = null;
    private Properties properties;
    private File outbox;
    private File inbox;

    public void init(Properties properties) throws HVMException {
        super.init(properties);
        if (!properties.containsKey(BASEDIR)) {
            throw new HVMException("Must have a dsd.filedelegate.basedir property.");
        }
        this.baseDir = properties.getProperty(BASEDIR);
        File file = new File(this.baseDir);
        if (!file.canWrite()) {
            throw new HVMException("Directory must exist: " + this.baseDir);
        }
        File file2 = new File(file, this.getOutboxDirName());
        this.outbox = new File(file2, "OUT");
        this.inbox = new File(file2, "IN");
        this.outbox.mkdirs();
        this.inbox.mkdirs();
        if (!this.outbox.canWrite()) {
            throw new HVMException("Could not create outbox directory for " + this.getOutboxDirName());
        }
        this.properties = properties;
    }

    private String getOutboxDirName() {
        String string = this.getSender().toString();
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public IEndpointLookupService getEndpointLookupService() {
        return new NoopEndpointLookupService();
    }

    public IMessageFactoryService getMessageFactoryService() {
        return new SimpleHapiMessageFactory();
    }

    public ITrackingService getTrackingService() {
        return null;
    }

    public void deliverMessage(Envelope envelope) throws HVMException {
        this.writeMessageToFile(envelope);
    }

    public void startTransaction() throws HVMException {
        throw new NonTransactionalDelegateException();
    }

    public void commitTransaction() throws HVMException {
        throw new NonTransactionalDelegateException();
    }

    public void abortTransaction() throws HVMException {
        throw new NonTransactionalDelegateException();
    }

    private void writeMessageToFile(Envelope envelope) throws HVMException {
        File file = new File(this.outbox, envelope.getMessageId());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(XMLHEADER);
            long l = System.currentTimeMillis();
            printStream.println("<message tstamp=\"" + l + "\">");
            this.writeHeader(printStream, envelope);
            this.writeBody(printStream, envelope);
            printStream.println("</message>");
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HVMException("Error writing message to file " + envelope.getMessageId());
        }
    }

    private void writeBody(PrintStream printStream, Envelope envelope) {
        envelope.dumpBody(printStream);
    }

    private void writeHeader(PrintStream printStream, Envelope envelope) {
        envelope.dumpHeaders(printStream);
    }
}

